<?php

namespace App\Http\Controllers;

use App\Exports\StudentMarks;
use App\Models\Exam;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use LaravelMultipleGuards\Traits\FindGuard;
use PDF;
use App\Exports\StudentMarksExport;
use Maatwebsite\Excel\Facades\Excel;
use Carbon\Carbon;
use Intervention\Image\Facades\Image;
use TCPDF;

class Controller extends BaseController
{
    use AuthorizesRequests, ValidatesRequests, FindGuard;
    public $user;
 
public function create()
{
    $this->user = $this->findGuardType()->user();
    
    // Get the current date
    $currentYear = Carbon::now()->year;

    // Calculate the last year
    $lastYear = $currentYear - 1;

    // Fetch exams based on the selected criteria, where created_at date is in the last year
    $users = Exam::query()
        ->where('student_id', $this->user->id)
        ->whereYear('created_at', $lastYear) // Filter by the last year
        ->get();

    $models = [
        'title' => 'COLÉGIO POLITÉCNICO DE MOÇAMBIQUE',
        'date' => date('d/m/Y'),
        'models' => $users,
        'name'=> $this->user->name,
        'id'=>$this->user->student_id,
    ];

    // Generate the PDF
    $pdf = PDF::loadView('exports.userreport', $models);

    // Set options for the PDF (e.g., paper size, orientation, etc.)
    $pdf->setPaper('A4', 'portrait');

    // Add a page number
    $pdf->setOptions(['isPhpEnabled' => true]);

    // Download PDF file with download method
    return $pdf->download($this->user->name.'- resultado.pdf');
}



public function generateExcel()
{
     // Retrieve student marks data grouped by trimester_id
     $studentMarks = Exam::all(); // Modify this query based on your database structure
     $groupedData = [];

     foreach ($studentMarks as $studentMark) {
         $groupedData[] = [
             'trimester_id' => $studentMark->trimester_id,
             'Student Name' => $studentMark->student->name, // Assuming you have a student relationship
             'Subject Names' => $studentMark->subject->name, // Assuming you have a subject relationship
             'Marks' => "ASC1: {$studentMark->ASC1a}, ASC2: {$studentMark->ASC2a}, AT: {$studentMark->AT}",
         ];
     }
    return Excel::download(new StudentMarks($groupedData), 'resultado-estudante.xlsx');
}
}
