<?php

namespace App\Http\Livewire\Admin\Classes;

use App\Models\Admin;
use App\Models\Classroom;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;
class AddClass extends Component
{

    use FindGuard, LivewireAlert;

    public $name,$description,$class,  $validatedData;
    public $updateMode = false;
    public $user;
    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    protected array $rules = [
        'name' => ['required', 'string', 'max:255'],
        'class' => ['required', 'string', 'max:255'],
        'description' => ['required', 'string', 'max:255'],
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function submit()
    {
        $this->validatedData = $this->validate();
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
        //check if the class with same name exists
        // Check if a class with the same name already exists
        $existingClass = Classroom::query()->where('name', $this->name)->where('class', $this->class)->first();
        if ($existingClass) {
            // Class with the same name already exists, handle the situation accordingly
            $this->alert('error', 'Já existe uma sala de aula com o mesmo nome.');
            return back();
        }
        Classroom::Create([
            'name' => $this->name,
            'description' => $this->description,
            'class' => $this->class,
        ]);
        Note::createSystemNotification(Admin::class, 'Nova turma', ' Nova turma criada com sucesso ' . $this->name);
        $this->emit('noteAdded');
        $this->alert('success', 'Nova turma criada com sucesso ' . $this->name);
        $this->reset();
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }
    public function render()
    {
        return view('livewire.admin.classes.add-class');
    }
}
