<?php

namespace App\Http\Livewire\Admin\Paymentconformation;

use App\Models\PaymentConfirmation;

use App\Models\User;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use Note\Note;
use Auth;

class Payments extends Component
{
    // Disable lazy loading for this component
    protected $lazy = false;
    use WithPagination, FindGuard, LivewireAlert;

    public $search, $delete,$slug;

    protected $queryString = ['search'];

    protected string $paginationTheme = 'bootstrap';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public bool $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    public function submit($id)
    {
        
        $this->delete = PaymentConfirmation::query()->firstWhere('slug', $id);
        //dd($this->delete);
        //echo $id;echo $this->delete->slug; exit();
        $this->slug = $this->delete->slug;
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => "confirmed",
            'onDismissed' => 'cancelled',
            'slug'=>$id,
        ]);
    }

    public function confirmed()
    {
        //check if already enrolled
        //$check = Downloadcenter::query()->where('slug',  $this->delete->slug)->first();
        /*if (count($check) >= 1) {
            $this->alert('warning', 'Desculpe, este modelo tem subscritores.');
            return back();
        }*/
        //dd($this->delete,$this->slug);
        //echo $this->delete->slug;exit();
        PaymentConfirmation::where('slug', $this->slug)->delete();
        
        Note::createSystemNotification(Admin::class, 'Conf. de pagamento', 'Deletado com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Deletado com sucesso ');
        return back();
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {
        /*$qq = Downloadcenter::with(['downloadsetings' => function ($query) {
            $query->where('active', "active");
        }])->get();*/
        $qq = PaymentConfirmation::get();
        //dd($qq);
                           
        $user = Auth::user();
        //dd($user);
        
        if(isset($user->role) && $user->role == 0){
            //echo "asd";
            return view('livewire.admin.paymentconfirmation.payments', [
                    'models' => $this->readyToLoad
                        ? PaymentConfirmation::query() ->paginate(10)
                        : []
                ]
            );
        }elseif(!isset($user->role) ){
            $userr = User::where("id",$user->id)->first();
           // echo "asd1";
            return view('livewire.admin.paymentconfirmation.payments', [
                    'models' => $this->readyToLoad
                        ? PaymentConfirmation::query()->orWhere("type","all")->orWhere("class_id",$userr->classroom_id)->paginate(10)
                        : [],
                    'student' => true,    
                ]
            );
        }
        
    }
}



