<?php

namespace App\Http\Livewire\Admin\Reports;

use App\Models\Admin;
use App\Models\Classroom;
use App\Models\User;
use App\Models\Payment;
use App\Models\Project;
use App\Models\Subject;
use Illuminate\Support\Str;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Note\Note;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\ExportExams;
use App\Models\TeacherSubject;

class GenerateReports extends Component
{
    use FindGuard, LivewireAlert;

    public $trimester_id;
    public $class_id;
    public $user_id, $class, $year;
    public $subject_id;
    public $report = [];
    public $reports;
    public bool $readyToLoad = false;

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    public function loadReport()
    {
        $this->readyToLoad = true;
    }

    protected array $rules = [
        'user_id' => ['string', 'nullable'],
        'trimester_id' => ['numeric', 'required'],
        'class_id' => ['string', 'required'],
        'class' => ['string', 'required'],
        'subject_id' => ['string', 'required']
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }
    /**
     * generate report
     * @throws Exception
     */
    public function generateReport()
    {
        $this->validate();
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
        Note::createSystemNotification(Admin::class, 'Relatório trimestral de cada disciplina', 'Relatório gerado com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Relatório gerado com sucesso ');
        $condition = ['class_id' => $this->class_id, 'trimester_id'=>$this->trimester_id, 'subject_id'=> $this->subject_id, 'year'=>$this->year];
        return Excel::download(new ExportExams($condition), Subject::query()->where('id',  $this->subject_id)->first()->name.'.xlsx');
        //get the id

    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {
        $this->user = $this->findGuardType()->user();
         $ccclass =  ($this->class)?$this->class:'1';
        return view('livewire.admin.reports.generate-reports', [
            'subjects' => Subject::join('teacher_subjects', 'subjects.id', '=', 'teacher_subjects.subject_id')
             ->select('subjects.id', 'subjects.name', 'subjects.slug')
             ->where('teacher_subjects.class', $ccclass)->orderBy('subjects.name')->distinct()
             ->get(),//Subject::query()->orderBy('name')->get(),
            'classes' => Classroom::query()->where(function ($query) {
                $query->orWhere('class', $this->class);
            })->get(),
            'teacher' => TeacherSubject::where("teacher_id",$this->user->id)->get(),
            'class_id'=>$ccclass,
        ]);
    }
}