<?php

namespace App\Http\Livewire\Admin\Students;

use App\Models\Admin;
use App\Models\Classroom;
use App\Models\User;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;
use Exception;
use Twilio\Rest\Client;
use Illuminate\Support\Facades\URL;

class EditStudent extends Component
{
    use FindGuard, LivewireAlert;

    public  $user, $model;
    public $name, $classroom_id, $sex,$phone_number,$class, $dob, $email, $student_id;
    public $validatedData;
    public $updateMode = false;

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    public function mount($slug)
    {
        $this->model = User::query()->where('slug',$slug)->first();
        $this->name = $this->model->name;
        $this->sex = $this->model->sex;
        $this->dob = $this->model->dob;
        $this->class = $this->model->class->class ?? '';
	    //$this->class = $this->model->class->class;
        $this->student_id = $this->model->student_id;
        $this->email = $this->model->email;
 	    $this->phone_number = $this->model->phone_number;
        $this->classroom_id = $this->model->classroom_id;
    }

    protected array $rules = [
        'name' => ['required', 'string', 'max:255'],
        'sex' => ['required', 'string', 'max:255'],
        'classroom_id' => ['required', 'string', 'max:255'],
 	'class' => ['required', 'string', 'max:255'],
        'email' => ['required', 'string', 'max:255'],
        'student_id' => ['required', 'string', 'max:255'],
        'dob' => ['required', 'string', 'max:255'],
  	'phone_number' => ['required', 'numeric'],
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function submit()
    {
        $this->validatedData = $this->validate();
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
        $this->model->fill($this->validatedData);
        if ($this->model->isClean()) {
            $this->alert('warning', 'Pelo menos um valor deve mudar.');
            return redirect()->back();
        }
                   // generate password
        $password = rand(100000, 500000);
        $student = User::query()->where('id',$this->model->id)->update([
            'name' => $this->name,
            'sex' => $this->sex,
            'email' => $this->email,
            'student_id' => $this->student_id,
            'classroom_id' => $this->classroom_id,
            'dob' => $this->dob,
            'password' => bcrypt($password),
            'phone_number' => $this->phone_number,
            'is_paid'=>true,
        ]);
        // todo send sms
        try {
            $account_sid = getenv("TWILIO_SID");
            $auth_token = getenv("TWILIO_TOKEN");
            $twilio_number = getenv("TWILIO_FROM");
            $client = new Client($account_sid, $auth_token);
            // Generate the callback URL based on your route
            $callbackUrl = route('login');

            // Include the URL on a new line using \n
            $message = "Caro pai, o seu educando " . $this->name . ", foi registado no sistema de gestao escolar COPMOZ, o seu ID do Estudante: $this->student_id  e a sua senha:" . $password . "\n \nClique no link para aceder o sistema: https://siga.copmoz.ac.mz";
            // Your Messaging Service SID as the senderId
            $senderId = 'MG1cf11ca4502d0ddd50cb5a74cb9b0605';
            $client->messages->create('+258' . $this->phone_number, [
                'from' => $twilio_number,
                'body' => $message,
                'messagingServiceSid' => $senderId, // use the Messaging Service SID as senderId
            ]);
        } catch (Exception $e) {
            $this->alert('error', 'Ocorreu um erro ao enviar SMS');
        }
        Note::createSystemNotification(Admin::class, 'Detalhes', 'Atualizado com sucesso ' . $this->name);
        $this->emit('noteAdded');
        $this->alert('success', 'Atualizado com sucesso ' . $this->name);
        $this->reset();
        return redirect()->route('admin.list.students');
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }
    public function render()
    {
        return view('livewire.admin.students.edit-student', [
          'classes' => Classroom::query()->where(function ($query) {
                $query->orWhere('class', $this->class);
            })->get(),        ]);
    }
}
