<?php

namespace Database\Seeders;

use App\Models\Admin;
use App\Models\User;
use Faker\Factory;
use Illuminate\Database\Seeder;
use Note\Models\Notification;

class NotificationTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // set the count
        $count = 0;
        do {
            foreach (Admin::query()->get() as $admin) {
                Notification::query()->create([
                    'notification_id' => $admin->id,
                    'notification_type' => Admin::class,
                    'subject' => Factory::create()->realText(100),
                    'description' => Factory::create()->realText(),
                ]);
            }

            foreach (User::query()->get() as $user) {
                Notification::query()->create([
                    'notification_id' => $user->id,
                    'notification_type' => User::class,
                    'subject' => Factory::create()->realText(100),
                    'description' => Factory::create()->realText(),
                ]);
            }

            $count++;
        } while ($count <= 10);
    }
}
