<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                            <h5 class="card-title">Lista de professores</h5>
                            <div class="row">
                                <div class="col-md-12">
                                    <input type="search" wire:model="search" placeholder="Pesquisar..."
                                           class="form-control">
                                </div>
                            </div>
                            <div class="table-responsive" wire:init="loadData">
                                @if(count($users))
                                    <table class="table table-hover">
                                        <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col">Nome completo</th>
                                            <th scope="col">Email</th>
                                            <th scope="col">Número celular</th>
                                            <th scope="col">Classe</th>
                                            <th scope="col">Turma</th>
                                            <th scope="col">Discplina</th>
                                            <th scope="col">Estado</th>
                                            <th scope="col">Editar</th>
					                        <th scope="col">Deletar</th>

                                        </tr>
                                        </thead>
                                        <tbody>
                                        @php($count = 1)
                                        @foreach($users as $user)
                                            <tr>
                                                <th scope="row">{{ $count++ }}</th>
                                                <td>{{ $user->teacher->name }}</td>
                                                <td>{{ $user->teacher->email }}</td>
                                                <td>{{ $user->teacher->phone_number }}</td>
                                                <!--<td>{{ $user->class }}</td>-->
                                                <td>{{ \App\Models\Classroom::find($user->classroom_id)->class ??null }}</td>
                                                <td>{{ \App\Models\Classroom::find($user->classroom_id)->name ??null }}</td>
                                                <td>{{ \App\Models\Subject::find($user->subject_id)->name ??null }}</td>
                                                <td>
                                                    @if($user->teacher->is_active)
                                                        <span class="badge bg-success">Activo</span>
                                                    @else
                                                        <span class="badge bg-danger">Suspendido</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <a href="{{route('admin.edit.teacher.subject',$user->id)}}"
                                                       class="btn btn-outline-primary"><span
                                                            class="fa fa-edit"></span>
                                                    </a>
                                                </td>
                                                <td>
                                                    <button wire:click="submit('{{ $user->id }}')"
                                                            class="btn btn-danger btn-sm">Deletar
                                                    </button>
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                    <div class="row float-end">
                                        {{ $users->links() }}
                                    </div>
                                @else
                                    <br>
                                    <br>
                                    <div  class="d-flex justify-content-center">
                                        <div wire:loading class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Processando...</span>
                                        </div>
                                    </div>
                                    <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
