<div>
    <div class="page-content" wire:poll.keep-alive>
        <div class="main-wrapper" wire:init="loadData">
            @if (count($models))
                <div class="row">
                    @foreach ($models as $model)
                        <div class="col-sm-12 col-md-4">
                            <div class="card bg-dark text-white">
                                <img src="{{ $model->media_url }}" class="card-img" alt="...">
                                <div class="card-img-overlay">
                                    <h5 class="card-title">{{ $model->title }}</h5>
                                    <p class="card-text">{!! Str::limit($model->description, 220, ' .......') !!}</p>
                                    <p class="card-text">
                                        <a href="{{ route('user.show.book', $model->slug) }}"
                                            class="btn btn-outline-primary"><span class="fa fa-eye"></span>
                                        </a>
                                        <a href="{{ route('user.show.book.chapter', $model->slug) }}"
                                            class="btn btn-outline-primary"><span class="fa fa-eye">Mostrar capítulos {{ $model->chapters->count() }}</span>
                                        </a>
                                    </p>

                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="row float-end">
                    {{ $models->links() }}
                </div>
            @else
                <br>
                <br>
                <div class="d-flex justify-content-center">
                    <div wire:loading class="spinner-border text-primary" role="status">
                        <span class="sr-only">Processando...</span>
                    </div>
                </div>
                <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
            @endif
        </div>

    </div>
</div>
