<?php

namespace App\Console\Commands;
use Illuminate\Support\Facades\Storage;

use Illuminate\Console\Command;

class TestSftpConnection extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'test:sftp';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        try {
               $disk = Storage::disk('sftp');
               $files = $disk->files('.');
               $this->info("Connected OK! Found " . count($files) . " files.");
               foreach ($files as $f) {
                   $this->line(" - " . $f);
               }
           } catch (\Exception $e) {
               $this->error("SFTP error: " . $e->getMessage());
           }
    }
}
