<?php

namespace App\Exports;

use App\Models\Downloadsetings;
use App\Models\Classroom;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class MatrizesExport implements FromCollection, WithHeadings, ShouldAutoSize, WithStyles
{
    protected $filters;

    public function __construct($filters = [])
    {
        $this->filters = $filters;
    }

    public function collection()
    {
        $query = Downloadsetings::query()
            ->with(['download', 'classroom', 'student'])
            ->whereHas('download', function ($q) {
                $q->whereNull('deleted_at');
            });

        // Aplicar filtros
        if (!empty($this->filters['class'])) {
            $classroomIds = Classroom::where('class', $this->filters['class'])->pluck('id');
            $query->whereIn('class_id', $classroomIds);
        }

        if (!empty($this->filters['turma'])) {
            $query->where('class_id', $this->filters['turma']);
        }

        if (!empty($this->filters['search'])) {
            $query->where(function ($q) {
                $q->where('name', 'like', '%' . $this->filters['search'] . '%')
                  ->orWhereHas('download', function ($dq) {
                      $dq->where('title', 'like', '%' . $this->filters['search'] . '%');
                  });
            });
        }

        if (!empty($this->filters['filter']) && $this->filters['filter'] !== 'all') {
            $query->where('type', $this->filters['filter']);
        }

        $matrizes = $query->orderByDesc('created_at')->get();

        return $matrizes->map(function ($setting) {
            $classroom = $setting->class_id ? Classroom::find($setting->class_id) : null;
            $student = $setting->student_id ? \App\Models\User::find($setting->student_id) : null;
            $download = \App\Models\Downloadcenter::where('slug', $setting->download_id)->first();
            $files = \App\Models\Downloadfile::where('download_id', $setting->download_id)->get();

            $para = '';
            if ($setting->type == 'all') {
                $para = 'Todos';
            } elseif ($setting->type == 'class') {
                $para = 'Classe';
            } elseif ($setting->type == 'student') {
                $para = 'Estudante';
            }

            $ficheiros = $files->pluck('media_name')->filter()->implode(', ');

            return [
                'para' => $para,
                'classe' => $classroom ? $classroom->class . 'ª Classe ' . $classroom->name : '-',
                'estudante' => $student ? $student->name : '-',
                'titulo' => $download ? $download->title : '-',
                'ficheiro' => $ficheiros ?: '-',
                'ficheiro_url' => $files->first() ? $files->first()->media_url : null,
                'ficheiros' => $files,
                'data' => $setting->created_at->format('d/m/Y H:i'),
            ];
        });
    }

    public function headings(): array
    {
        return [
            'Para',
            'Classe',
            'Estudante',
            'Título',
            'Ficheiro',
            'Data de Lançamento',
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
}
