<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Font;

class ExcelTemplateController extends Controller
{
    /**
     * Download Excel template for batch marks import
     */
    public function downloadMarksTemplate()
    {
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        // Set sheet title
        $sheet->setTitle('Modelo de Notas');

        // Headers
        $headers = [
            'A1' => 'ID do Estudante',
            'B1' => 'Nome do Estudante',
            'C1' => 'Nota'
        ];

        // Set headers
        foreach ($headers as $cell => $value) {
            $sheet->setCellValue($cell, $value);
        }

        // Style the header row
        $headerStyle = [
            'font' => [
                'bold' => true,
                'color' => ['argb' => 'FFFFFFFF'],
            ],
            'fill' => [
                'fillType' => Fill::FILL_SOLID,
                'startColor' => ['argb' => 'FF2596BE'],
            ],
            'alignment' => [
                'horizontal' => Alignment::HORIZONTAL_CENTER,
                'vertical' => Alignment::VERTICAL_CENTER,
            ],
        ];

        $sheet->getStyle('A1:C1')->applyFromArray($headerStyle);

        // Add sample data
        $sampleData = [
            ['EST001', 'João Silva', '15.5'],
            ['EST002', 'Maria Santos', '17.0'],
            ['EST003', 'Pedro Costa', '12.75'],
        ];

        $row = 2;
        foreach ($sampleData as $data) {
            $sheet->setCellValue('A' . $row, $data[0]);
            $sheet->setCellValue('B' . $row, $data[1]);
            $sheet->setCellValue('C' . $row, $data[2]);
            $row++;
        }

        // Auto-size columns
        foreach (range('A', 'C') as $column) {
            $sheet->getColumnDimension($column)->setAutoSize(true);
        }

        // Add instructions sheet
        $instructionsSheet = $spreadsheet->createSheet();
        $instructionsSheet->setTitle('Instruções');

        $instructions = [
            'INSTRUÇÕES PARA IMPORTAÇÃO DE NOTAS',
            '',
            '1. Formato do arquivo:',
            '   - Use apenas as colunas: ID do Estudante, Nome do Estudante, Nota',
            '   - O ID do Estudante deve corresponder exatamente ao ID cadastrado no sistema',
            '   - As notas devem estar entre 0 e 20',
            '   - Use ponto (.) para separar decimais (ex: 15.5)',
            '',
            '2. Antes de importar:',
            '   - Selecione o ano, trimestre, classe, turma, disciplina e tipo de teste no sistema',
            '   - Certifique-se de que todos os estudantes pertencem à turma selecionada',
            '',
            '3. Formatos aceitos:',
            '   - Excel (.xlsx, .xls)',
            '   - CSV (.csv)',
            '',
            '4. Observações importantes:',
            '   - Linhas em branco serão ignoradas',
            '   - Se um estudante já tiver nota para o tipo de teste selecionado, você será questionado sobre substituição',
            '   - O sistema validará se o estudante existe na turma selecionada',
            '',
            '5. Em caso de erro:',
            '   - Verifique se os IDs dos estudantes estão corretos',
            '   - Confirme se as notas estão no formato numérico correto',
            '   - Certifique-se de que todos os campos obrigatórios estão preenchidos no sistema',
        ];

        $row = 1;
        foreach ($instructions as $instruction) {
            $instructionsSheet->setCellValue('A' . $row, $instruction);
            if ($row === 1) {
                // Style the title
                $instructionsSheet->getStyle('A1')->applyFromArray([
                    'font' => [
                        'bold' => true,
                        'size' => 14,
                        'color' => ['argb' => 'FF2596BE'],
                    ],
                ]);
            }
            $row++;
        }

        // Auto-size column A in instructions
        $instructionsSheet->getColumnDimension('A')->setAutoSize(true);

        // Set active sheet back to the data sheet
        $spreadsheet->setActiveSheetIndex(0);

        // Create writer
        $writer = new Xlsx($spreadsheet);

        // Set headers for download
        $filename = 'modelo_notas_' . date('Y-m-d') . '.xlsx';

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');

        // Write to output
        $writer->save('php://output');
        exit;
    }
}
