<?php

namespace App\Http\Livewire\Admin\Settings;

use App\Models\POS\Setting;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Component;

class IvaSettings extends Component
{
    use LivewireAlert;

    public $tax_rate;

    protected $rules = [
        'tax_rate' => 'required|numeric|min:0|max:100',
    ];

    protected $messages = [
        'tax_rate.required' => 'A taxa de IVA é obrigatória.',
        'tax_rate.numeric' => 'A taxa de IVA deve ser um número.',
        'tax_rate.min' => 'A taxa de IVA não pode ser negativa.',
        'tax_rate.max' => 'A taxa de IVA não pode exceder 100%.',
    ];

    public function mount()
    {
        $this->loadTaxRate();
    }

    public function loadTaxRate()
    {
        $this->tax_rate = Setting::get('tax_rate', 16.00);
    }

    public function saveTaxRate()
    {
        $this->validate();

        try {
            Setting::set('tax_rate', $this->tax_rate, 'number');

            $this->alert('success', 'Taxa de IVA atualizada com sucesso!', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
            ]);
        } catch (\Exception $e) {
            $this->alert('error', 'Erro ao atualizar taxa de IVA: ' . $e->getMessage(), [
                'position' => 'top-end',
                'timer' => 5000,
                'toast' => true,
            ]);
        }
    }

    public function resetToDefault()
    {
        $this->tax_rate = 16.00;
        $this->saveTaxRate();
    }

    public function render()
    {
        return view('livewire.admin.settings.iva-settings');
    }
}
