<?php

namespace App\Http\Livewire\Admin\Students;

use App\Models\User;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use Note\Note;

class ListPaidStudents extends Component
{
    protected $lazy = false;
    use WithPagination, FindGuard, LivewireAlert;

    public $search, $delete;
    public $selectedClass = '';
    public $selectedTurma = '';
    public $turmas = [];

    protected $queryString = ['search', 'selectedClass', 'selectedTurma'];

    protected string $paginationTheme = 'bootstrap';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function updatedSelectedClass($value)
    {
        $this->selectedTurma = '';
        $this->resetPage();

        if ($value) {
            $this->turmas = \App\Models\Classroom::where('class', $value)->get();
        } else {
            $this->turmas = [];
        }
    }

    public function updatedSelectedTurma()
    {
        $this->resetPage();
    }

    public function exportPDF()
    {
        return redirect()->route('admin.paid.students.export.pdf', [
            'class' => $this->selectedClass,
            'turma' => $this->selectedTurma,
            'search' => $this->search
        ]);
    }

    public function exportExcel()
    {
        return redirect()->route('admin.paid.students.export.excel', [
            'class' => $this->selectedClass,
            'turma' => $this->selectedTurma,
            'search' => $this->search
        ]);
    }

    public bool $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    protected $listeners = [
        'confirmed',
        'cancelled',
        'complete'
    ];

    public function submit($id)
    {
        $this->delete = User::query()->firstWhere('id', $id);
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function submitcomplete($id)
    {
        $this->delete = User::query()->firstWhere('id', $id);
        $this->confirm('Tem certeza de que deseja marcar como não pago?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'complete',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function complete()
    {
        User::query()
            ->where('id', $this->delete->id)
            ->update([
                'is_paid' => false,
            ]);
        Note::createSystemNotification(User::class, 'Estudante', 'Marcado como não pago com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Marcado como não pago com sucesso');
        return back();
    }

    public function confirmed()
    {
        User::where('id', $this->delete->id)->delete();
        Note::createSystemNotification(\App\Models\Admin::class, 'Estudante', 'Deletado com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Deletado com sucesso ');
        $this->reset();
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {
        $classes = \App\Models\Classroom::select('class')->distinct()->orderByRaw('CAST(class AS UNSIGNED)')->get();

        return view('livewire.admin.students.list-paid-students', [
                'models' => $this->readyToLoad
                    ? User::query()
                        ->where('is_paid', true)
                        ->when($this->search, function ($query) {
                            $query->where(function ($q) {
                                $q->where('name', 'like', '%' . $this->search . '%')
                                  ->orWhere('slug', 'like', '%' . $this->search . '%')
                                  ->orWhere('student_id', 'like', '%' . $this->search . '%')
                                  ->orWhere('email', 'like', '%' . $this->search . '%');
                            });
                        })
                        ->when($this->selectedClass, function ($query) {
                            $query->whereHas('class', function ($subQuery) {
                                $subQuery->where('class', $this->selectedClass);
                            });
                        })
                        ->when($this->selectedTurma, function ($query) {
                            $query->where('classroom_id', $this->selectedTurma);
                        })
   			 ->orderBy('name')
                        ->paginate(10)
                    : [],
                'classes' => $classes,
                'turmas' => $this->turmas
            ]
        );
    }
}
