<?php

namespace App\Http\Livewire\Admin\Teachers;

use App\Models\Admin;
use App\Models\Subject;
use App\Models\TeacherSubject;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;
use App\Models\Classroom;

class EditAssignSubject extends Component
{
    use FindGuard, LivewireAlert;

    public $name, $teacher_id,$subject_id,$classroom_id,$class, $model;
    public $validatedData;
    public $updateMode = false;

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];
    
    protected array $rules = [
        'teacher_id' => ['required', 'string', 'max:255'],
        'subject_id' => ['required', 'string', 'max:255'],
        'classroom_id' => ['required', 'string', 'max:255'],
        'class' => ['required', 'string', 'max:255'],
    ];


    public function mount($id)
    {
        $this->model = TeacherSubject::query()->where('id',$id)->first();
        $this->teacher_id = $this->model->teacher_id ??null;
        $this->subject_id = $this->model->subject_id ??null;
        $this->classroom_id = $this->model->classroom_id ??null;
        $this->class = $this->model->class ??null;
    }



    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function submit()
    {
        $this->validatedData = $this->validate();
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
        TeacherSubject::query()->where('id', $this->model->id)->update([
            'teacher_id' => $this->teacher_id,
            'subject_id' => $this->subject_id,
            'classroom_id' => $this->classroom_id,
            'class' => $this->class,
        ]);
        Note::createSystemNotification(Admin::class, 'model details', 'Atualizado com sucesso' . $this->model->teacher->name);
        $this->emit('noteAdded');
        $this->alert('success', 'Atualizado com sucesso' . $this->model->teacher->name);
        $this->reset();
        return redirect()->route('admin.list.teachers');
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }
    public function render()
    {

        return view('livewire.admin.teachers.edit-assign-subject', [
            'subjects' => Subject::query()->orderBy('name')->get(),
            'teachers' => Admin::query()->orderBy('name')->where('role', 2)->get(),
            'classes' => Classroom::query()->where(function ($query) {
                $query->orWhere('class', $this->class);
            })->get(),
        ]);
    }
}
