<?php

namespace App\Http\Livewire\Admin\Teachers;

use App\Models\Admin;
use App\Models\Classroom;
use App\Models\Subject;
use App\Models\TeacherSubject;
use Livewire\Component;
use Livewire\WithPagination;
use Jantinnerezo\LivewireAlert\LivewireAlert;

class ViewTeacherAssignments extends Component
{
    use WithPagination, LivewireAlert;
    protected $paginationTheme = 'bootstrap';

    public $searchProfessor = '';
    public $searchSubject = '';
    public $searchClass = '';
    public $filterYear;

    protected $listeners = [
        'confirmRemove',
        'cancelRemove'
    ];

    public function mount()
    {
        $this->filterYear = (int) date('Y');
    }

    public function updating($property)
    {
        if (in_array($property, ['searchProfessor', 'searchSubject', 'searchClass', 'filterYear'])) {
            $this->resetPage();
        }
    }

    public function removeAssignment($id)
    {
        $this->confirm('Tem certeza que deseja remover esta atribuição?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, remover!',
            'cancelButtonText' => 'Cancelar',
            'onConfirmed' => 'confirmRemove',
            'onDismissed' => 'cancelRemove',
            'inputAttributes' => ['id' => $id],
        ]);
    }

    public function confirmRemove($data)
    {
        $id = $data['inputAttributes']['id'] ?? null;

        if ($id) {
            $deleted = TeacherSubject::where('id', $id)->delete();

            if ($deleted) {
                $this->alert('success', 'Atribuição removida com sucesso.');
            } else {
                $this->alert('error', 'Erro ao remover atribuição.');
            }
        }
    }

    public function cancelRemove()
    {
        $this->alert('info', 'Operação cancelada.');
    }

    public function getAvailableYearsProperty()
    {
        $currentYear = (int) date('Y');
        $startYear = 2023; // Ano inicial
        $endYear = $currentYear; // Apenas até ano corrente

        $years = [];
        for ($year = $endYear; $year >= $startYear; $year--) {
            $years[] = $year;
        }

        return $years;
    }

    public function render()
    {
        $assignedSubjects = TeacherSubject::with(['teacher', 'subject', 'classroom'])
            ->when($this->filterYear, fn($q) =>
                $q->where('year', $this->filterYear)
            )
            ->when($this->searchProfessor, fn($q) =>
                $q->whereHas('teacher', fn($q2) =>
                    $q2->where('name', 'like', '%' . $this->searchProfessor . '%')
                )
            )
            ->when($this->searchSubject, fn($q) =>
                $q->whereHas('subject', fn($q2) =>
                    $q2->where('name', 'like', '%' . $this->searchSubject . '%')
                )
            )
            ->when($this->searchClass, fn($q) =>
                $q->where('class', $this->searchClass)
            )
            ->orderBy('class')
            ->orderBy('created_at', 'desc')
            ->paginate(15);

        return view('livewire.admin.teachers.view-teacher-assignments', [
            'assignedSubjects' => $assignedSubjects,
            'availableYears' => $this->availableYears,
        ]);
    }
}
