<?php

namespace App\Http\Livewire\Auth;

use App\Models\SystemSetting;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Component;

class Login extends Component
{
    // Disable lazy loading for this component
    protected $lazy = false;
    use LivewireAlert;

    public $student_id;
    public $password;
    public $remember;

    public function mount()
    {
        // check if user is already authorized
        if (Auth::check())
            return redirect()->route('user.home');
    }

    protected array $rules = [
        'student_id' => ['required', 'string', 'exists:users'],
        'password' => ['required', 'string'],
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    /**
     * login the user here
     * @return RedirectResponse
     */
    public function loginUser()
    {
        $this->validate();

        if (Auth::attempt(['student_id' => $this->student_id, 'password' => $this->password, 'is_active' => true], $this->remember)) {
            // Authentication passed...
            return redirect()->route('user.home');
        }

        $this->reset(['password']);
        $this->alert('error', 'As credenciais fornecidas não correspondem aos nossos registros.');
    }

    public function render()
    {
        $preEnrollmentOpen = (bool) SystemSetting::get('renewal_period_open', false, 'enrollment');

        return view('livewire.auth.login', [
            'preEnrollmentOpen' => $preEnrollmentOpen,
        ])->layout('layouts.auth');
    }
}
