<?php

namespace App\Http\Livewire\Guardian\Inc;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Livewire\Component;

class Sidebar extends Component
{
    protected $listeners = ['studentSwitched' => '$refresh'];

    public function render()
    {
        $guardian = Auth::guard('guardian')->user();
        $students = $guardian
            ? $guardian->students()->with('classroom')->get()
            : collect([]);
        $activeStudent = $students->firstWhere('id', Session::get('guardian_student_id'));

        return view('livewire.guardian.inc.sidebar', [
            'activeStudent' => $activeStudent,
        ]);
    }
}
