<?php

namespace App\Http\Livewire\User\Books;

use App\Models\Book;
use App\Models\BookTitle;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use Note\Note;

class UserShowPrefferedBooks extends Component
{
    use WithPagination, FindGuard, LivewireAlert;

    public $search, $delete;
    public $user;
    protected $queryString = ['search'];

    protected string $paginationTheme = 'bootstrap';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public bool $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    public function submit($id)
    {
        $this->delete = Book::query()->firstWhere('id', $id);
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
        //check if already enrolled
        $check = BookTitle::query()->where('book_id', $this->delete->id)->get();
        if (count($check) >= 1) {
            $this->alert('warning', 'Desculpe, este modelo tem capítulos');
            return back();
        }
        Book::where('id', $this->delete->id)->delete();
        Note::createSystemNotification(Admin::class, 'Livro', 'Deletado com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Deletado com sucesso ');
        $this->reset();
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {
        $this->user = $this->findGuardType()->user();
        return view(
            'livewire.user.books.user-show-preffered-books',
            [
                'models' => $this->readyToLoad
                    ? Book::query()
                    ->latest('updated_at')
                    ->whereRelation('book_status', 'is_preferred', true)
                    ->whereRelation('book_status', 'user_id', $this->user->id)
                    ->where(function ($query) {
                        $query->orWhere('title', 'like', '%' . $this->search . '%')
                            ->orWhere('slug', 'like', '%' . $this->search . '%');
                    })
                    ->paginate(50)
                    : []
            ]
        );
    }
}
