<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class BmepsFile extends Model
{
    protected $table = 'bmeps_files';

    protected $fillable = [
        'filename',
        'file_path',
        'file_size',
        'processed_at',
        'processing_time',
        'total_records',
        'total_amount',
        'total_commission',
        'reconciled_count',
        'unreconciled_count',
        'processing_status',
        'source',
        'error_message',
        'processed_by',
        'company_id',
        'profile_id',
        'file_creation_date',
        'file_sequence',
    ];

    protected $casts = [
        'processed_at' => 'datetime',
        'file_creation_date' => 'datetime',
        'processing_time' => 'decimal:2',
        'total_amount' => 'decimal:2',
        'total_commission' => 'decimal:2',
    ];

    public function transactions(): HasMany
    {
        return $this->hasMany(BmepsTransaction::class, 'bmeps_file_id');
    }
}