<?php

namespace App\Models;

use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;
use Illuminate\Database\Eloquent\SoftDeletes;

class Downloadcenter extends Model
{
    //use HasFactory;
    use HasFactory, Uuids, SoftDeletes, HasSlug;
    protected $fillable = [
        'title',
        'author',
        'slug',
        'category_id',
        'description',
        //'media_name',
        //'media_url',
        
    ];

    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('title')
            ->saveSlugsTo('slug')
            ->doNotGenerateSlugsOnUpdate(); // Don't regenerate slug on update
    }
}
