<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FailedReconciliation extends Model
{
    use HasFactory;

    protected $fillable = [
        'reference_number',
        'transaction_id',
        'terminal_id',
        'amount',
        'payment_date',
        'entity_code',
        'error_reason',
        'file_name',
        'raw_content',
        'status',
        'resolved_by',
        'resolved_at',
        'resolution_notes',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'payment_date' => 'date',
        'resolved_at' => 'datetime',
    ];

    public function resolver()
    {
        return $this->belongsTo(User::class, 'resolved_by');
    }

    public function markAsResolved($notes = null)
    {
        $this->update([
            'status' => 'resolved',
            'resolved_by' => auth()->id(),
            'resolved_at' => now(),
            'resolution_notes' => $notes,
        ]);
    }

    public function markAsIgnored($notes = null)
    {
        $this->update([
            'status' => 'ignored',
            'resolved_by' => auth()->id(),
            'resolved_at' => now(),
            'resolution_notes' => $notes,
        ]);
    }
}
