<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class IvaTransaction extends Model
{
    use HasFactory, HasUuids, SoftDeletes;

    protected $fillable = [
        'transaction_date',
        'transaction_type',
        'category',
        'description',
        'student_id',
        'student_name',
        'nuit_cliente',
        'price_shown',
        'price_includes_iva',
        'iva_rate',
        'base_amount',
        'iva_amount',
        'total_amount',
        'reference_number',
        'invoice_number',
        'related_id',
        'related_type',
        'metadata',
        'created_by',
    ];

    protected $casts = [
        'transaction_date' => 'date',
        'price_shown' => 'decimal:2',
        'iva_rate' => 'decimal:2',
        'base_amount' => 'decimal:2',
        'iva_amount' => 'decimal:2',
        'total_amount' => 'decimal:2',
        'price_includes_iva' => 'boolean',
        'metadata' => 'array',
    ];

    // Relationships
    public function student()
    {
        return $this->belongsTo(User::class, 'student_id');
    }

    public function creator()
    {
        return $this->belongsTo(Admin::class, 'created_by');
    }

    // Scopes
    public function scopeForPeriod($query, $startDate, $endDate)
    {
        return $query->whereBetween('transaction_date', [$startDate, $endDate]);
    }

    public function scopeSales($query)
    {
        return $query->where('transaction_type', 'sale');
    }

    public function scopePurchases($query)
    {
        return $query->where('transaction_type', 'purchase');
    }

    public function scopeByCategory($query, $category)
    {
        return $query->where('category', $category);
    }
}
