<?php

namespace App\Models;

use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class TeacherSubject extends Model
{
    use HasFactory, Uuids, SoftDeletes;

    /**
     * stop the auto increment
     */
    public $incrementing = false;

    /**
     * type of auto-increment
     *
     * @string
     */
    protected $keyType = 'string';

    protected $fillable = [
        'subject_id',
        'teacher_id',
        'classroom_id',
        'class',
        'year'
    ];

    /**
     * Scope to filter by academic year
     */
    public function scopeYear($query, $year)
    {
        return $query->where('year', $year);
    }

    /**
     * Scope to filter by current year
     */
    public function scopeCurrentYear($query)
    {
        return $query->where('year', date('Y'));
    }
       /**
     * instructor
     * @return BelongsTo
     */
    public function subject(): BelongsTo
    {
        return $this->belongsTo(Subject::class,'subject_id');
    }
           /**
     * instructor
     * @return BelongsTo
     */
    public function teacher(): BelongsTo
    {
        //I have added teacher_id here
        return $this->belongsTo(Admin::class, 'teacher_id');
    }
           /**
     * instructor
     * @return BelongsTo
     */
    public function classroom(): BelongsTo
    {
        return $this->belongsTo(Classroom::class,'classroom_id');
    }
}
