<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('pos_settings', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('key')->unique();
            $table->text('value')->nullable();
            $table->string('type')->default('string'); // string, boolean, number, json
            $table->text('description')->nullable();
            $table->timestamps();
        });

        // Inserir configurações padrão
        DB::table('pos_settings')->insert([
            [
                'id' => (string) Str::uuid(),
                'key' => 'tax_enabled',
                'value' => 'false',
                'type' => 'boolean',
                'description' => 'Ativar/Desativar IVA nas vendas',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => (string) Str::uuid(),
                'key' => 'tax_rate',
                'value' => '17',
                'type' => 'number',
                'description' => 'Taxa de IVA em percentagem (17% em Moçambique)',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => (string) Str::uuid(),
                'key' => 'store_name',
                'value' => 'COPMOZ Store',
                'type' => 'string',
                'description' => 'Nome da loja',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => (string) Str::uuid(),
                'key' => 'sale_number_prefix',
                'value' => 'POS',
                'type' => 'string',
                'description' => 'Prefixo do número de venda (POS, FAT, REC, VD, etc.)',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => (string) Str::uuid(),
                'key' => 'receipt_footer',
                'value' => 'Obrigado pela sua compra!',
                'type' => 'string',
                'description' => 'Mensagem de rodapé do recibo',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }

    public function down()
    {
        Schema::dropIfExists('pos_settings');
    }
};
