<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('document_scans', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->uuid('student_id')->nullable();
            $table->string('student_code')->nullable(); // Código do aluno (ex: CPME-1004)

            // Arquivo da imagem
            $table->string('image_path');
            $table->string('image_filename');
            $table->integer('image_size')->nullable();

            // Status do processamento
            $table->enum('status', ['pending', 'processing', 'processed', 'confirmed', 'failed'])->default('pending');
            $table->text('error_message')->nullable();

            // Dados extraídos do OCR
            $table->text('raw_ocr_text')->nullable(); // Texto bruto do OCR
            $table->json('ocr_data')->nullable(); // Dados estruturados extraídos

            // Dados do documento (extraídos e/ou confirmados)
            $table->string('document_id')->nullable(); // Número do BI
            $table->string('document_type')->nullable(); // BI, DIRE, etc
            $table->string('full_name')->nullable();
            $table->date('dob')->nullable(); // Data de nascimento
            $table->string('father_name')->nullable();
            $table->string('mother_name')->nullable();
            $table->string('birth_place')->nullable(); // Local de nascimento
            $table->string('birth_district')->nullable();
            $table->string('birth_province')->nullable();
            $table->string('sex')->nullable(); // M/F

            // Confiança do OCR (0-100)
            $table->integer('confidence_score')->nullable();

            // Controle
            $table->uuid('uploaded_by')->nullable();
            $table->uuid('confirmed_by')->nullable();
            $table->timestamp('confirmed_at')->nullable();
            $table->boolean('requires_review')->default(true);

            $table->timestamps();
            $table->softDeletes();

            // Índices
            $table->index('student_id');
            $table->index('student_code');
            $table->index('status');
            $table->index('document_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('document_scans');
    }
};
