<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('document_scans', function (Blueprint $table) {
            // Lado do documento
            $table->enum('document_side', ['frente', 'verso', 'ambos'])->default('frente')->after('image_size');

            // Imagem do verso
            $table->string('back_image_path')->nullable()->after('document_side');
            $table->string('back_image_filename')->nullable()->after('back_image_path');
            $table->integer('back_image_size')->nullable()->after('back_image_filename');

            // OCR do verso
            $table->longText('back_raw_ocr_text')->nullable()->after('back_image_size');
            $table->json('back_ocr_data')->nullable()->after('back_raw_ocr_text');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('document_scans', function (Blueprint $table) {
            $table->dropColumn([
                'document_side',
                'back_image_path',
                'back_image_filename',
                'back_image_size',
                'back_raw_ocr_text',
                'back_ocr_data',
            ]);
        });
    }
};
