<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('fee_group', function (Blueprint $table) {
            $table->enum('fine_type', ['percentage', 'fixed'])->default('percentage')->after('default_description');
            $table->decimal('percentage', 5, 2)->nullable()->after('fine_type')->comment('Percentage for penalty calculation');
            $table->decimal('fixed_amount', 10, 2)->nullable()->after('percentage')->comment('Fixed amount for penalty');
            $table->integer('grace_days')->default(0)->after('fixed_amount')->comment('Days before penalty applies');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('fee_group', function (Blueprint $table) {
            $table->dropColumn(['fine_type', 'percentage', 'fixed_amount', 'grace_days']);
        });
    }
};
