<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('fee_structures', function (Blueprint $table) {
            // Offset em meses para o início do pagamento (ex: -1 = mês anterior, 0 = mesmo mês)
            $table->integer('payment_start_offset_months')->default(-1)->after('payment_start_day')
                ->comment('Months offset for payment start date (-1 = previous month, 0 = same month, +1 = next month)');

            // Offset em meses para o vencimento (ex: 0 = mesmo mês)
            $table->integer('payment_due_offset_months')->default(0)->after('payment_due_day')
                ->comment('Months offset for payment due date (0 = same month as fee month)');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('fee_structures', function (Blueprint $table) {
            $table->dropColumn(['payment_start_offset_months', 'payment_due_offset_months']);
        });
    }
};
