<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('send_sms', function (Blueprint $table) {
            // Add statistics columns
            if (!Schema::hasColumn('send_sms', 'total_sent')) {
                $table->integer('total_sent')->default(0)->after('description');
            }
            if (!Schema::hasColumn('send_sms', 'success_count')) {
                $table->integer('success_count')->default(0)->after('total_sent');
            }
            if (!Schema::hasColumn('send_sms', 'fail_count')) {
                $table->integer('fail_count')->default(0)->after('success_count');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('send_sms', function (Blueprint $table) {
            if (Schema::hasColumn('send_sms', 'total_sent')) {
                $table->dropColumn('total_sent');
            }
            if (Schema::hasColumn('send_sms', 'success_count')) {
                $table->dropColumn('success_count');
            }
            if (Schema::hasColumn('send_sms', 'fail_count')) {
                $table->dropColumn('fail_count');
            }
        });
    }
};
