<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('attendances', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('student_id');
            $table->string('classroom_id');
            $table->string('recorded_by');
            $table->date('date');
            $table->string('status');
            $table->text('observation')->nullable();
            $table->string('year');
            $table->softDeletes();
            $table->timestamps();

            $table->index(['classroom_id', 'date']);
            $table->index(['student_id', 'date']);
            $table->index(['student_id', 'year']);
            $table->unique(['student_id', 'classroom_id', 'date'], 'attendance_unique');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('attendances');
    }
};
