-- =====================================================
-- COPMOZ - Migrations Outubro a Dezembro 2025
-- Arquivo SQL único para aplicar todas as alterações
-- =====================================================
-- IMPORTANTE: Execute com cuidado em produção!
-- Recomendado fazer backup antes de executar
-- =====================================================

-- =====================================================
-- 1. DEZEMBRO 2024 - SMS Logs Table
-- =====================================================
CREATE TABLE IF NOT EXISTS `sms_logs` (
    `id` CHAR(36) NOT NULL PRIMARY KEY,
    `gateway` VARCHAR(50) NOT NULL DEFAULT 'movitel' COMMENT 'movitel, twilio',
    `phone_number` VARCHAR(20) NOT NULL,
    `message` TEXT NOT NULL,
    `message_id` VARCHAR(255) NULL COMMENT 'External message ID from gateway',
    `status` ENUM('pending', 'sent', 'failed', 'delivered') NOT NULL DEFAULT 'pending',
    `error` TEXT NULL,
    `response` JSON NULL COMMENT 'Full API response',
    `scheduled_at` TIMESTAMP NULL,
    `sent_by` CHAR(36) NULL,
    `created_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `sms_logs_gateway_index` (`gateway`),
    INDEX `sms_logs_status_index` (`status`),
    INDEX `sms_logs_phone_number_index` (`phone_number`),
    INDEX `sms_logs_created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =====================================================
-- 2. DEZEMBRO 2024 - System Settings Table
-- =====================================================
CREATE TABLE IF NOT EXISTS `system_settings` (
    `id` CHAR(36) NOT NULL PRIMARY KEY,
    `group` VARCHAR(50) NOT NULL DEFAULT 'general' COMMENT 'sms, email, payment, etc.',
    `key` VARCHAR(100) NOT NULL,
    `value` TEXT NULL,
    `type` VARCHAR(20) NOT NULL DEFAULT 'string' COMMENT 'string, boolean, number, json',
    `description` VARCHAR(255) NULL,
    `created_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY `system_settings_group_key_unique` (`group`, `key`),
    INDEX `system_settings_group_index` (`group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Inserir configurações padrão de SMS
INSERT IGNORE INTO `system_settings` (`id`, `group`, `key`, `value`, `type`, `description`, `created_at`, `updated_at`) VALUES
(UUID(), 'sms', 'gateway', 'movitel', 'string', 'Gateway SMS activo (movitel ou twilio)', NOW(), NOW()),
(UUID(), 'sms', 'movitel_api_url', 'https://sms.itcore.app/api/http/sms/send', 'string', 'URL da API Movitel', NOW(), NOW()),
(UUID(), 'sms', 'movitel_api_token', '', 'string', 'Token da API Movitel', NOW(), NOW()),
(UUID(), 'sms', 'movitel_sender_id', 'COPMOZ', 'string', 'Sender ID para Movitel', NOW(), NOW()),
(UUID(), 'sms', 'twilio_sid', '', 'string', 'Twilio Account SID', NOW(), NOW()),
(UUID(), 'sms', 'twilio_token', '', 'string', 'Twilio Auth Token', NOW(), NOW()),
(UUID(), 'sms', 'twilio_from', 'COPMOZ', 'string', 'Twilio From Number/Name', NOW(), NOW()),
(UUID(), 'sms', 'country_code', '258', 'string', 'Código do país (Moçambique: 258)', NOW(), NOW()),
(UUID(), 'sms', 'log_messages', 'true', 'boolean', 'Guardar log de mensagens enviadas', NOW(), NOW());

-- =====================================================
-- 3. OUTUBRO 2025 - Add academic_year to fee_structures
-- =====================================================
SET @col_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'fee_structures' AND COLUMN_NAME = 'academic_year');
SET @sql = IF(@col_exists = 0, 'ALTER TABLE `fee_structures` ADD COLUMN `academic_year` VARCHAR(20) NULL AFTER `fee_name`', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- =====================================================
-- 4. OUTUBRO 2025 - Create receipt_numbers table
-- =====================================================
CREATE TABLE IF NOT EXISTS `receipt_numbers` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `receipt_type` VARCHAR(20) NOT NULL COMMENT 'fee_assign ou payment_reference',
    `record_id` BIGINT UNSIGNED NOT NULL COMMENT 'ID do registro original',
    `receipt_number` VARCHAR(20) NOT NULL COMMENT 'Número do recibo (ex: 000001/2025)',
    `issued_at` TIMESTAMP NOT NULL COMMENT 'Data de emissão do recibo',
    `issued_by` VARCHAR(50) NOT NULL COMMENT 'admin ou student',
    `user_id` BIGINT UNSIGNED NULL COMMENT 'ID do usuário que gerou',
    `created_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY `receipt_numbers_receipt_number_unique` (`receipt_number`),
    INDEX `receipt_numbers_receipt_type_record_id_index` (`receipt_type`, `record_id`),
    INDEX `receipt_numbers_issued_at_index` (`issued_at`),
    INDEX `receipt_numbers_issued_by_index` (`issued_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =====================================================
-- 5. OUTUBRO 2025 - Create fee_month_deadlines table
-- =====================================================
CREATE TABLE IF NOT EXISTS `fee_month_deadlines` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `month` VARCHAR(255) NOT NULL COMMENT 'Janeiro, Fevereiro, Março, etc.',
    `year` INT NOT NULL COMMENT '2025, 2026, etc.',
    `deadline` DATE NULL COMMENT 'Data limite para gerar referência (null = sem limite)',
    `allow_late_payment` TINYINT(1) NOT NULL DEFAULT 1 COMMENT 'Permitir pagamento após prazo',
    `notes` TEXT NULL COMMENT 'Observações administrativas',
    `created_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY `fee_month_deadlines_month_year_unique` (`month`, `year`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =====================================================
-- 6. OUTUBRO 2025 - Add description to noticeboards
-- =====================================================
SET @col_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'noticeboards' AND COLUMN_NAME = 'description');
SET @sql = IF(@col_exists = 0, 'ALTER TABLE `noticeboards` ADD COLUMN `description` TEXT NULL AFTER `title`', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- =====================================================
-- 7. NOVEMBRO 2025 - Create admin_permissions table
-- =====================================================
CREATE TABLE IF NOT EXISTS `admin_permissions` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `admin_id` CHAR(36) NOT NULL,
    `permission_key` VARCHAR(255) NOT NULL COMMENT 'Ex: pos.access, pos.sales, pos.products, etc',
    `granted` TINYINT(1) NOT NULL DEFAULT 1,
    `created_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY `admin_permissions_admin_id_permission_key_unique` (`admin_id`, `permission_key`),
    CONSTRAINT `admin_permissions_admin_id_foreign` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =====================================================
-- 8. NOVEMBRO 2025 - Add soft deletes to payment_references
-- =====================================================
SET @col_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payment_references' AND COLUMN_NAME = 'deleted_at');
SET @sql = IF(@col_exists = 0, 'ALTER TABLE `payment_references` ADD COLUMN `deleted_at` TIMESTAMP NULL', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- =====================================================
-- 9. NOVEMBRO 2025 - Add indexes to payment_confirmations
-- =====================================================
-- Verificar e adicionar índices apenas se não existirem
SET @idx_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payment_confirmations' AND INDEX_NAME = 'idx_payment_confirmations_student_id');
SET @sql = IF(@idx_exists = 0, 'ALTER TABLE `payment_confirmations` ADD INDEX `idx_payment_confirmations_student_id` (`student_id`)', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @idx_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payment_confirmations' AND INDEX_NAME = 'idx_payment_confirmations_class_id');
SET @sql = IF(@idx_exists = 0, 'ALTER TABLE `payment_confirmations` ADD INDEX `idx_payment_confirmations_class_id` (`class_id`)', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @idx_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payment_confirmations' AND INDEX_NAME = 'idx_payment_confirmations_type');
SET @sql = IF(@idx_exists = 0, 'ALTER TABLE `payment_confirmations` ADD INDEX `idx_payment_confirmations_type` (`type`)', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @idx_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payment_confirmations' AND INDEX_NAME = 'idx_payment_confirmations_student_type');
SET @sql = IF(@idx_exists = 0, 'ALTER TABLE `payment_confirmations` ADD INDEX `idx_payment_confirmations_student_type` (`student_id`, `type`)', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- =====================================================
-- 10. NOVEMBRO 2025 - Remove duplicates and add indexes to payment_references
-- =====================================================
-- Remover duplicatas (manter apenas a mais recente)
DELETE pr1 FROM payment_references pr1
INNER JOIN payment_references pr2
WHERE pr1.student_id = pr2.student_id
    AND pr1.fee_month = pr2.fee_month
    AND pr1.fee_year = pr2.fee_year
    AND pr1.status = pr2.status
    AND pr1.status = 'pending'
    AND pr1.id < pr2.id;

-- Adicionar índices (ignorar erro se já existir)
-- ALTER TABLE `payment_references` ADD INDEX `idx_payment_references_student_id` (`student_id`);
-- ALTER TABLE `payment_references` ADD INDEX `idx_payment_references_status` (`status`);
-- ALTER TABLE `payment_references` ADD INDEX `idx_payment_references_fee_year` (`fee_year`);
-- ALTER TABLE `payment_references` ADD INDEX `idx_payment_references_expires_at` (`expires_at`);
-- ALTER TABLE `payment_references` ADD INDEX `idx_payment_references_student_status` (`student_id`, `status`);
-- ALTER TABLE `payment_references` ADD INDEX `idx_payment_references_month_year` (`fee_month`, `fee_year`);

-- =====================================================
-- 11. NOVEMBRO 2025 - Remove duplicates and add indexes to fee_structures
-- =====================================================
-- Remover duplicatas (manter apenas a mais recente)
DELETE fs1 FROM fee_structures fs1
INNER JOIN fee_structures fs2
WHERE fs1.grade = fs2.grade
    AND fs1.academic_year = fs2.academic_year
    AND fs1.fee_name = fs2.fee_name
    AND fs1.active = fs2.active
    AND fs1.active = 1
    AND fs1.id < fs2.id;

-- Adicionar índices (ignorar erro se já existir)
SET @idx_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'fee_structures' AND INDEX_NAME = 'idx_fee_structures_grade');
SET @sql = IF(@idx_exists = 0, 'ALTER TABLE `fee_structures` ADD INDEX `idx_fee_structures_grade` (`grade`)', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @idx_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'fee_structures' AND INDEX_NAME = 'idx_fee_structures_academic_year');
SET @sql = IF(@idx_exists = 0, 'ALTER TABLE `fee_structures` ADD INDEX `idx_fee_structures_academic_year` (`academic_year`)', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @idx_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'fee_structures' AND INDEX_NAME = 'idx_fee_structures_active');
SET @sql = IF(@idx_exists = 0, 'ALTER TABLE `fee_structures` ADD INDEX `idx_fee_structures_active` (`active`)', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @idx_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'fee_structures' AND INDEX_NAME = 'idx_fee_structures_grade_active');
SET @sql = IF(@idx_exists = 0, 'ALTER TABLE `fee_structures` ADD INDEX `idx_fee_structures_grade_active` (`grade`, `active`)', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- =====================================================
-- 12. NOVEMBRO 2025 - Rename palenty_type to penalty_type
-- =====================================================
SET @col_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'fee_structures' AND COLUMN_NAME = 'palenty_type');
SET @col_new_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'fee_structures' AND COLUMN_NAME = 'penalty_type');
SET @sql = IF(@col_exists > 0 AND @col_new_exists = 0, 'ALTER TABLE `fee_structures` CHANGE COLUMN `palenty_type` `penalty_type` VARCHAR(255) NULL', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Se ambas existem, copiar dados e remover antiga
SET @col_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'fee_structures' AND COLUMN_NAME = 'palenty_type');
SET @col_new_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'fee_structures' AND COLUMN_NAME = 'penalty_type');
SET @sql = IF(@col_exists > 0 AND @col_new_exists > 0, 'UPDATE fee_structures SET penalty_type = palenty_type WHERE palenty_type IS NOT NULL', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- =====================================================
-- 13. NOVEMBRO 2025 - Create exam_configurations table
-- =====================================================
CREATE TABLE IF NOT EXISTS `exam_configurations` (
    `id` CHAR(36) NOT NULL PRIMARY KEY,
    `subject_id` VARCHAR(255) NOT NULL,
    `class_level` INT NOT NULL COMMENT 'Classe: 1 a 12',
    `exam_type` ENUM('NE', 'AF', 'none') NOT NULL DEFAULT 'none' COMMENT 'Tipo de avaliação: NE (Nota de Exame), AF (Avaliação Final) ou none (sem exame)',
    `is_active` TINYINT(1) NOT NULL DEFAULT 1,
    `academic_year` INT NULL COMMENT 'Ano letivo (opcional)',
    `created_by` VARCHAR(255) NULL,
    `updated_by` VARCHAR(255) NULL,
    `created_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `deleted_at` TIMESTAMP NULL,
    INDEX `exam_configurations_class_level_index` (`class_level`),
    INDEX `exam_configurations_exam_type_index` (`exam_type`),
    INDEX `exam_configurations_is_active_index` (`is_active`),
    INDEX `exam_configurations_academic_year_index` (`academic_year`),
    UNIQUE KEY `unique_exam_config` (`subject_id`, `class_level`, `academic_year`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- NOTA: Os dados de seed estão em seed_exam_configurations.sql

-- =====================================================
-- 14. DEZEMBRO 2025 - Add valid_from and other fields to payment_references
-- =====================================================
SET @col_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payment_references' AND COLUMN_NAME = 'valid_from');
SET @sql = IF(@col_exists = 0, 'ALTER TABLE `payment_references` ADD COLUMN `valid_from` DATETIME NULL AFTER `reference_number`', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @col_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payment_references' AND COLUMN_NAME = 'classe');
SET @sql = IF(@col_exists = 0, 'ALTER TABLE `payment_references` ADD COLUMN `classe` VARCHAR(255) NULL AFTER `student_id`', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @col_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payment_references' AND COLUMN_NAME = 'turma');
SET @sql = IF(@col_exists = 0, 'ALTER TABLE `payment_references` ADD COLUMN `turma` VARCHAR(255) NULL AFTER `classe`', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @col_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payment_references' AND COLUMN_NAME = 'academic_year');
SET @sql = IF(@col_exists = 0, 'ALTER TABLE `payment_references` ADD COLUMN `academic_year` VARCHAR(20) NULL AFTER `fee_year`', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- =====================================================
-- 15. DEZEMBRO 2025 - Add metadata to payment_references
-- =====================================================
SET @col_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payment_references' AND COLUMN_NAME = 'metadata');
SET @sql = IF(@col_exists = 0, 'ALTER TABLE `payment_references` ADD COLUMN `metadata` TEXT NULL AFTER `expires_at`', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- =====================================================
-- 16. DEZEMBRO 2025 - Create failed_reconciliations table
-- =====================================================
CREATE TABLE IF NOT EXISTS `failed_reconciliations` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `reference_number` VARCHAR(20) NOT NULL,
    `amount` DECIMAL(10, 2) NOT NULL,
    `payment_date` DATE NOT NULL,
    `entity_code` VARCHAR(10) NULL,
    `error_reason` TEXT NOT NULL,
    `file_name` VARCHAR(255) NULL,
    `status` ENUM('pending', 'resolved', 'ignored') NOT NULL DEFAULT 'pending',
    `resolved_by` BIGINT UNSIGNED NULL,
    `resolved_at` TIMESTAMP NULL,
    `resolution_notes` TEXT NULL,
    `created_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `failed_reconciliations_status_created_at_index` (`status`, `created_at`),
    INDEX `failed_reconciliations_reference_number_index` (`reference_number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =====================================================
-- 17. DEZEMBRO 2025 - Add approval fields to payment_references
-- =====================================================
SET @col_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payment_references' AND COLUMN_NAME = 'approval_status');
SET @sql = IF(@col_exists = 0, 'ALTER TABLE `payment_references` ADD COLUMN `approval_status` ENUM(\'pending_approval\', \'approved\', \'rejected\') NOT NULL DEFAULT \'pending_approval\' AFTER `status`', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @col_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payment_references' AND COLUMN_NAME = 'approved_by');
SET @sql = IF(@col_exists = 0, 'ALTER TABLE `payment_references` ADD COLUMN `approved_by` CHAR(36) NULL AFTER `approval_status`', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @col_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payment_references' AND COLUMN_NAME = 'approved_at');
SET @sql = IF(@col_exists = 0, 'ALTER TABLE `payment_references` ADD COLUMN `approved_at` TIMESTAMP NULL AFTER `approved_by`', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @col_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payment_references' AND COLUMN_NAME = 'approval_notes');
SET @sql = IF(@col_exists = 0, 'ALTER TABLE `payment_references` ADD COLUMN `approval_notes` TEXT NULL AFTER `approved_at`', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- =====================================================
-- 18. DEZEMBRO 2025 - Add reminder fields to payment_references
-- =====================================================
SET @col_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payment_references' AND COLUMN_NAME = 'reminder_sent');
SET @sql = IF(@col_exists = 0, 'ALTER TABLE `payment_references` ADD COLUMN `reminder_sent` TINYINT(1) NOT NULL DEFAULT 0 AFTER `approval_notes`', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @col_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payment_references' AND COLUMN_NAME = 'reminder_sent_at');
SET @sql = IF(@col_exists = 0, 'ALTER TABLE `payment_references` ADD COLUMN `reminder_sent_at` TIMESTAMP NULL AFTER `reminder_sent`', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @col_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payment_references' AND COLUMN_NAME = 'reminder_sent_final');
SET @sql = IF(@col_exists = 0, 'ALTER TABLE `payment_references` ADD COLUMN `reminder_sent_final` TINYINT(1) NOT NULL DEFAULT 0 AFTER `reminder_sent_at`', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @col_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payment_references' AND COLUMN_NAME = 'reminder_sent_final_at');
SET @sql = IF(@col_exists = 0, 'ALTER TABLE `payment_references` ADD COLUMN `reminder_sent_final_at` TIMESTAMP NULL AFTER `reminder_sent_final`', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- =====================================================
-- 19. DEZEMBRO 2025 - Change approved_by to UUID
-- =====================================================
-- Limpar valores inválidos
UPDATE `payment_references` SET `approved_by` = NULL WHERE `approved_by` = '0' OR `approved_by` = '';

-- Alterar tipo para CHAR(36) se necessário (já definido acima como CHAR(36))

-- =====================================================
-- 20. DEZEMBRO 2025 - Remove unique constraints (permitir múltiplas referências)
-- =====================================================
-- Remover constraints únicas que impedem múltiplas referências pendentes
-- NOTA: Executar apenas se as constraints existirem
SET @idx_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payment_references' AND INDEX_NAME = 'unique_pending_ref');
SET @sql = IF(@idx_exists > 0, 'ALTER TABLE `payment_references` DROP INDEX `unique_pending_ref`', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @idx_exists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'payment_references' AND INDEX_NAME = 'unique_pending_payment_reference');
SET @sql = IF(@idx_exists > 0, 'ALTER TABLE `payment_references` DROP INDEX `unique_pending_payment_reference`', 'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- =====================================================
-- FIM DAS MIGRATIONS
-- =====================================================
SELECT 'Migrations de Outubro a Dezembro 2025 aplicadas com sucesso!' AS resultado;
