-- =====================================================
-- COPMOZ - Migrações POS (Ponto de Venda)
-- Data: Janeiro 2025
-- =====================================================

-- 1. Tabela de Categorias POS
CREATE TABLE IF NOT EXISTS `pos_categories` (
    `id` CHAR(36) NOT NULL PRIMARY KEY,
    `name` VARCHAR(255) NOT NULL,
    `slug` VARCHAR(255) NOT NULL UNIQUE,
    `description` TEXT NULL,
    `icon` VARCHAR(255) NULL,
    `color` VARCHAR(255) DEFAULT '#4f46e5',
    `is_active` TINYINT(1) DEFAULT 1,
    `created_at` TIMESTAMP NULL,
    `updated_at` TIMESTAMP NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 2. Tabela de Produtos POS
CREATE TABLE IF NOT EXISTS `pos_products` (
    `id` CHAR(36) NOT NULL PRIMARY KEY,
    `category_id` CHAR(36) NOT NULL,
    `name` VARCHAR(255) NOT NULL,
    `sku` VARCHAR(255) NOT NULL UNIQUE,
    `description` TEXT NULL,
    `image` VARCHAR(255) NULL,
    `cost_price` DECIMAL(10,2) DEFAULT 0.00,
    `selling_price` DECIMAL(10,2) NOT NULL,
    `discount_price` DECIMAL(10,2) NULL,
    `quantity` INT DEFAULT 0,
    `min_stock` INT DEFAULT 5,
    `unit` VARCHAR(255) DEFAULT 'Unidade',
    `variant_type` VARCHAR(255) NULL,
    `variant_options` JSON NULL,
    `is_active` TINYINT(1) DEFAULT 1,
    `track_stock` TINYINT(1) DEFAULT 1,
    `notes` TEXT NULL,
    `created_at` TIMESTAMP NULL,
    `updated_at` TIMESTAMP NULL,
    `deleted_at` TIMESTAMP NULL,
    CONSTRAINT `pos_products_category_id_foreign`
        FOREIGN KEY (`category_id`) REFERENCES `pos_categories`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 3. Tabela de Fornecedores POS
CREATE TABLE IF NOT EXISTS `pos_suppliers` (
    `id` CHAR(36) NOT NULL PRIMARY KEY,
    `name` VARCHAR(255) NOT NULL,
    `email` VARCHAR(255) NULL,
    `phone` VARCHAR(255) NULL,
    `nuit` VARCHAR(255) NULL,
    `address` TEXT NULL,
    `notes` TEXT NULL,
    `is_active` TINYINT(1) DEFAULT 1,
    `created_at` TIMESTAMP NULL,
    `updated_at` TIMESTAMP NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 4. Tabela de Movimentos de Stock
CREATE TABLE IF NOT EXISTS `pos_stock_movements` (
    `id` CHAR(36) NOT NULL PRIMARY KEY,
    `product_id` CHAR(36) NOT NULL,
    `supplier_id` CHAR(36) NULL,
    `user_id` CHAR(36) NOT NULL,
    `type` ENUM('purchase', 'sale', 'adjustment', 'return') NOT NULL,
    `quantity` INT NOT NULL,
    `stock_before` INT NOT NULL,
    `stock_after` INT NOT NULL,
    `unit_price` DECIMAL(10,2) NULL,
    `total_price` DECIMAL(10,2) NULL,
    `reference` VARCHAR(255) NULL,
    `notes` TEXT NULL,
    `movement_date` TIMESTAMP NOT NULL,
    `created_at` TIMESTAMP NULL,
    `updated_at` TIMESTAMP NULL,
    CONSTRAINT `pos_stock_movements_product_id_foreign`
        FOREIGN KEY (`product_id`) REFERENCES `pos_products`(`id`) ON DELETE CASCADE,
    CONSTRAINT `pos_stock_movements_supplier_id_foreign`
        FOREIGN KEY (`supplier_id`) REFERENCES `pos_suppliers`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 5. Tabela de Vendas POS
CREATE TABLE IF NOT EXISTS `pos_sales` (
    `id` CHAR(36) NOT NULL PRIMARY KEY,
    `sale_number` VARCHAR(255) NOT NULL UNIQUE,
    `user_id` CHAR(36) NULL,
    `cashier_id` CHAR(36) NOT NULL,
    `subtotal` DECIMAL(10,2) NOT NULL,
    `discount` DECIMAL(10,2) DEFAULT 0.00,
    `tax` DECIMAL(10,2) DEFAULT 0.00,
    `total` DECIMAL(10,2) NOT NULL,
    `payment_method` ENUM('cash', 'mpesa', 'emola', 'bank_transfer', 'credit') NOT NULL,
    `status` ENUM('completed', 'pending', 'cancelled') DEFAULT 'completed',
    `notes` TEXT NULL,
    `sale_date` TIMESTAMP NOT NULL,
    `created_at` TIMESTAMP NULL,
    `updated_at` TIMESTAMP NULL,
    `deleted_at` TIMESTAMP NULL,
    CONSTRAINT `pos_sales_user_id_foreign`
        FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 6. Tabela de Itens de Venda POS
CREATE TABLE IF NOT EXISTS `pos_sale_items` (
    `id` CHAR(36) NOT NULL PRIMARY KEY,
    `sale_id` CHAR(36) NOT NULL,
    `product_id` CHAR(36) NOT NULL,
    `product_name` VARCHAR(255) NOT NULL,
    `product_sku` VARCHAR(255) NOT NULL,
    `variant` VARCHAR(255) NULL,
    `quantity` INT NOT NULL,
    `unit_price` DECIMAL(10,2) NOT NULL,
    `discount` DECIMAL(10,2) DEFAULT 0.00,
    `subtotal` DECIMAL(10,2) NOT NULL,
    `total` DECIMAL(10,2) NOT NULL,
    `created_at` TIMESTAMP NULL,
    `updated_at` TIMESTAMP NULL,
    CONSTRAINT `pos_sale_items_sale_id_foreign`
        FOREIGN KEY (`sale_id`) REFERENCES `pos_sales`(`id`) ON DELETE CASCADE,
    CONSTRAINT `pos_sale_items_product_id_foreign`
        FOREIGN KEY (`product_id`) REFERENCES `pos_products`(`id`) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 7. Tabela de Configurações POS
CREATE TABLE IF NOT EXISTS `pos_settings` (
    `id` CHAR(36) NOT NULL PRIMARY KEY,
    `key` VARCHAR(255) NOT NULL UNIQUE,
    `value` TEXT NULL,
    `type` VARCHAR(255) DEFAULT 'string',
    `description` TEXT NULL,
    `created_at` TIMESTAMP NULL,
    `updated_at` TIMESTAMP NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Inserir configurações padrão POS
INSERT INTO `pos_settings` (`id`, `key`, `value`, `type`, `description`, `created_at`, `updated_at`) VALUES
(UUID(), 'tax_enabled', 'false', 'boolean', 'Ativar/Desativar IVA nas vendas', NOW(), NOW()),
(UUID(), 'tax_rate', '17', 'number', 'Taxa de IVA em percentagem (17% em Moçambique)', NOW(), NOW()),
(UUID(), 'store_name', 'COPMOZ Store', 'string', 'Nome da loja', NOW(), NOW()),
(UUID(), 'sale_number_prefix', 'POS', 'string', 'Prefixo do número de venda (POS, FAT, REC, VD, etc.)', NOW(), NOW()),
(UUID(), 'receipt_footer', 'Obrigado pela sua compra!', 'string', 'Mensagem de rodapé do recibo', NOW(), NOW());

-- Índices adicionais para performance
CREATE INDEX `pos_products_category_id_index` ON `pos_products`(`category_id`);
CREATE INDEX `pos_products_is_active_index` ON `pos_products`(`is_active`);
CREATE INDEX `pos_sales_sale_date_index` ON `pos_sales`(`sale_date`);
CREATE INDEX `pos_sales_status_index` ON `pos_sales`(`status`);
CREATE INDEX `pos_stock_movements_product_id_index` ON `pos_stock_movements`(`product_id`);
CREATE INDEX `pos_stock_movements_type_index` ON `pos_stock_movements`(`type`);
