<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Extrato Financeiro - {{ $student->name }}</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'DejaVu Sans', sans-serif; font-size: 10px; color: #333; }
        .header { background-color: #667eea; color: white; padding: 15px; margin-bottom: 10px; text-align: center; }
        .school-name { font-size: 14px; font-weight: bold; }
        .document-title { text-align: center; font-size: 13px; font-weight: bold; margin: 10px 0; color: #667eea; }
        .student-info { background-color: #f8f9fa; padding: 10px; margin-bottom: 10px; }
        .info-row { margin-bottom: 3px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 10px; font-size: 9px; }
        thead { background-color: #667eea; color: white; }
        th { padding: 6px 4px; text-align: left; font-weight: bold; }
        td { padding: 5px 4px; border-bottom: 1px solid #eee; }
        .text-center { text-align: center; }
        .text-right { text-align: right; }
        .summary-box { background-color: #f8f9fa; padding: 10px; margin-top: 10px; }
        .summary-row { margin-bottom: 3px; font-size: 9px; }
        .footer { margin-top: 15px; text-align: center; font-size: 8px; color: #777; border-top: 1px solid #e0e0e0; padding-top: 10px; }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <div class="school-name">COLÉGIO POLITÉCNICO DE MOÇAMBIQUE</div>
        <div style="font-size: 9px;">Email: info@copmoz.ac.mz | Nampula, Moçambique</div>
    </div>

    <!-- Title -->
    <h1 class="document-title">EXTRATO FINANCEIRO COMPLETO {{ $year }}</h1>

    <!-- Student Info -->
    <div class="student-info">
        <div class="info-row"><strong>Nome:</strong> {{ $student->name }}</div>
        <div class="info-row"><strong>ID:</strong> {{ $student->student_id }}</div>
        <div class="info-row"><strong>Classe:</strong> {{ $student->class->class ?? 'N/A' }} | <strong>Turma:</strong> {{ $student->class->name ?? 'N/A' }}</div>
        <div class="info-row"><strong>Gerado em:</strong> {{ $generated_at }}</div>
    </div>

    @if(isset($payment_references) && $payment_references->count() > 0)
    <!-- Todas as Referências e Pagamentos Agrupados por Mês -->
    <h2 class="document-title" style="margin-top: 10px; font-size: 12px;">DETALHES DE PAGAMENTO DO ESTUDANTE</h2>

    @php
        // Agrupar referências por mês/ano
        $groupedRefs = $payment_references->groupBy(function($ref) {
            return $ref->fee_month . '-' . $ref->fee_year;
        });

        // Ordenar cronologicamente (Janeiro → Dezembro)
        $monthsOrder = ['Janeiro' => 1, 'Fevereiro' => 2, 'Março' => 3, 'Abril' => 4,
                       'Maio' => 5, 'Junho' => 6, 'Julho' => 7, 'Agosto' => 8,
                       'Setembro' => 9, 'Outubro' => 10, 'Novembro' => 11, 'Dezembro' => 12];

        $sortedGroups = $groupedRefs->sortBy(function($group, $key) use ($monthsOrder) {
            list($month, $year) = explode('-', $key);
            $monthNum = $monthsOrder[$month] ?? $monthsOrder[strtolower($month)] ?? 99;
            return $year . str_pad($monthNum, 2, '0', STR_PAD_LEFT);
        });

        // Calcular totais gerais
        $totalGeralBase = 0;
        $totalGeralMulta = 0;
        $totalGeralDesconto = 0;
        $totalGeralPago = 0;
        $totalEfetivamentePago = 0;
        $countPagos = 0;
        $countPendentes = 0;
    @endphp

    @foreach($sortedGroups as $key => $monthRefs)
        @php
            list($month, $year) = explode('-', $key);
            $count = $monthRefs->count();
        @endphp

        <div style="margin-top: 12px; margin-bottom: 8px; font-size: 11px; font-weight: bold; background-color: #667eea; color: white; padding: 6px 10px;">
            {{ $month }} / {{ $year }} - {{ $count }} pagamento(s)
        </div>

        <table>
            <thead>
                <tr>
                    <th width="14%">Referência</th>
                    <th width="20%">Descrição</th>
                    <th width="10%">Vencimento</th>
                    <th width="10%">Estado</th>
                    <th width="11%" class="text-right">Base (MT)</th>
                    <th width="10%" class="text-right">Multa (MT)</th>
                    <th width="10%" class="text-right">Desc. (MT)</th>
                    <th width="10%" class="text-right">Total (MT)</th>
                    <th width="13%">Data/Hora</th>
                </tr>
            </thead>
            <tbody>
                @foreach($monthRefs as $ref)
                    @php
                        $baseAmount = $ref->amount - ($ref->fine_amount ?? 0);
                        $fineAmount = $ref->fine_amount ?? 0;
                        $discountAmount = $ref->discount_amount ?? 0;

                        $status = match($ref->status) {
                            'paid' => 'Pago',
                            'pending' => ($ref->approval_status ?? '') === 'approved' ? 'Aprovado' : 'Pendente',
                            'expired' => 'Expirado',
                            default => $ref->status
                        };

                        $description = is_array($ref->metadata ?? null)
                            ? ($ref->metadata['description'] ?? $ref->metadata['custom_fee_type'] ?? 'N/A')
                            : 'N/A';

                        // Acumular totais
                        $totalGeralBase += $baseAmount;
                        $totalGeralMulta += $fineAmount;
                        $totalGeralDesconto += $discountAmount;
                        $totalGeralPago += $ref->amount;

                        if ($status === 'Pago') {
                            $countPagos++;
                            $totalEfetivamentePago += $ref->amount;
                        } else {
                            $countPendentes++;
                        }
                    @endphp
                    <tr>
                        <td>{{ $ref->reference_number }}</td>
                        <td>{{ $description }}</td>
                        <td class="text-center">{{ $ref->expires_at ? (is_object($ref->expires_at) ? $ref->expires_at->format('d/m/Y') : $ref->expires_at) : 'N/A' }}</td>
                        <td>{{ $status }}</td>
                        <td class="text-right">{{ number_format($baseAmount, 2, ',', '.') }}</td>
                        <td class="text-right">{{ number_format($fineAmount, 2, ',', '.') }}</td>
                        <td class="text-right">{{ number_format($discountAmount, 2, ',', '.') }}</td>
                        <td class="text-right">{{ number_format($ref->amount, 2, ',', '.') }}</td>
                        <td class="text-center">{{ is_object($ref->created_at) ? $ref->created_at->format('d/m/Y H:i') : $ref->created_at }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endforeach

    <!-- Summary -->
    <div class="summary-box" style="margin-top: 15px;">
        <div class="summary-row"><strong>Total de Pagamentos/Referências:</strong> {{ $payment_references->count() }}</div>
        <div class="summary-row"><strong>Pagos:</strong> {{ $countPagos }} | <strong>Pendentes/Outros:</strong> {{ $countPendentes }}</div>
        <div class="summary-row"><strong>Total Base:</strong> MT {{ number_format($totalGeralBase, 2, ',', '.') }}</div>
        <div class="summary-row"><strong>Total Multas:</strong> MT {{ number_format($totalGeralMulta, 2, ',', '.') }}</div>
        <div class="summary-row"><strong>Total Descontos:</strong> MT {{ number_format($totalGeralDesconto, 2, ',', '.') }}</div>
        <div class="summary-row"><strong>Total Pago:</strong> MT {{ number_format($totalEfetivamentePago, 2, ',', '.') }}</div>
        <div class="summary-row"><strong>Total Geral:</strong> MT {{ number_format($totalGeralPago, 2, ',', '.') }}</div>
    </div>
    @else
    <div style="margin-top: 20px; text-align: center; color: #999;">
        Nenhuma referência ou pagamento encontrado para {{ $year }}.
    </div>
    @endif

    <!-- Footer -->
    <div class="footer">
        <p><strong>COLÉGIO POLITÉCNICO DE MOÇAMBIQUE</strong> | Documento gerado automaticamente</p>
        <p>© {{ now()->year }} COPMOZ - Todos os direitos reservados</p>
    </div>
</body>
</html>
