<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                            <h5 class="card-title mb-4">Registos de Presença</h5>

                            <!-- Filters -->
                            <div class="row mb-4">
                                <div class="col-md-2">
                                    <label class="form-label">Ano</label>
                                    <select class="form-control" wire:model="year">
                                        @php $currentYear = (int)date('Y'); @endphp
                                        @for($y = $currentYear; $y >= 2023; $y--)
                                            <option value="{{ $y }}">{{ $y }}</option>
                                        @endfor
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Turma</label>
                                    <select class="form-control" wire:model="classroom_id">
                                        <option value="">Todas</option>
                                        @foreach ($classrooms as $classroom)
                                            <option value="{{ $classroom->id }}">{{ $classroom->class }}ª - {{ $classroom->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label">De</label>
                                    <input type="date" class="form-control" wire:model="date_from">
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label">Até</label>
                                    <input type="date" class="form-control" wire:model="date_to">
                                </div>
                                <div class="col-md-1">
                                    <label class="form-label">Estado</label>
                                    <select class="form-control" wire:model="statusFilter">
                                        <option value="">Todos</option>
                                        @foreach($statuses as $key => $label)
                                            <option value="{{ $key }}">{{ $label }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <label class="form-label">Pesquisar</label>
                                    <input type="text" class="form-control" wire:model.debounce.300ms="search" placeholder="Nome...">
                                </div>
                            </div>

                            <!-- Table -->
                            @if(!$readyToLoad)
                                <div class="text-center py-4">
                                    <div class="spinner-border text-primary" role="status"></div>
                                    <p class="mt-2 text-muted">A carregar...</p>
                                </div>
                            @elseif(is_object($records) && $records->count() > 0)
                                <div class="table-responsive">
                                    <table class="table table-hover table-bordered">
                                        <thead class="table-light">
                                            <tr>
                                                <th>#</th>
                                                <th>Estudante</th>
                                                <th>Turma</th>
                                                <th>Data</th>
                                                <th>Disciplina</th>
                                                <th>Estado</th>
                                                <th>Observação</th>
                                                <th>Registado por</th>
                                                <th style="width: 60px;"></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($records as $index => $record)
                                                <tr>
                                                    <td>{{ $records->firstItem() + $index }}</td>
                                                    <td>{{ $record->student->name ?? '-' }}</td>
                                                    <td>{{ $record->classroom ? $record->classroom->class . 'ª - ' . $record->classroom->name : '-' }}</td>
                                                    <td>{{ \Carbon\Carbon::parse($record->date)->format('d/m/Y') }}</td>
                                                    <td>{{ $record->subject ?? '-' }}</td>
                                                    <td>
                                                        @switch($record->status)
                                                            @case('present')
                                                                <span class="badge bg-success">Presente</span>
                                                                @break
                                                            @case('absent')
                                                                <span class="badge bg-danger">Ausente</span>
                                                                @break
                                                            @case('late')
                                                                <span class="badge bg-warning text-dark">Atrasado</span>
                                                                @break
                                                            @case('justified')
                                                                <span class="badge bg-info">Justificado</span>
                                                                @break
                                                        @endswitch
                                                    </td>
                                                    <td>{{ $record->observation ?? '-' }}</td>
                                                    <td>{{ $record->recorder->name ?? '-' }}</td>
                                                    <td>
                                                        @if(!$isTeacher)
                                                            <button class="btn btn-sm btn-outline-danger"
                                                                    wire:click="deleteAttendance('{{ $record->id }}')"
                                                                    title="Excluir">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <div class="mt-3">
                                    {{ $records->links() }}
                                </div>
                            @else
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle me-1"></i> Nenhum registo encontrado.
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
