<div>
    <div class="page-content">
        <div class="main-wrapper">
            <!-- Header -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h4 class="mb-1"><i class="fas fa-award me-2 text-primary"></i>Gestão de Documentos</h4>
                            <p class="text-muted mb-0">Certificados e Declarações - Classes Configuradas:
                                @if(count($availableClasses) > 0)
                                    @foreach($availableClasses as $class)
                                        <span class="badge bg-secondary me-1">{{ $class }}a</span>
                                    @endforeach
                                @else
                                    <span class="text-warning">Nenhuma classe configurada</span>
                                @endif
                            </p>
                        </div>
                        <div>
                            <span class="badge bg-primary fs-6">Ano Lectivo: {{ $academicYear }}</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Statistics Cards -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="rounded-circle p-3" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                                    <i class="fas fa-certificate text-white fa-lg"></i>
                                </div>
                                <div class="ms-3">
                                    <h6 class="text-muted mb-1">Total Emitidos</h6>
                                    <h3 class="fw-bold mb-0">{{ $stats['total_issued'] ?? 0 }}</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="rounded-circle p-3" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                                    <i class="fas fa-ban text-white fa-lg"></i>
                                </div>
                                <div class="ms-3">
                                    <h6 class="text-muted mb-1">Revogados</h6>
                                    <h3 class="fw-bold mb-0">{{ $stats['total_revoked'] ?? 0 }}</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="rounded-circle p-3" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
                                    <i class="fas fa-layer-group text-white fa-lg"></i>
                                </div>
                                <div class="ms-3">
                                    <h6 class="text-muted mb-1">Lotes Concluídos</h6>
                                    <h3 class="fw-bold mb-0">{{ $stats['completed_batches'] ?? 0 }}</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="rounded-circle p-3" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);">
                                    <i class="fas fa-clock text-white fa-lg"></i>
                                </div>
                                <div class="ms-3">
                                    <h6 class="text-muted mb-1">Lotes Pendentes</h6>
                                    <h3 class="fw-bold mb-0">{{ $stats['pending_batches'] ?? 0 }}</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Tabs -->
            <ul class="nav nav-tabs mb-4" role="tablist">
                <li class="nav-item">
                    <a class="nav-link {{ $activeTab === 'generate' ? 'active' : '' }}"
                       href="#" wire:click.prevent="$set('activeTab', 'generate')">
                        <i class="fas fa-plus-circle me-2"></i>Gerar Documentos
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link {{ $activeTab === 'list' ? 'active' : '' }}"
                       href="#" wire:click.prevent="$set('activeTab', 'list')">
                        <i class="fas fa-list me-2"></i>Lista de Documentos
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link {{ $activeTab === 'batches' ? 'active' : '' }}"
                       href="#" wire:click.prevent="$set('activeTab', 'batches')">
                        <i class="fas fa-layer-group me-2"></i>Lotes
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link {{ $activeTab === 'config' ? 'active' : '' }}"
                       href="#" wire:click.prevent="$set('activeTab', 'config')">
                        <i class="fas fa-cog me-2"></i>Configurações
                    </a>
                </li>
            </ul>

            <!-- Tab Content -->
            @if($activeTab === 'generate')
            <!-- Generate Tab -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="fas fa-graduation-cap me-2"></i>Gerar {{ $documentTypeLabel }}</h5>
                    @if($currentDocConfig)
                    <span class="badge {{ $currentDocConfig->isCertificate() ? 'bg-success' : 'bg-info' }}">
                        {{ $currentDocConfig->getDocumentTypeLabel() }}
                    </span>
                    @endif
                </div>
                <div class="card-body">
                    @if(count($availableClasses) == 0)
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        Nenhuma classe configurada para emissão de documentos. Configure as classes na tab "Configurações".
                    </div>
                    @else
                    <!-- Selection Row -->
                    <div class="row g-3 mb-4">
                        <div class="col-md-3">
                            <label class="form-label">Ano Lectivo</label>
                            <select class="form-select" wire:model="academicYear">
                                @for($y = date('Y'); $y >= date('Y') - 5; $y--)
                                    <option value="{{ $y }}">{{ $y }}</option>
                                @endfor
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Classe</label>
                            <select class="form-select" wire:model="selectedClass">
                                @foreach($availableClasses as $class)
                                    @php $config = \App\Models\DocumentClassConfiguration::getForClass($class, $academicYear); @endphp
                                    <option value="{{ $class }}">{{ $class }}a Classe {{ $config ? '(' . ($config->isCertificate() ? 'Certificado' : 'Declaração') . ')' : '' }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Turma ({{ $selectedClass }}a Classe)</label>
                            <select class="form-select" wire:model="selectedTurma">
                                <option value="">Selecione uma turma...</option>
                                @foreach($availableTurmas as $turma)
                                    <option value="{{ $turma->id }}">{{ $turma->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3 d-flex align-items-end">
                            <button class="btn btn-primary w-100" wire:click="checkEligibility"
                                    wire:loading.attr="disabled" @if(!$selectedTurma) disabled @endif>
                                <span wire:loading.remove wire:target="checkEligibility">
                                    <i class="fas fa-search me-2"></i>Verificar Elegibilidade
                                </span>
                                <span wire:loading wire:target="checkEligibility">
                                    <i class="fas fa-spinner fa-spin me-2"></i>A verificar...
                                </span>
                            </button>
                        </div>
                    </div>
                    @endif

                    @if($showEligibilityResults)
                    <!-- Results -->
                    <div class="row">
                        <!-- Eligible Students -->
                        <div class="col-md-6">
                            <div class="card border-success">
                                <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
                                    <span><i class="fas fa-check-circle me-2"></i>Elegíveis ({{ count($eligibleStudents) }})</span>
                                    @if(count(array_filter($eligibleStudents, fn($e) => !$e['has_certificate'])) > 0)
                                    <button class="btn btn-light btn-sm" wire:click="generateBatch">
                                        <i class="fas fa-layer-group me-1"></i>Gerar Todos
                                    </button>
                                    @endif
                                </div>
                                <div class="card-body" style="max-height: 400px; overflow-y: auto;">
                                    @forelse($eligibleStudents as $item)
                                    <div class="d-flex justify-content-between align-items-center py-2 border-bottom">
                                        <div>
                                            <strong>{{ $item['student']['name'] }}</strong>
                                            <br>
                                            <small class="text-muted">{{ $item['student']['student_id'] }} | NF: {{ number_format($item['grades']['final_average'], 2) }}</small>
                                        </div>
                                        <div>
                                            @if($item['has_certificate'])
                                                <span class="badge bg-info">Ja tem documento</span>
                                            @else
                                                <button class="btn btn-success btn-sm"
                                                        wire:click="$set('selectedStudentId', '{{ $item['student']['id'] }}')"
                                                        @if($selectedStudentId === $item['student']['id']) disabled @endif>
                                                    @if($selectedStudentId === $item['student']['id'])
                                                        <i class="fas fa-check"></i>
                                                    @else
                                                        <i class="fas fa-plus"></i>
                                                    @endif
                                                </button>
                                            @endif
                                        </div>
                                    </div>
                                    @empty
                                    <p class="text-muted text-center mb-0">Nenhum estudante elegível.</p>
                                    @endforelse
                                </div>
                            </div>
                        </div>

                        <!-- Ineligible Students -->
                        <div class="col-md-6">
                            <div class="card border-danger">
                                <div class="card-header bg-danger text-white">
                                    <i class="fas fa-times-circle me-2"></i>Inelegíveis ({{ count($ineligibleStudents) }})
                                </div>
                                <div class="card-body" style="max-height: 400px; overflow-y: auto;">
                                    @forelse($ineligibleStudents as $item)
                                    <div class="py-2 border-bottom">
                                        <strong>{{ $item['student']['name'] }}</strong>
                                        <br>
                                        <small class="text-danger"><i class="fas fa-exclamation-triangle me-1"></i>{{ $item['reason'] }}</small>
                                    </div>
                                    @empty
                                    <p class="text-muted text-center mb-0">Todos os estudantes estao elegiveis!</p>
                                    @endforelse
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Individual Generation -->
                    @if($selectedStudentId)
                    <div class="mt-4 p-3 bg-light rounded">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                @php $selectedStudent = collect($eligibleStudents)->firstWhere('student.id', $selectedStudentId); @endphp
                                @if($selectedStudent)
                                <strong>Estudante seleccionado:</strong> {{ $selectedStudent['student']['name'] }}
                                <span class="text-muted">({{ $selectedStudent['student']['student_id'] }})</span>
                                @endif
                            </div>
                            <div>
                                <button class="btn btn-secondary me-2" wire:click="$set('selectedStudentId', null)">
                                    Cancelar
                                </button>
                                <button class="btn btn-success" wire:click="generateIndividual">
                                    <i class="fas fa-file-alt me-2"></i>Gerar {{ $documentTypeLabel }}
                                </button>
                            </div>
                        </div>
                    </div>
                    @endif
                    @endif
                </div>
            </div>

            @elseif($activeTab === 'list')
            <!-- List Tab -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <div class="row g-3 align-items-center">
                        <div class="col-md-2">
                            <input type="text" class="form-control" placeholder="Buscar..."
                                   wire:model.debounce.300ms="searchTerm">
                        </div>
                        <div class="col-md-2">
                            <select class="form-select" wire:model="filterYear">
                                <option value="">Todos os Anos</option>
                                @for($y = date('Y'); $y >= date('Y') - 5; $y--)
                                    <option value="{{ $y }}">{{ $y }}</option>
                                @endfor
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select class="form-select" wire:model="filterClassLevel">
                                <option value="">Todas Classes</option>
                                @foreach($documentConfigurations->pluck('class_level')->unique() as $class)
                                    <option value="{{ $class }}">{{ $class }}a Classe</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select class="form-select" wire:model="filterTurma">
                                <option value="">Todas Turmas</option>
                                @foreach($availableTurmas as $turma)
                                    <option value="{{ $turma->name }}">{{ $turma->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select class="form-select" wire:model="filterStatus">
                                <option value="">Todos Status</option>
                                <option value="issued">Emitidos</option>
                                <option value="revoked">Revogados</option>
                            </select>
                        </div>
                        <div class="col-md-2 text-end">
                            @if($filterTurma || $filterYear)
                            <button class="btn btn-outline-success btn-sm" wire:click="downloadAllZip">
                                <i class="fas fa-file-archive me-1"></i>ZIP
                            </button>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>Número</th>
                                    <th>Estudante</th>
                                    <th>Tipo</th>
                                    <th>Classe</th>
                                    <th>Turma</th>
                                    <th>Nota Final</th>
                                    <th>Status</th>
                                    <th>Data Emissão</th>
                                    <th class="text-end">Acções</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($certificates as $cert)
                                @php
                                    $isCertificate = str_starts_with($cert->certificate_number, 'CERT-');
                                @endphp
                                <tr>
                                    <td>
                                        <strong>{{ $cert->certificate_number }}</strong>
                                        <br>
                                        <small class="text-muted">{{ $cert->academic_year }}</small>
                                    </td>
                                    <td>
                                        {{ $cert->student_name }}
                                        <br>
                                        <small class="text-muted">{{ $cert->student_id_number }}</small>
                                    </td>
                                    <td>
                                        @if($isCertificate)
                                            <span class="badge bg-success">Certificado</span>
                                        @else
                                            <span class="badge bg-info">Declaração</span>
                                        @endif
                                    </td>
                                    <td><span class="badge bg-secondary">{{ $cert->class_level }}a</span></td>
                                    <td>{{ $cert->turma_name }}</td>
                                    <td>
                                        <span class="badge bg-primary">{{ number_format($cert->final_average, 2) }}</span>
                                    </td>
                                    <td>{!! $cert->status_badge !!}</td>
                                    <td>{{ $cert->issued_at ? $cert->issued_at->format('d/m/Y H:i') : '-' }}</td>
                                    <td class="text-end">
                                        <div class="btn-group">
                                            <button class="btn btn-sm btn-outline-warning" wire:click="regenerateCertificate('{{ $cert->id }}')"
                                                    title="Regenerar documento">
                                                <i class="fas fa-sync-alt"></i>
                                            </button>
                                            <button class="btn btn-sm btn-outline-info" wire:click="downloadCertificateWord('{{ $cert->id }}')"
                                                    title="Baixar Word">
                                                <i class="fas fa-file-word"></i>
                                            </button>
                                            @if($cert->status === 'issued')
                                            <button class="btn btn-sm btn-outline-danger" wire:click="openRevokeModal('{{ $cert->id }}')"
                                                    title="Revogar">
                                                <i class="fas fa-ban"></i>
                                            </button>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center py-4 text-muted">
                                        <i class="fas fa-file-alt fa-3x mb-3 d-block"></i>
                                        Nenhum documento encontrado.
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                @if($certificates->hasPages())
                <div class="card-footer">
                    {{ $certificates->links() }}
                </div>
                @endif
            </div>

            @elseif($activeTab === 'batches')
            <!-- Batches Tab -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0"><i class="fas fa-layer-group me-2"></i>Lotes de Documentos</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>Lote</th>
                                    <th>Turma</th>
                                    <th>Ano</th>
                                    <th>Total</th>
                                    <th>Sucesso</th>
                                    <th>Falhas</th>
                                    <th>Status</th>
                                    <th class="text-end">Acções</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($batches as $batch)
                                <tr>
                                    <td><strong>{{ $batch->batch_number }}</strong></td>
                                    <td>{{ $batch->classroom ? $batch->classroom->name : 'Todas' }}</td>
                                    <td>{{ $batch->academic_year }}</td>
                                    <td>{{ $batch->total_students }}</td>
                                    <td><span class="text-success">{{ $batch->success_count }}</span></td>
                                    <td><span class="text-danger">{{ $batch->failed_count }}</span></td>
                                    <td>{!! $batch->status_badge !!}</td>
                                    <td class="text-end">
                                        @if($batch->status === 'completed' && $batch->success_count > 0)
                                        <div class="btn-group">
                                            <button class="btn btn-sm btn-outline-warning" wire:click="regenerateBatch('{{ $batch->id }}')"
                                                    title="Regenerar documentos do lote">
                                                <i class="fas fa-sync-alt"></i>
                                            </button>
                                            <button class="btn btn-sm btn-outline-success" wire:click="downloadBatchZip('{{ $batch->id }}')"
                                                    title="Baixar ZIP">
                                                <i class="fas fa-file-archive"></i>
                                            </button>
                                        </div>
                                        @endif
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center py-4 text-muted">
                                        Nenhum lote encontrado.
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            @elseif($activeTab === 'config')
            <!-- Configuration Tab -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="fas fa-cog me-2"></i>Configuração de Tipos de Documentos</h5>
                    <button class="btn btn-primary btn-sm" wire:click="openAddConfigModal">
                        <i class="fas fa-plus me-1"></i>Adicionar Classe
                    </button>
                </div>
                <div class="card-body">
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        Configure quais classes emitem <strong>Certificados</strong> e quais emitem <strong>Declarações</strong>.
                        Esta configuração afecta o template e numeração dos documentos gerados.
                    </div>

                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Classe</th>
                                    <th>Tipo de Documento</th>
                                    <th>Título</th>
                                    <th>Descrição</th>
                                    <th>Ano Específico</th>
                                    <th>Status</th>
                                    <th class="text-end">Acções</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($documentConfigurations as $config)
                                <tr>
                                    <td><strong>{{ $config->class_level }}ª Classe</strong></td>
                                    <td>{!! $config->getDocumentTypeBadge() !!}</td>
                                    <td>{{ $config->document_title ?? '-' }}</td>
                                    <td><small>{{ Str::limit($config->description, 50) }}</small></td>
                                    <td>{{ $config->academic_year ?? 'Todos' }}</td>
                                    <td>
                                        @if($config->is_active)
                                            <span class="badge bg-success">Activo</span>
                                        @else
                                            <span class="badge bg-secondary">Inactivo</span>
                                        @endif
                                    </td>
                                    <td class="text-end">
                                        <div class="btn-group">
                                            <button class="btn btn-sm btn-outline-primary" wire:click="openEditConfigModal('{{ $config->id }}')"
                                                    title="Editar">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <button class="btn btn-sm {{ $config->is_active ? 'btn-outline-warning' : 'btn-outline-success' }}"
                                                    wire:click="toggleConfigStatus('{{ $config->id }}')"
                                                    title="{{ $config->is_active ? 'Desactivar' : 'Activar' }}">
                                                <i class="fas {{ $config->is_active ? 'fa-toggle-off' : 'fa-toggle-on' }}"></i>
                                            </button>
                                            <button class="btn btn-sm btn-outline-danger" wire:click="deleteConfig('{{ $config->id }}')"
                                                    title="Eliminar">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center py-4 text-muted">
                                        <i class="fas fa-cog fa-3x mb-3 d-block"></i>
                                        Nenhuma configuração encontrada. Clique em "Adicionar Classe" para criar uma configuração.
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        <h6><i class="fas fa-lightbulb me-2 text-warning"></i>Legenda:</h6>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="d-flex align-items-center mb-2">
                                    <span class="badge bg-success me-2">Certificado</span>
                                    <small>Documento oficial de conclusão de ciclo (6ª e 12ª classe)</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex align-items-center mb-2">
                                    <span class="badge bg-info me-2">Declaração</span>
                                    <small>Documento de frequência ou conclusão intermediária</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>

    <!-- Config Edit Modal -->
    <div class="modal fade" id="configModal" tabindex="-1" wire:ignore.self>
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">
                        <i class="fas fa-cog me-2"></i>
                        {{ $editConfigId ? 'Editar Configuração' : 'Adicionar Classe' }}
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" wire:click="closeConfigModal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Classe *</label>
                        <select class="form-select @error('editClassLevel') is-invalid @enderror" wire:model.defer="editClassLevel"
                                {{ $editConfigId ? 'disabled' : '' }}>
                            <option value="">Selecione a classe...</option>
                            @for($i = 1; $i <= 12; $i++)
                                <option value="{{ $i }}">{{ $i }}ª Classe</option>
                            @endfor
                        </select>
                        @error('editClassLevel')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        @if($editConfigId)
                            <small class="text-muted">A classe não pode ser alterada após criação.</small>
                        @endif
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Tipo de Documento *</label>
                        <div class="btn-group w-100" role="group">
                            <input type="radio" class="btn-check" id="typeCertificate" value="certificate"
                                   wire:model.defer="editDocumentType" {{ $editDocumentType === 'certificate' ? 'checked' : '' }}>
                            <label class="btn btn-outline-success" for="typeCertificate">
                                <i class="fas fa-award me-1"></i>Certificado
                            </label>

                            <input type="radio" class="btn-check" id="typeDeclaration" value="declaration"
                                   wire:model.defer="editDocumentType" {{ $editDocumentType === 'declaration' ? 'checked' : '' }}>
                            <label class="btn btn-outline-info" for="typeDeclaration">
                                <i class="fas fa-file-alt me-1"></i>Declaração
                            </label>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Título do Documento *</label>
                        <input type="text" class="form-control @error('editDocumentTitle') is-invalid @enderror"
                               wire:model.defer="editDocumentTitle"
                               placeholder="Ex: Certificado de Conclusão do Ensino Secundário"
                               value="{{ $editDocumentTitle }}">
                        @error('editDocumentTitle')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Descrição</label>
                        <textarea class="form-control" rows="2" wire:model.defer="editDescription"
                                  placeholder="Descrição opcional...">{{ $editDescription }}</textarea>
                    </div>

                    <div class="alert alert-light border">
                        <small>
                            <strong><i class="fas fa-info-circle me-1"></i>Numeração:</strong>
                            <ul class="mb-0 mt-1">
                                <li><span class="badge bg-success">Certificado</span> → CERT-2026-000001</li>
                                <li><span class="badge bg-info">Declaração</span> → DECL-2026-000001</li>
                            </ul>
                        </small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" wire:click="closeConfigModal">
                        Cancelar
                    </button>
                    <button type="button" class="btn btn-primary" wire:click="saveConfig" wire:loading.attr="disabled">
                        <span wire:loading.remove wire:target="saveConfig">
                            <i class="fas fa-save me-1"></i>{{ $editConfigId ? 'Guardar Alterações' : 'Adicionar' }}
                        </span>
                        <span wire:loading wire:target="saveConfig">
                            <i class="fas fa-spinner fa-spin me-1"></i>A guardar...
                        </span>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Revoke Modal -->
    <div class="modal fade" id="revokeModal" tabindex="-1" wire:ignore.self>
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title"><i class="fas fa-ban me-2"></i>Revogar Certificado</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        Esta acção não pode ser desfeita. O certificado será marcado como revogado.
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Motivo da Revogação *</label>
                        <textarea class="form-control" rows="3" wire:model.defer="revocationReason"
                                  placeholder="Informe o motivo da revogação..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-danger" wire:click="revokeCertificate">
                        <i class="fas fa-ban me-2"></i>Revogar Certificado
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Only add listeners once
            if (window.certificateModalListenersAdded) return;
            window.certificateModalListenersAdded = true;

            window.addEventListener('open-revoke-modal', function(event) {
                var modalEl = document.getElementById('revokeModal');
                if (modalEl) {
                    var modal = new bootstrap.Modal(modalEl);
                    modal.show();
                }
            });

            window.addEventListener('close-revoke-modal', function(event) {
                var modalEl = document.getElementById('revokeModal');
                if (modalEl) {
                    var modal = bootstrap.Modal.getInstance(modalEl);
                    if (modal) modal.hide();
                }
            });

            window.addEventListener('open-config-modal', function(event) {
                setTimeout(function() {
                    var modalEl = document.getElementById('configModal');
                    if (modalEl) {
                        var existingModal = bootstrap.Modal.getInstance(modalEl);
                        if (existingModal) {
                            existingModal.dispose();
                        }
                        var modal = new bootstrap.Modal(modalEl);
                        modal.show();
                    }
                }, 150);
            });

            window.addEventListener('close-config-modal', function(event) {
                var modalEl = document.getElementById('configModal');
                if (modalEl) {
                    var modal = bootstrap.Modal.getInstance(modalEl);
                    if (modal) modal.hide();
                }
            });
        });
    </script>
</div>
