<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card shadow-sm border-0">
                        <div class="card-body" wire:init="loadData">
                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <div>
                                    <h5 class="card-title mb-1" style="color: #374151; font-weight: 600; font-size: 1.5rem;">
                                        <i class="fas fa-users-class" style="color: #667eea;"></i>
                                        Estudantes da {{ $class->name }}
                                    </h5>
                                    <p class="text-muted mb-0" style="font-size: 0.9rem;">
                                        <span class="badge bg-primary">{{ $class->class }}ª Classe</span>
                                        @if(is_object($models) && method_exists($models, 'total'))
                                            <span class="ms-2">{{ $models->total() }} estudante(s)</span>
                                        @endif
                                    </p>
                                </div>
                                <a href="{{ route('admin.batch.marks') }}" class="btn btn-success shadow-sm" style="border-radius: 8px;">
                                    <i class="fa fa-table me-2"></i>Lançamento de Notas em Lote
                                </a>
                            </div>

                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <div class="input-group shadow-sm">
                                        <span class="input-group-text bg-white border-end-0" style="border-color: #e5e7eb;">
                                            <i class="fas fa-search text-muted"></i>
                                        </span>
                                        <input type="search"
                                               wire:model="search"
                                               placeholder="Pesquisar por nome ou ID do estudante..."
                                               class="form-control border-start-0"
                                               style="border-color: #e5e7eb; padding-left: 0;">
                                    </div>
                                </div>
                            </div>
                            <div class="table-responsive" wire:init="loadData">
                                @if (count($models))
                                    <table class="table table-hover align-middle">
                                        <thead style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                                            <tr>
                                                <th scope="col" style="font-weight: 600; font-size: 0.875rem; border: none;">#</th>
                                                <th scope="col" style="font-weight: 600; font-size: 0.875rem; border: none;">
                                                    <i class="fas fa-user me-2"></i>Nome
                                                </th>
                                                <th scope="col" style="font-weight: 600; font-size: 0.875rem; border: none;">
                                                    <i class="fas fa-venus-mars me-2"></i>Sexo
                                                </th>
                                                <th scope="col" style="font-weight: 600; font-size: 0.875rem; border: none;">
                                                    <i class="fas fa-birthday-cake me-2"></i>Data Nascimento
                                                </th>
                                                <th scope="col" style="font-weight: 600; font-size: 0.875rem; border: none;">
                                                    <i class="fas fa-id-card me-2"></i>ID Estudante
                                                </th>
                                                <th scope="col" style="font-weight: 600; font-size: 0.875rem; border: none;">
                                                    <i class="fas fa-door-open me-2"></i>Turma
                                                </th>
                                                <th scope="col" style="font-weight: 600; font-size: 0.875rem; border: none;">
                                                    <i class="fas fa-layer-group me-2"></i>Classe
                                                </th>
                                                <th scope="col" class="text-center" style="font-weight: 600; font-size: 0.875rem; border: none;">
                                                    <i class="fas fa-eye me-2"></i>Ações
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php($count = 1)
                                            @foreach ($models as $model)
                                                <tr style="border-bottom: 1px solid #f3f4f6;">
                                                    <th scope="row" style="color: #9ca3af; font-weight: 500;">{{ $count++ }}</th>
                                                    <?php $key = 'modal_' . $count; ?>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar-circle me-2" style="width: 40px; height: 40px; border-radius: 50%; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 0.9rem;">
                                                                {{ substr($model->name, 0, 1) }}
                                                            </div>
                                                            <span style="color: #374151; font-weight: 500;">{{ $model->name }}</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        @if($model->sex == 'Masculino')
                                                            <span class="badge bg-info"><i class="fas fa-mars me-1"></i>{{ $model->sex }}</span>
                                                        @else
                                                            <span class="badge bg-pink" style="background-color: #ec4899;"><i class="fas fa-venus me-1"></i>{{ $model->sex }}</span>
                                                        @endif
                                                    </td>
                                                    <td style="color: #6b7280;">
                                                        <i class="far fa-calendar me-1"></i>
                                                        {{ date('d/m/Y', strtotime($model->dob)) }}
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-light text-dark border" style="font-size: 0.85rem;">{{ $model->student_id }}</span>
                                                    </td>
                                                    <td style="color: #374151; font-weight: 500;">{{ $model->class->name }}</td>
                                                    <td>
                                                        <span class="badge" style="background-color: #4f46e5; font-size: 0.875rem; padding: 0.5rem 0.75rem;">
                                                            {{ $model->class->class }}ª Classe
                                                        </span>
                                                    </td>
                                                    <td class="text-center">
                                                        <a href="{{ route('admin.list.students.marks', $model->slug) }}"
                                                           class="btn btn-sm btn-primary shadow-sm" style="border-radius: 6px;">
                                                            <i class="fas fa-eye me-1"></i>Ver Notas
                                                        </a>
                                                    </td>
                                                </tr>
                                                <livewire:admin.classes.modal-exam :model="$model"
                                                    :wire:key="$model->id">

                                                    <div wire:ignore.self class="modal fade"
                                                        id="modal_{{ $model->id }}" tabindex="-1"
                                                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                        <div class="modal-dialog  modal-lg modal-dialog-centered">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title"
                                                                        id="exampleModalCenterTitle">
                                                                        {{ $model->name }}
                                                                    </h5>
                                                                    <button type="button" class="btn-close"
                                                                        data-bs-dismiss="modal"
                                                                        aria-label="Close"></button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <div class="row">
                                                                        <form class="row g-3"
                                                                            wire:submit.prevent="submit">
                                                                            <div class="col-md-12">
                                                                                <label for="title"
                                                                                    class="form-label">Disciplina
                                                                                </label>
                                                                                <select
                                                                                    class="form-control @error('subject_id') is-invalid @enderror"
                                                                                    id="name"
                                                                                    wire:model="subject_id"
                                                                                    class="form-control input-lg dynamic">
                                                                                    <option value="" selected>Por
                                                                                        favor selecione a disciplina
                                                                                    </option>
                                                                                    @foreach ($subjects as $subject)
                                                                                        <option
                                                                                            value="{{ $subject->id }}">
                                                                                            {{ $subject->name }}
                                                                                        </option>
                                                                                    @endforeach
                                                                                </select>
                                                                                @error('subject_id')
                                                                                    <span class="invalid-feedback"
                                                                                        role="alert">
                                                                                        <strong>{{ $message }}</strong>
                                                                                    </span>
                                                                                @enderror
                                                                            </div>

                                                                            <div class="col-md-12">
                                                                                <label for="title"
                                                                                    class="form-label">Trimestre
                                                                                </label>
                                                                                <select
                                                                                    class="form-control @error('trimester_id') is-invalid @enderror"
                                                                                    id="trimester_id"
                                                                                    wire:model="trimester_id"
                                                                                    class="form-control input-lg dynamic">
                                                                                    <option value="">Selecione o
                                                                                        trimestre</option>
                                                                                    <option value="1">Primeiro
                                                                                        trimestre</option>
                                                                                    <option value="2">Segundo
                                                                                        trimestre</option>
                                                                                    <option value="3">Terceiro
                                                                                        trimestre</option>

                                                                                </select>
                                                                                @error('trimester_id')
                                                                                    <span class="invalid-feedback"
                                                                                        role="alert">
                                                                                        <strong>{{ $message }}</strong>
                                                                                    </span>
                                                                                @enderror
                                                                            </div>
                                                                            <div class="col-md-12">
                                                                                <label for="title"
                                                                                    class="form-label"> Tipo de teste
                                                                                </label>
                                                                                <select
                                                                                    class="form-control @error('type') is-invalid @enderror"
                                                                                    id="type" wire:model="type"
                                                                                    class="form-control input-lg dynamic">
                                                                                    <option value="" selected>
                                                                                        Selecione o tipo de teste
                                                                                    </option>
                                                                                    <option value="1">ACS1</option>
                                                                                    <option value="2">ACS2</option>
                                                                                    <option value="3">AT</option>
                                                                                    <option value="4">NE</option>


                                                                                </select>
                                                                                @error('type')
                                                                                    <span class="invalid-feedback"
                                                                                        role="alert">
                                                                                        <strong>{{ $message }}</strong>
                                                                                    </span>
                                                                                @enderror
                                                                            </div>
                                                                            <div class="col-md-12">
                                                                                <label for="MACS"
                                                                                    class="form-label">Nota</label>
                                                                                <input type="number"
                                                                                    class="form-control @error('MACS') is-invalid @enderror"
                                                                                    id="MACS" required
                                                                                    placeholder="Insira a nota..."
                                                                                    wire:model="MACS">
                                                                                @error('MACS')
                                                                                    <span class="invalid-feedback"
                                                                                        role="alert">
                                                                                        <strong>{{ $message }}</strong>
                                                                                    </span>
                                                                                @enderror
                                                                            </div>

                                                                            <br><br>
                                                                            <div class="col-12">
                                                                                <button type="submit"
                                                                                    class="btn btn-primary btn-lg float-end"
                                                                                    wire:loading.class="disabled"
                                                                                    wire:offline.attr="disabled"><span
                                                                                        wire:target="submit"
                                                                                        wire:loading.class="spinner-border spinner-border-lg"></span>
                                                                                    Guardar
                                                                                </button>
                                                                            </div>
                                                                        </form>
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        <button type="button"
                                                                            class="btn btn-secondary"
                                                                            data-bs-dismiss="modal">
                                                                            Fechar
                                                                        </button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                            @endforeach
                                        </tbody>
                                    </table>
                                    <div class="row float-end">
                                        {{ $models->links() }}
                                    </div>
                                @else
                                    <br>
                                    <br>
                                    <div class="d-flex justify-content-center">
                                        <div wire:loading class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Processando...</span>
                                        </div>
                                    </div>
                                    <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
