<div class="table-responsive" wire:init="loadData">
    @if(count($models) > 0)
        @foreach($models as $subjectId => $groupedModels)
            @php
                $subject = \App\Models\Subject::find($subjectId);
            @endphp

            @if($subject)
                <h5>{{ $subject->name }}</h5>
            @else
                <h5>Assunto não encontrado</h5>
            @endif

            <table class="table table-hover">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Classe</th>
                        <th scope="col">Estudante</th>
                        <th scope="col">Título</th>
                        <th scope="col">Descrição</th>
                        <th scope="col">Ficheiro</th>
                        <th scope="col">Data de Lançamento</th>
                        <th scope="col">Ação</th>
                    </tr>
                </thead>
                <tbody>
                @php
                    $count = 1;
                @endphp
                @foreach($groupedModels as $model)
                    @php
                        // Verifique se $model é um objeto válido antes de acessar suas propriedades
                        if (is_object($model)) {
                            $get_class = $model->class_id ? \App\Models\Classroom::find($model->class_id) : null;
                            $get_student = $model->student_id ? \App\Models\User::find($model->student_id) : null;
                            $get_download = \App\Models\Downloadcenter::find($model->download_id);
                            $get_file = \App\Models\Downloadfile::where('download_id', $model->download_id)->first();
                            $user = Auth::user();
                            $showRow = false;

                            if (isset($student)) {
                                if (!$model->student_id || $model->student_id == $user->id) {
                                    $showRow = true;
                                }
                            } else {
                                $showRow = true;
                            }
                        } else {
                            $showRow = false;
                        }
                    @endphp
                    @if($showRow)
                        <tr>
                            <th scope="row">{{ $count++ }}</th>
                            <td>{{ $get_class ? "{$get_class->class} Classe - {$get_class->name}" : '' }}</td>
                            <td>{{ $get_student ? $get_student->name : '' }}</td>
                            <td>{!! $get_download->title !!}</td>
                            <td>{!! $get_download->description !!}</td>
                            <td>
                                @if($get_file)
                                    <a href="{{ $get_file->media_url }}">{{ $get_file->media_name }}</a>
                                @endif
                            </td>
                            <td>{{ \Carbon\Carbon::parse($model->created_at)->format('d/m/Y H:i:s') }}</td>
                            <td>
                                <a href="{{ route('admin.edit.Download', $model->download_id) }}" class="btn btn-block btn-outline-primary btn-sm">
                                    <span class="fa fa-edit"></span>
                                </a>
                                <a type="button" wire:click="submit('{{ $model->download_id }}')" class="btn btn-outline-danger">
                                    <span class="fa fa-trash"></span>
                                </a>
                            </td>
                        </tr>
                    @endif
                @endforeach
                </tbody>
            </table>
        @endforeach
    @else
        <br><br>
        <div class="d-flex justify-content-center">
            <div wire:loading class="spinner-border text-primary" role="status">
                <span class="sr-only">Processando...</span>
            </div>
        </div>
        <p class="text-center"><b>Nenhum dado foi encontrado no momento.</b></p>
    @endif
</div>
