<div>
    <div class="page-content">
        <div class="main-wrapper">
            <style>
        /* Design Profissional com Gradientes Suaves */
        .approval-card {
            transition: all 0.3s ease;
            border-left: 4px solid transparent;
            border-radius: 8px;
        }

        .approval-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.1) !important;
        }

        .approval-card.pending_approval {
            border-left-color: #607d8b;
            background: linear-gradient(135deg, #ffffff 0%, #f5f5f5 100%);
        }
        .approval-card.approved {
            border-left-color: #4caf50;
            background: linear-gradient(135deg, #ffffff 0%, #f1f8f4 100%);
        }
        .approval-card.rejected {
            border-left-color: #f44336;
            background: linear-gradient(135deg, #ffffff 0%, #fef5f5 100%);
        }

        /* Cards de Estatísticas - Gradientes Coloridos */
        .stat-card {
            border-radius: 10px;
            border: none;
            color: white;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }

        .stat-card.pending {
            background: linear-gradient(135deg, #ffa726 0%, #fb8c00 100%);
        }

        .stat-card.approved {
            background: linear-gradient(135deg, #66bb6a 0%, #43a047 100%);
        }

        .stat-card.rejected {
            background: linear-gradient(135deg, #ef5350 0%, #e53935 100%);
        }

        .stat-card .stat-number {
            font-size: 2rem;
            font-weight: 600;
            margin: 0;
        }

        .stat-card .stat-label {
            font-size: 0.875rem;
            opacity: 0.9;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            font-weight: 500;
        }

        .stat-card .stat-icon {
            font-size: 2.5rem;
            opacity: 0.3;
        }

        /* Badges Profissionais */
        .badge-status {
            font-size: 0.75rem;
            padding: 0.4em 0.8em;
            font-weight: 500;
            border-radius: 3px;
            text-transform: uppercase;
            letter-spacing: 0.3px;
        }

        /* Botões com Gradientes Suaves */
        .btn-approve {
            background: linear-gradient(135deg, #66bb6a 0%, #4caf50 100%);
            border: none;
            color: white;
            font-weight: 500;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            box-shadow: 0 2px 4px rgba(76, 175, 80, 0.3);
        }

        .btn-approve:hover {
            background: linear-gradient(135deg, #4caf50 0%, #388e3c 100%);
            color: white;
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(76, 175, 80, 0.4);
        }

        .btn-reject {
            background: linear-gradient(135deg, #ef5350 0%, #f44336 100%);
            border: none;
            color: white;
            font-weight: 500;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            box-shadow: 0 2px 4px rgba(244, 67, 54, 0.3);
        }

        .btn-reject:hover {
            background: linear-gradient(135deg, #f44336 0%, #d32f2f 100%);
            color: white;
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(244, 67, 54, 0.4);
        }

        .btn-reject-icon {
            background-color: transparent;
            border: 2px solid #ef5350;
            color: #f44336;
            padding: 0.5rem 0.75rem;
            border-radius: 6px;
        }

        .btn-reject-icon:hover {
            background: linear-gradient(135deg, #ef5350 0%, #f44336 100%);
            color: white;
            border-color: transparent;
        }

        .action-buttons {
            display: flex;
            gap: 0.5rem;
        }

        /* Avatar Profissional */
        .student-info {
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .student-avatar {
            width: 42px;
            height: 42px;
            border-radius: 50%;
            background: linear-gradient(135deg, #5c6bc0 0%, #3f51b5 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 700;
            font-size: 1.1rem;
            box-shadow: 0 3px 8px rgba(63, 81, 181, 0.4);
        }

        /* Valores Monetários */
        .reference-amount {
            font-size: 1.125rem;
            font-weight: 600;
            color: #2c3e50;
        }

        /* Headers Profissionais */
        .page-header {
            border-bottom: 2px solid #e0e0e0;
            padding-bottom: 1rem;
            margin-bottom: 1.5rem;
        }

        .page-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: #2c3e50;
            margin: 0;
        }

        .page-subtitle {
            font-size: 0.875rem;
            color: #6c757d;
            margin: 0.25rem 0 0 0;
        }

        /* Filtros */
        .filter-section {
            background: #f8f9fa;
            border: 1px solid #e0e0e0;
            border-radius: 4px;
        }

        .filter-section .card-header {
            background: #2c3e50;
            color: white;
            font-weight: 500;
            border-radius: 3px 3px 0 0;
        }

        /* Tabela-like Design para Cards */
        .reference-row {
            display: flex;
            align-items: center;
            padding: 1rem;
        }

        .reference-col {
            flex: 1;
        }

        /* Texto profissional */
        .text-corporate {
            color: #2c3e50;
        }

        .text-muted-corporate {
            color: #6c757d;
            font-size: 0.875rem;
        }

        /* Alert profissional */
        .alert-corporate {
            background: #f8f9fa;
            border: 1px solid #2c3e50;
            border-left: 4px solid #2c3e50;
            border-radius: 3px;
        }
    </style>

    <div class="container-fluid px-4 pt-4 pb-3">
        <!-- Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h2 class="mb-1" style="color: #455a64; font-weight: 600;">
                            <i class="fas fa-check-circle me-2" style="color: #607d8b;"></i>
                            Aprovação de Referências de Pagamento
                        </h2>
                        <p class="text-muted mb-0">
                            Valide e aprove referências antes de ficarem disponíveis para estudantes
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Estatísticas - Gradientes Suaves -->
        <div class="row g-3 mb-4">
            <div class="col-md-4">
                <div class="card stat-card pending shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <p class="stat-label mb-2 text-white">Pendentes</p>
                                <h2 class="stat-number text-white">{{ $stats['pending'] }}</h2>
                            </div>
                            <div class="stat-icon text-white">
                                <i class="fas fa-clock"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card stat-card approved shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <p class="stat-label mb-2 text-white">Aprovadas Hoje</p>
                                <h2 class="stat-number text-white">{{ $stats['approved_today'] }}</h2>
                            </div>
                            <div class="stat-icon text-white">
                                <i class="fas fa-check-circle"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card stat-card rejected shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <p class="stat-label mb-2 text-white">Rejeitadas Hoje</p>
                                <h2 class="stat-number text-white">{{ $stats['rejected_today'] }}</h2>
                            </div>
                            <div class="stat-icon text-white">
                                <i class="fas fa-times-circle"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filtros e Ações em Massa -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card shadow-sm border-0" style="border-radius: 10px;">
                    <div class="card-header text-white" style="background: linear-gradient(135deg, #42a5f5 0%, #1976d2 100%); border-radius: 10px 10px 0 0;">
                        <h6 class="mb-0 fw-semibold">
                            <i class="fas fa-filter me-2"></i>
                            Filtros e Ações em Massa
                        </h6>
                    </div>
                    <div class="card-body" style="background: #f8f9fa;">
                        <div class="row g-3 align-items-end">
                            <!-- Status -->
                            <div class="col-md-2">
                                <label class="form-label fw-semibold">
                                    <i class="fas fa-tag text-info me-1"></i> Status
                                </label>
                                <select class="form-select" wire:model="filterStatus">
                                    <option value="pending_approval">Pendentes</option>
                                    <option value="approved">Aprovadas</option>
                                    <option value="rejected">Rejeitadas</option>
                                </select>
                            </div>

                            <!-- Classe -->
                            <div class="col-md-2">
                                <label class="form-label fw-semibold">
                                    <i class="fas fa-layer-group text-warning me-1"></i> Classe
                                </label>
                                <select class="form-select" wire:model="filterClass">
                                    <option value="">Todas</option>
                                    @foreach(['1ª', '2ª', '3ª', '4ª', '5ª', '6ª', '7ª', '8ª', '9ª', '10ª', '11ª', '12ª'] as $class)
                                        <option value="{{ $class }}">{{ $class }} Classe</option>
                                    @endforeach
                                </select>
                            </div>

                            <!-- Turma -->
                            <div class="col-md-2">
                                <label class="form-label fw-semibold">
                                    <i class="fas fa-users text-success me-1"></i> Turma
                                </label>
                                <select class="form-select" wire:model="filterTurma">
                                    <option value="">Todas</option>
                                    @foreach($classrooms as $classroom)
                                        <option value="{{ $classroom->id }}">{{ $classroom->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <!-- Mês -->
                            <div class="col-md-2">
                                <label class="form-label fw-semibold">
                                    <i class="fas fa-calendar-alt text-primary me-1"></i> Mês
                                </label>
                                <select class="form-select" wire:model="filterMonth">
                                    <option value="">Todos</option>
                                    @foreach(['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'] as $index => $month)
                                        <option value="{{ $index + 1 }}">{{ $month }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <!-- Ano -->
                            <div class="col-md-2">
                                <label class="form-label fw-semibold">
                                    <i class="fas fa-calendar text-danger me-1"></i> Ano
                                </label>
                                <input type="number" class="form-control" wire:model="filterYear" min="2020" max="2100">
                            </div>

                            <!-- Busca -->
                            <div class="col-md-2">
                                <label class="form-label fw-semibold">
                                    <i class="fas fa-search text-secondary me-1"></i> Buscar
                                </label>
                                <input type="text" class="form-control" wire:model.debounce.500ms="searchTerm" placeholder="Nome, Nº Ref...">
                            </div>
                        </div>

                        @if($isPca && $filterStatus === 'pending_approval' && count($selectedReferences) > 0)
                        <div class="row mt-3">
                            <div class="col-12">
                                <div class="alert alert-corporate d-flex justify-content-between align-items-center mb-0">
                                    <span style="color: #2c3e50; font-weight: 500;">
                                        <i class="fas fa-check-square me-2"></i>
                                        <strong>{{ count($selectedReferences) }}</strong> referência(s) selecionada(s)
                                    </span>
                                    <div class="action-buttons">
                                        <button class="btn btn-approve btn-sm" wire:click="approveSelected">
                                            <i class="fas fa-check me-1"></i> Aprovar Selecionadas
                                        </button>
                                        <button class="btn btn-reject btn-sm" wire:click="rejectSelected">
                                            <i class="fas fa-times me-1"></i> Rejeitar Selecionadas
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Lista de Referências -->
        <div class="row">
            <div class="col-12">
                @if($isPca && $filterStatus === 'pending_approval')
                <div class="mb-3">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" wire:model="selectAll" id="selectAll">
                        <label class="form-check-label fw-semibold" for="selectAll">
                            Selecionar todas as referências visíveis
                        </label>
                    </div>
                </div>
                @endif

                @php
                    $months = ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'];
                @endphp

                @foreach($groupedReferences as $monthYearKey => $monthReferences)
                    @php
                        $firstRef = $monthReferences->first();
                        $monthIndex = (int)$firstRef->fee_month - 1;
                        $monthName = isset($months[$monthIndex]) ? $months[$monthIndex] : $firstRef->fee_month;
                    @endphp

                    <!-- Cabeçalho do Grupo de Mês -->
                    <div class="card shadow-sm mb-3" style="border-left: 5px solid #1976d2;">
                        <div class="card-header" style="background: linear-gradient(135deg, #42a5f5 0%, #1976d2 100%); color: white;">
                            <h6 class="mb-0 fw-bold">
                                <i class="fas fa-calendar-alt me-2"></i>
                                {{ $monthName }} / {{ $firstRef->fee_year }}
                                <span class="badge bg-white text-primary ms-2">{{ $monthReferences->count() }} referência(s)</span>
                            </h6>
                        </div>
                        <div class="card-body p-0">
                            @foreach($monthReferences as $reference)
                            <div class="approval-card {{ $reference->approval_status }} border-bottom">
                                <div class="card-body">
                                    <div class="row align-items-center">
                                        <!-- Checkbox (apenas para pendentes e PCA) -->
                                        @if($isPca && $reference->approval_status === 'pending_approval')
                                        <div class="col-auto">
                                            <input class="form-check-input" type="checkbox" wire:model="selectedReferences" value="{{ $reference->id }}" style="width: 1.25rem; height: 1.25rem;">
                                        </div>
                                        @endif

                                        <!-- Informações do Estudante -->
                                        <div class="col-md-3">
                                            <div class="student-info">
                                                <div class="student-avatar">
                                                    {{ substr($reference->student->name ?? 'U', 0, 1) }}
                                                </div>
                                                <div>
                                                    <div class="fw-bold">{{ $reference->student->name ?? 'N/A' }}</div>
                                                    <small class="text-muted">
                                                        <i class="fas fa-id-badge me-1"></i>{{ $reference->student->student_id ?? 'N/A' }}
                                                    </small>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Detalhes da Referência -->
                                        <div class="col-md-2">
                                            <div>
                                                <small class="text-muted d-block">Referência</small>
                                                <div class="fw-bold text-primary">{{ $reference->reference_number }}</div>
                                            </div>
                                            <div class="mt-2">
                                                <span class="badge bg-secondary">{{ $reference->classe ?? 'N/A' }} - {{ $reference->turma ?? 'N/A' }}</span>
                                            </div>
                                        </div>

                                        <!-- Descrição do Pagamento -->
                                        <div class="col-md-2">
                                            <div>
                                                <small class="text-muted d-block">Descrição</small>
                                                <div class="fw-semibold" style="font-size: 0.9rem;">
                                                    @if(isset($reference->metadata['description']))
                                                        {{ $reference->metadata['description'] }}
                                                    @elseif(isset($reference->metadata['custom_fee_type']))
                                                        {{ $reference->metadata['custom_fee_type'] }}
                                                    @elseif(isset($reference->metadata['pos_product_name']))
                                                        {{ $reference->metadata['pos_product_name'] }}
                                                    @else
                                                        Propina {{ $monthName }}/{{ $reference->fee_year }}
                                                    @endif
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Valor -->
                                        <div class="col-md-2">
                                            <div>
                                                <small class="text-muted d-block">Valor</small>
                                                <div class="reference-amount">{{ number_format($reference->amount, 2) }} MT</div>
                                            </div>
                                        </div>

                                        <!-- Status -->
                                        <div class="col-md-2">
                                            @if($reference->approval_status === 'pending_approval')
                                                <span class="badge badge-status bg-warning text-dark">
                                                    <i class="fas fa-clock me-1"></i> Pendente
                                                </span>
                                            @elseif($reference->approval_status === 'approved')
                                                <span class="badge badge-status bg-success">
                                                    <i class="fas fa-check-circle me-1"></i> Aprovada
                                                </span>
                                                <div class="mt-2">
                                                    <small class="text-muted">Por: {{ $reference->approver->name ?? 'Sistema' }}</small><br>
                                                    <small class="text-muted">{{ $reference->approved_at ? $reference->approved_at->format('d/m/Y H:i') : 'N/A' }}</small>
                                                </div>
                                            @else
                                                <span class="badge badge-status bg-danger">
                                                    <i class="fas fa-times-circle me-1"></i> Rejeitada
                                                </span>
                                                @if($reference->approval_notes)
                                                <div class="mt-2">
                                                    <small class="text-muted">{{ $reference->approval_notes }}</small>
                                                </div>
                                                @endif
                                            @endif
                                        </div>

                                        <!-- Ações (apenas para PCA) -->
                                        <div class="col-md-2 text-end">
                                            @if($isPca)
                                                @if($reference->approval_status === 'pending_approval')
                                                <div class="action-buttons justify-content-end">
                                                    <button class="btn btn-approve btn-sm" wire:click="openApprovalModal({{ $reference->id }}, 'approve')" title="Aprovar">
                                                        <i class="fas fa-check me-1"></i> Aprovar
                                                    </button>
                                                    <button class="btn btn-reject-icon btn-sm" wire:click="openApprovalModal({{ $reference->id }}, 'reject')" title="Rejeitar">
                                                        <i class="fas fa-times"></i>
                                                    </button>
                                                </div>
                                                @elseif(in_array($reference->approval_status, ['approved', 'rejected']) && $reference->status !== 'paid')
                                                <div class="action-buttons justify-content-end">
                                                    <button class="btn btn-warning btn-sm" wire:click="resetToPending({{ $reference->id }})" title="Voltar a Pendente">
                                                        <i class="fas fa-undo me-1"></i> Pendente
                                                    </button>
                                                </div>
                                                @endif
                                            @else
                                                @if($reference->approval_status === 'pending_approval')
                                                <span class="badge bg-secondary">
                                                    <i class="fas fa-lock me-1"></i> Apenas PCA
                                                </span>
                                                @endif
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                @endforeach

                @if($groupedReferences->isEmpty())
                <div class="card shadow-sm">
                    <div class="card-body text-center py-5">
                        <i class="fas fa-inbox text-muted" style="font-size: 4rem; opacity: 0.3;"></i>
                        <h5 class="text-muted mt-3">Nenhuma referência encontrada</h5>
                        <p class="text-muted">Altere os filtros ou aguarde novas referências</p>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Modal de Aprovação/Rejeição - Design Colorido Original -->
    @if($showApprovalModal)
    <div class="modal fade show d-block" style="background: rgba(0,0,0,0.5);" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content" style="border-radius: 10px; border: none; box-shadow: 0 8px 32px rgba(0,0,0,0.3);">
                @if($approvalAction === 'approve')
                    <div class="modal-header text-white" style="background: linear-gradient(135deg, #66bb6a 0%, #4caf50 100%); border-radius: 10px 10px 0 0;">
                @else
                    <div class="modal-header text-white" style="background: linear-gradient(135deg, #ef5350 0%, #f44336 100%); border-radius: 10px 10px 0 0;">
                @endif
                    <h5 class="modal-title" style="font-weight: 600;">
                        <i class="fas fa-{{ $approvalAction === 'approve' ? 'check' : 'times' }}-circle me-2"></i>
                        {{ $approvalAction === 'approve' ? 'Aprovar' : 'Rejeitar' }} Referência
                    </h5>
                    <button type="button" class="btn-close btn-close-white" wire:click="$set('showApprovalModal', false)"></button>
                </div>
                <div class="modal-body" style="padding: 1.5rem;">
                    <div class="mb-3">
                        <label class="form-label fw-semibold">Notas/Motivo</label>
                        <textarea class="form-control" rows="3" wire:model="approvalNotes" placeholder="Adicione notas sobre esta {{ $approvalAction === 'approve' ? 'aprovação' : 'rejeição' }}..." style="border-radius: 8px;"></textarea>
                    </div>

                    @if($approvalAction === 'approve')
                    <div class="form-check" style="padding: 1rem; background: linear-gradient(135deg, #e8f5e9 0%, #f1f8f4 100%); border-radius: 8px; border: 2px solid #66bb6a;">
                        <input class="form-check-input" type="checkbox" wire:model="sendSmsAfterApproval" id="sendSms">
                        <label class="form-check-label fw-semibold" for="sendSms">
                            <i class="fas fa-sms me-2" style="color: #4caf50;"></i> Enviar SMS de notificação ao estudante
                        </label>
                    </div>
                    @endif
                </div>
                <div class="modal-footer" style="background: #fafafa; border-radius: 0 0 10px 10px;">
                    <button type="button" class="btn btn-secondary" wire:click="$set('showApprovalModal', false)" style="border-radius: 8px; font-weight: 500;">
                        Cancelar
                    </button>
                    @if($approvalAction === 'approve')
                        <button type="button" class="btn btn-approve" wire:click="processIndividualApproval">
                            <i class="fas fa-check me-1"></i> Aprovar
                        </button>
                    @else
                        <button type="button" class="btn btn-reject" wire:click="processIndividualApproval">
                            <i class="fas fa-times me-1"></i> Rejeitar
                        </button>
                    @endif
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Modal de Ação em Massa - Design Colorido -->
    @if($showBulkActionModal)
    <div class="modal fade show d-block" style="background: rgba(0,0,0,0.5);" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content" style="border-radius: 10px; border: none; box-shadow: 0 8px 32px rgba(0,0,0,0.3);">
                @if($bulkAction === 'approve')
                    <div class="modal-header text-white" style="background: linear-gradient(135deg, #66bb6a 0%, #4caf50 100%); border-radius: 10px 10px 0 0;">
                @else
                    <div class="modal-header text-white" style="background: linear-gradient(135deg, #ef5350 0%, #f44336 100%); border-radius: 10px 10px 0 0;">
                @endif
                    <h5 class="modal-title" style="font-weight: 600;">
                        <i class="fas fa-{{ $bulkAction === 'approve' ? 'check' : 'times' }}-circle me-2"></i>
                        {{ $bulkAction === 'approve' ? 'Aprovar' : 'Rejeitar' }} {{ count($selectedReferences) }} Referência(s)
                    </h5>
                    <button type="button" class="btn-close btn-close-white" wire:click="$set('showBulkActionModal', false)"></button>
                </div>
                <div class="modal-body" style="padding: 1.5rem;">
                    <div class="alert alert-info" style="border-radius: 8px; background: linear-gradient(135deg, #e3f2fd 0%, #f5f9ff 100%); border: 2px solid #42a5f5;">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>{{ count($selectedReferences) }} referência(s) selecionada(s)</strong>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-semibold">Motivo/Notas <span class="text-muted">(opcional)</span></label>
                        <textarea class="form-control" rows="3" wire:model="bulkNotes" placeholder="Ex: Aprovação em massa após verificação..." style="border-radius: 8px;"></textarea>
                        <small class="text-muted">Este motivo será registrado para todas as referências.</small>
                    </div>

                    @if($bulkAction === 'approve')
                    <div class="form-check" style="padding: 1rem; background: linear-gradient(135deg, #e8f5e9 0%, #f1f8f4 100%); border-radius: 8px; border: 2px solid #66bb6a;">
                        <input class="form-check-input" type="checkbox" wire:model="sendBulkSms" id="sendBulkSms" checked>
                        <label class="form-check-label fw-semibold" for="sendBulkSms">
                            <i class="fas fa-sms me-2" style="color: #4caf50;"></i> Enviar SMS para todos os estudantes
                        </label>
                        <small class="d-block text-muted mt-1">Serão enviados {{ count($selectedReferences) }} SMS de notificação.</small>
                    </div>
                    @endif
                </div>
                <div class="modal-footer" style="background: #fafafa; border-radius: 0 0 10px 10px;">
                    <button type="button" class="btn btn-secondary" wire:click="$set('showBulkActionModal', false)" style="border-radius: 8px; font-weight: 500;">
                        Cancelar
                    </button>
                    @if($bulkAction === 'approve')
                        <button type="button" class="btn btn-approve" wire:click="processBulkAction">
                            <i class="fas fa-check me-1"></i> Aprovar Todas ({{ count($selectedReferences) }})
                        </button>
                    @else
                        <button type="button" class="btn btn-reject" wire:click="processBulkAction">
                            <i class="fas fa-times me-1"></i> Rejeitar Todas ({{ count($selectedReferences) }})
                        </button>
                    @endif
                </div>
            </div>
        </div>
    </div>
    @endif

            @push('scripts')
            <script>
                // Toasts/Alerts
                window.addEventListener('success', event => {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        text: event.detail.message || 'Operação concluída com sucesso',
                        timer: 3000
                    });
                });

                window.addEventListener('error', event => {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: event.detail.message || 'Ocorreu um erro',
                        timer: 3000
                    });
                });
            </script>
            @endpush
        </div>
    </div>
</div>
