<div>
    <div class="page-content">
        <div class="main-wrapper">
            <!-- Header -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-primary text-white py-3 d-flex justify-content-between align-items-center">
                    <h2 class="h5 mb-0"><i class="fas fa-users-cog me-2"></i>Encarregados de Educação</h2>
                    <button wire:click="openCreate" class="btn btn-sm btn-light fw-semibold">
                        <i class="fas fa-plus me-1"></i>Novo Encarregado
                    </button>
                </div>
            </div>

            <!-- Form card (create/edit) -->
            @if($showForm)
            <div class="card border-0 shadow-sm mb-4 border-start border-primary border-3">
                <div class="card-header bg-white py-3">
                    <h6 class="mb-0 fw-semibold">
                        <i class="fas fa-{{ $editId ? 'edit' : 'plus' }} me-2 text-primary"></i>
                        {{ $editId ? 'Editar Encarregado' : 'Novo Encarregado' }}
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label class="form-label fw-semibold small">Nome <span class="text-danger">*</span></label>
                            <input type="text" wire:model.defer="name" class="form-control @error('name') is-invalid @enderror" placeholder="Nome completo">
                            @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-md-3">
                            <label class="form-label fw-semibold small">Telefone <span class="text-danger">*</span></label>
                            <input type="tel" wire:model.defer="phone" class="form-control @error('phone') is-invalid @enderror" placeholder="258841234567">
                            @error('phone') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-md-3">
                            <label class="form-label fw-semibold small">Email</label>
                            <input type="email" wire:model.defer="email" class="form-control" placeholder="email@exemplo.com">
                        </div>
                        <div class="col-md-2">
                            <label class="form-label fw-semibold small">Relação <span class="text-danger">*</span></label>
                            <select wire:model.defer="relationship" class="form-select">
                                <option value="pai">Pai</option>
                                <option value="mae">Mãe</option>
                                <option value="encarregado">Encarregado</option>
                                <option value="outro">Outro</option>
                            </select>
                        </div>
                        @if($editId)
                        <div class="col-md-2">
                            <label class="form-label fw-semibold small">Estado</label>
                            <select wire:model.defer="is_active" class="form-select">
                                <option value="1">Activo</option>
                                <option value="0">Inactivo</option>
                            </select>
                        </div>
                        @endif
                    </div>
                    <div class="d-flex gap-2 mt-3 justify-content-end">
                        <button type="button" wire:click="$set('showForm', false)" class="btn btn-outline-secondary btn-sm">Cancelar</button>
                        <button type="button" wire:click="save" class="btn btn-primary btn-sm px-4">
                            <i class="fas fa-save me-1"></i>{{ $editId ? 'Actualizar' : 'Criar' }}
                        </button>
                    </div>
                </div>
            </div>
            @endif

            <!-- Search -->
            <div class="card border-0 shadow-sm mb-3">
                <div class="card-body py-2">
                    <div class="input-group" style="max-width:350px;">
                        <span class="input-group-text bg-light"><i class="fas fa-search text-muted"></i></span>
                        <input type="text" wire:model="search" class="form-control" placeholder="Pesquisar por nome ou telefone...">
                    </div>
                </div>
            </div>

            <!-- Table -->
            <div class="card border-0 shadow-sm">
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>Nome</th>
                                    <th>Telefone</th>
                                    <th>Relação</th>
                                    <th>Estudantes</th>
                                    <th>Último login</th>
                                    <th>Estado</th>
                                    <th class="text-end">Acções</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($guardians as $guardian)
                                <tr>
                                    <td>
                                        <strong>{{ $guardian->name }}</strong>
                                        @if($guardian->email)
                                            <div class="text-muted small">{{ $guardian->email }}</div>
                                        @endif
                                    </td>
                                    <td class="font-monospace small">{{ $guardian->phone }}</td>
                                    <td>
                                        @php
                                            $relColors = ['pai'=>'bg-primary','mae'=>'bg-pink','encarregado'=>'bg-secondary','outro'=>'bg-dark'];
                                            $relLabels = ['pai'=>'Pai','mae'=>'Mãe','encarregado'=>'Encarregado','outro'=>'Outro'];
                                        @endphp
                                        <span class="badge {{ $relColors[$guardian->relationship] ?? 'bg-secondary' }}">
                                            {{ $relLabels[$guardian->relationship] ?? ucfirst($guardian->relationship) }}
                                        </span>
                                    </td>
                                    <td>
                                        @foreach($guardian->students()->with('classroom')->get() as $st)
                                            <span class="badge bg-light text-dark border me-1">
                                                {{ $st->name }} ({{ $st->classroom?->class ?? '?' }}ª)
                                            </span>
                                        @endforeach
                                        <button wire:click="openLinkModal('{{ $guardian->id }}')"
                                            class="btn btn-outline-success btn-sm py-0 ms-1" title="Associar estudante">
                                            <i class="fas fa-link"></i>
                                        </button>
                                    </td>
                                    <td class="text-muted small">
                                        {{ $guardian->last_login_at ? $guardian->last_login_at->format('d/m/Y H:i') : 'Nunca' }}
                                    </td>
                                    <td>
                                        <span class="badge {{ $guardian->is_active ? 'bg-success' : 'bg-danger' }}">
                                            {{ $guardian->is_active ? 'Activo' : 'Inactivo' }}
                                        </span>
                                    </td>
                                    <td class="text-end">
                                        <div class="btn-group btn-group-sm">
                                            <button wire:click="openCredentials('{{ $guardian->id }}')" class="btn btn-outline-info" title="Ver credenciais de acesso">
                                                <i class="fas fa-id-card"></i>
                                            </button>
                                            <button wire:click="openEdit('{{ $guardian->id }}')" class="btn btn-outline-primary" title="Editar">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <button wire:click="toggleActive('{{ $guardian->id }}')" class="btn btn-outline-{{ $guardian->is_active ? 'warning' : 'success' }}" title="{{ $guardian->is_active ? 'Desactivar' : 'Activar' }}">
                                                <i class="fas fa-{{ $guardian->is_active ? 'ban' : 'check' }}"></i>
                                            </button>
                                            <button wire:click="openResetPassword('{{ $guardian->id }}')" class="btn btn-outline-secondary" title="Redefinir password">
                                                <i class="fas fa-key"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>

                                <!-- Students sub-row for unlink -->
                                @foreach($guardian->students as $st)
                                <tr class="table-light">
                                    <td colspan="3" class="ps-5 text-muted small">
                                        <i class="fas fa-user-graduate me-1 text-primary"></i>{{ $st->name }} — {{ $st->classroom?->class ?? 'N/A' }}ª Turma {{ $st->classroom?->name ?? '' }}
                                        <span class="badge bg-light text-dark border ms-1">{{ ucfirst($st->pivot->relationship ?? '') }}</span>
                                    </td>
                                    <td colspan="4" class="text-end pe-3">
                                        <button wire:click="unlinkStudent('{{ $guardian->id }}','{{ $st->id }}')"
                                            class="btn btn-outline-danger btn-sm py-0"
                                            onclick="return confirm('Remover ligação com {{ $st->name }}?')"
                                            title="Remover ligação">
                                            <i class="fas fa-unlink me-1"></i>Remover
                                        </button>
                                    </td>
                                </tr>
                                @endforeach
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center py-4 text-muted">
                                        <i class="fas fa-users-slash fa-2x mb-2 d-block"></i>
                                        Nenhum encarregado encontrado.
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="p-3 border-top">
                        {{ $guardians->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Link Student Modal -->
    @if($showLinkModal)
    <div class="modal d-block" tabindex="-1" style="background:rgba(0,0,0,.5);">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 shadow-lg">
                <div class="modal-header bg-success text-white">
                    <h6 class="modal-title"><i class="fas fa-link me-2"></i>Associar Estudante</h6>
                    <button wire:click="$set('showLinkModal', false)" class="btn-close btn-close-white"></button>
                </div>
                <div class="modal-body p-4">
                    <div class="mb-3">
                        <label class="form-label fw-semibold small">Estudante</label>
                        <select wire:model="linkStudentId" class="form-select">
                            <option value="">Selecione o estudante...</option>
                            @foreach($students_for_link as $st)
                                <option value="{{ $st->id }}">{{ $st->name }} ({{ $st->student_id ?? 'N/A' }})</option>
                            @endforeach
                        </select>
                        @error('linkStudentId') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-semibold small">Relação com o estudante</label>
                        <select wire:model="linkRelationship" class="form-select">
                            <option value="pai">Pai</option>
                            <option value="mae">Mãe</option>
                            <option value="encarregado">Encarregado</option>
                            <option value="outro">Outro</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button wire:click="$set('showLinkModal', false)" class="btn btn-outline-secondary btn-sm">Cancelar</button>
                    <button wire:click="linkStudent" class="btn btn-success btn-sm px-4">
                        <i class="fas fa-link me-1"></i>Associar
                    </button>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Credentials Modal -->
    @if($showCredentialsModal && $credentialsGuardian)
    @php
        $cg = $credentialsGuardian;
        $defaultPass = substr(preg_replace('/\D/', '', $cg->phone), -6);
        $portalUrl = url('/encarregado/login');
    @endphp
    <div class="modal d-block" tabindex="-1" style="background:rgba(0,0,0,.5);">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 shadow-lg">
                <div class="modal-header" style="background:#1e3a5f;color:#fff;">
                    <h6 class="modal-title"><i class="fas fa-id-card me-2"></i>Credenciais de Acesso — {{ $cg->name }}</h6>
                    <button wire:click="$set('showCredentialsModal', false)" class="btn-close btn-close-white"></button>
                </div>
                <div class="modal-body p-4">
                    {{-- Credentials card --}}
                    <div id="credentials-card" style="background:#f8fafc;border:1px solid #e2e8f0;border-radius:10px;padding:1.25rem;">
                        <div class="d-flex align-items-center mb-3 gap-2">
                            <span class="rounded-circle d-flex align-items-center justify-content-center text-white fw-bold flex-shrink-0"
                                  style="width:40px;height:40px;background:#3b82f6;font-size:16px;">
                                {{ strtoupper(substr($cg->name, 0, 1)) }}
                            </span>
                            <div>
                                <div class="fw-bold" style="color:#1e293b;">{{ $cg->name }}</div>
                                <div class="small text-muted">{{ $cg->relationship_label }}</div>
                            </div>
                        </div>

                        <hr class="my-2">

                        <div class="mb-2">
                            <div class="small text-muted fw-semibold text-uppercase" style="font-size:.65rem;letter-spacing:.05em;">Endereço do Portal</div>
                            <div class="fw-semibold small font-monospace" style="color:#3b82f6;">{{ $portalUrl }}</div>
                        </div>
                        <div class="mb-2">
                            <div class="small text-muted fw-semibold text-uppercase" style="font-size:.65rem;letter-spacing:.05em;">Utilizador (Telefone)</div>
                            <div class="fw-bold font-monospace" style="color:#1e293b;font-size:1.1rem;letter-spacing:.05em;">{{ $cg->phone }}</div>
                        </div>
                        <div class="mb-2">
                            <div class="small text-muted fw-semibold text-uppercase" style="font-size:.65rem;letter-spacing:.05em;">Palavra-passe (padrão)</div>
                            <div class="fw-bold font-monospace" style="color:#dc2626;font-size:1.1rem;letter-spacing:.1em;">{{ $defaultPass }}</div>
                            <div class="small text-muted" style="font-size:.7rem;">Últimos 6 dígitos do telefone. Mudar após 1.º acesso.</div>
                        </div>

                        @if($cg->students->isNotEmpty())
                        <hr class="my-2">
                        <div class="small text-muted fw-semibold text-uppercase mb-1" style="font-size:.65rem;letter-spacing:.05em;">Estudantes associados</div>
                        @foreach($cg->students as $st)
                            <div class="small" style="color:#1e293b;">
                                <i class="fas fa-user-graduate me-1 text-primary" style="font-size:.7rem;"></i>
                                {{ $st->name }}
                                @if($st->classroom) · {{ $st->classroom->class }}ª Turma {{ $st->classroom->name }} @endif
                            </div>
                        @endforeach
                        @endif
                    </div>

                    <div class="alert alert-warning mt-3 mb-0 py-2 small">
                        <i class="fas fa-exclamation-triangle me-1"></i>
                        Se a palavra-passe foi redefinida manualmente, a palavra-passe acima pode não estar correcta. Use "Redefinir" para definir uma nova.
                    </div>
                </div>
                <div class="modal-footer">
                    <button wire:click="$set('showCredentialsModal', false)" class="btn btn-outline-secondary btn-sm">Fechar</button>
                    <button onclick="window.print()" class="btn btn-primary btn-sm">
                        <i class="fas fa-print me-1"></i>Imprimir
                    </button>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Reset Password Modal -->
    @if($showResetModal)
    <div class="modal d-block" tabindex="-1" style="background:rgba(0,0,0,.5);">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content border-0 shadow-lg">
                <div class="modal-header bg-secondary text-white">
                    <h6 class="modal-title"><i class="fas fa-key me-2"></i>Nova Palavra-passe</h6>
                    <button wire:click="$set('showResetModal', false)" class="btn-close btn-close-white"></button>
                </div>
                <div class="modal-body p-4">
                    <label class="form-label fw-semibold small">Nova palavra-passe (mín. 6 caracteres)</label>
                    <input type="text" wire:model.defer="newPassword" class="form-control @error('newPassword') is-invalid @enderror" placeholder="Nova palavra-passe">
                    @error('newPassword') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>
                <div class="modal-footer">
                    <button wire:click="$set('showResetModal', false)" class="btn btn-outline-secondary btn-sm">Cancelar</button>
                    <button wire:click="resetPassword" class="btn btn-secondary btn-sm px-4">
                        <i class="fas fa-save me-1"></i>Guardar
                    </button>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>
