<div>
    <div class="page-content">
        <div class="main-wrapper">
            <!-- Page Header -->
            <div class="row mb-4 mt-3">
                <div class="col-12">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="pt-3">
                            <h1 class="h3 mb-1 text-dark fw-bold">
                                <i class="fas fa-bullhorn me-2 text-primary"></i>Lista de Comunicados
                            </h1>
                            <p class="text-muted mb-0">
                                Gerencie e visualize os comunicados do sistema
                            </p>
                        </div>
                        @if(!isset($student))
                        <div class="text-end">
                            <a href="{{ route('admin.add.notice') }}" class="btn btn-primary">
                                <i class="fas fa-plus me-1"></i>Novo Comunicado
                            </a>
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Statistics Cards -->
            @if(!isset($student))
            <div class="row mb-4">
                <div class="col-md-3 mb-3">
                    <div class="card shadow-sm border-0 h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0">
                                    <div class="rounded p-3" style="background-color: #e7f3ff;">
                                        <i class="fas fa-bullhorn fa-2x" style="color: #0066cc;"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="text-muted mb-1 small">Total de Comunicados</h6>
                                    <h3 class="mb-0 fw-bold" style="color: #0066cc;">{{ count($models) ? $models->total() : 0 }}</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 mb-3">
                    <div class="card shadow-sm border-0 h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0">
                                    <div class="rounded p-3" style="background-color: #e8f5e9;">
                                        <i class="fas fa-filter fa-2x" style="color: #00a65a;"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="text-muted mb-1 small">Filtros Ativos</h6>
                                    @php
                                        $activeFilters = 0;
                                        if($selectedClass) $activeFilters++;
                                        if($selectedTurma) $activeFilters++;
                                        if($search) $activeFilters++;
                                        if($selectedType) $activeFilters++;
                                    @endphp
                                    <h3 class="mb-0 fw-bold" style="color: #00a65a;">{{ $activeFilters }}</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 mb-3">
                    <div class="card shadow-sm border-0 h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0">
                                    <div class="rounded p-3" style="background-color: #fff3e0;">
                                        <i class="fas fa-tag fa-2x" style="color: #ff9800;"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="text-muted mb-1 small">Tipo Filtrado</h6>
                                    <h3 class="mb-0 fw-bold" style="color: #ff9800;">{{ $selectedType ?: 'Todos' }}</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 mb-3">
                    <div class="card shadow-sm border-0 h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0">
                                    <div class="rounded p-3" style="background-color: #f3e5f5;">
                                        <i class="fas fa-graduation-cap fa-2x" style="color: #9c27b0;"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="text-muted mb-1 small">Classe Filtrada</h6>
                                    <h3 class="mb-0 fw-bold" style="color: #9c27b0;">{{ $selectedClass ?: 'Todas' }}</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endif

            <div class="row">
                <div class="col">
                    <div class="card shadow-sm border-0" style="border-radius: 12px;">
                        <div class="card-body" wire:init="loadData">
                            <!-- Header -->
                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <h5 class="card-title mb-0 text-dark">
                                    <i class="fas fa-table me-2"></i>Comunicados
                                    @if(count($models))
                                        <span class="badge bg-primary ms-2">{{ $models->total() }}</span>
                                    @endif
                                </h5>
                                @if(!isset($student))
                                <div class="d-flex gap-2">
                                    <div class="btn-group" role="group">
                                        <button type="button" wire:click="exportPDF" class="btn btn-danger btn-sm">
                                            <i class="fa fa-file-pdf me-1"></i>PDF
                                        </button>
                                        <button type="button" wire:click="exportExcel" class="btn btn-success btn-sm">
                                            <i class="fa fa-file-excel me-1"></i>Excel
                                        </button>
                                    </div>

                                    <div class="dropdown">
                                        <button type="button" class="btn btn-outline-danger btn-sm dropdown-toggle"
                                                data-bs-toggle="dropdown" aria-expanded="false">
                                            <i class="fas fa-trash-alt me-1"></i>Eliminação em Massa
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-end shadow" style="min-width: 250px;">
                                            <li>
                                                <h6 class="dropdown-header text-danger fw-bold">
                                                    <i class="fas fa-exclamation-triangle me-2"></i>Operações de Eliminação
                                                </h6>
                                            </li>
                                            <li><hr class="dropdown-divider"></li>
                                            <li>
                                                <a class="dropdown-item" href="#" wire:click.prevent="openBulkDeleteModal('all')">
                                                    <i class="fas fa-trash-alt me-2 text-danger"></i>
                                                    <span class="text-dark">Eliminar Todos os Comunicados</span>
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="#" wire:click.prevent="openBulkDeleteModal('byTurma')">
                                                    <i class="fas fa-users me-2 text-primary"></i>
                                                    <span class="text-dark">Eliminar por Turma</span>
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="#" wire:click.prevent="openBulkDeleteModal('byClasse')">
                                                    <i class="fas fa-graduation-cap me-2 text-primary"></i>
                                                    <span class="text-dark">Eliminar por Classe</span>
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="#" wire:click.prevent="openBulkDeleteModal('byDateRange')">
                                                    <i class="fas fa-calendar-alt me-2 text-info"></i>
                                                    <span class="text-dark">Eliminar por Período</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                @endif
                            </div>

                            <!-- Filters -->
                            <div class="row g-3 mb-4">
                                <div class="col-md-2">
                                    <label for="selectedType" class="form-label">Para</label>
                                    <select class="form-select" wire:model="selectedType" id="selectedType">
                                        <option value="">Todos</option>
                                        <option value="all">Todos Geral</option>
                                        <option value="class">Classe</option>
                                        <option value="student">Estudante</option>
                                    </select>
                                </div>

                                <div class="col-md-2">
                                    <label for="selectedClass" class="form-label">Classe</label>
                                    <select class="form-select" wire:model="selectedClass" id="selectedClass">
                                        <option value="">Todas</option>
                                        @foreach($classes as $class)
                                            <option value="{{ $class->class }}">{{ $class->class }}ª</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-2">
                                    <label for="selectedTurma" class="form-label">Turma</label>
                                    <select class="form-select" wire:model="selectedTurma" id="selectedTurma" {{ !$selectedClass ? 'disabled' : '' }}>
                                        <option value="">Todas</option>
                                        @foreach($turmas as $turma)
                                            <option value="{{ $turma->id }}">{{ $turma->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label for="search" class="form-label">Pesquisar</label>
                                    <input
                                        type="search"
                                        wire:model.debounce.300ms="search"
                                        placeholder="Buscar por descrição..."
                                        class="form-control"
                                        id="search"
                                    />
                                </div>
                            </div>

                            <!-- Table -->
                            <div class="table-responsive" wire:init="loadData">
                                @if(count($models))
                                    <table class="table table-hover align-middle">
                                        <thead class="table-light">
                                            <tr>
                                                <th scope="col" style="width: 50px;">#</th>
                                                <th scope="col">Para</th>
                                                <th scope="col">Classe</th>
                                                <th scope="col">Estudante</th>
                                                <th scope="col">Descrição</th>
                                                <th scope="col">Ficheiro</th>
                                                @if(!isset($student))
                                                <th scope="col">Data</th>
                                                <th scope="col" style="width: 120px;">Acção</th>
                                                @endif
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @php
                                            $count = 1;
                                            $isStudentView = isset($student);
                                        @endphp
                                        @foreach($models as $model)
                                            @php
                                                $get_class = null;
                                                $get_student = null;

                                                if(!empty($model->class_id)){
                                                    $get_class = \App\Models\Classroom::query()->where("id",$model->class_id)->first();
                                                }
                                                if(!empty($model->student_id)){
                                                    $get_student = \App\Models\User::query()->where("id",$model->student_id)->first();
                                                }

                                                // Determinar o tipo
                                                $title = '';
                                                if($model->type == "all"){
                                                    $title = "Todos";
                                                }elseif($model->type == "student"){
                                                    $title = "Estudante";
                                                }elseif($model->type == "class"){
                                                    $title = "Classe";
                                                }

                                                // Verificar permissão para estudantes
                                                $canDisplay = true;
                                                if($isStudentView){
                                                    $user = Auth::user();
                                                    $canDisplay = empty($model->student_id) || $model->student_id == $user->id;
                                                }
                                            @endphp

                                            @if($canDisplay)
                                            <tr style="transition: all 0.2s;">
                                                <th scope="row">{{ $count++ }}</th>
                                                <td>
                                                    @if($model->type == "all")
                                                        <span class="badge bg-primary">{{ $title }}</span>
                                                    @elseif($model->type == "class")
                                                        <span class="badge bg-info">{{ $title }}</span>
                                                    @else
                                                        <span class="badge bg-warning text-dark">{{ $title }}</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if(!empty($model->class_id) && $get_class)
                                                        {{ $get_class->class }}ª Classe {{ $get_class->name }}
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if(!empty($model->student_id) && $get_student)
                                                        {{ $get_student->name }}
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <strong>{!! Str::limit($model->title, 50) !!}</strong>
                                                </td>
                                                <td>
                                                    @if($model->media_url)
                                                        <a href="{{ $model->media_url }}" class="text-primary text-decoration-none" target="_blank">
                                                            <i class="fa fa-file-download me-1"></i>
                                                            {{ Str::limit($model->media_name, 30) }}
                                                        </a>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                @if(!$isStudentView)
                                                <td>
                                                    <small class="text-muted">{{ \Carbon\Carbon::parse($model->created_at)->format('d/m/Y H:i') }}</small>
                                                </td>
                                                <td>
                                                    <div class="btn-group btn-group-sm" role="group">
                                                        <a href="{{ route('admin.edit.notice', $model->slug) }}"
                                                            class="btn btn-outline-primary btn-sm">
                                                            <span class="fa fa-edit"></span>
                                                        </a>
                                                        <button type="button" wire:click="submit('{{ $model->slug }}')"
                                                            class="btn btn-outline-danger btn-sm">
                                                            <span class="fa fa-trash"></span>
                                                        </button>
                                                    </div>
                                                </td>
                                                @endif
                                            </tr>
                                            @endif
                                        @endforeach
                                        </tbody>
                                    </table>

                                    <div class="d-flex justify-content-center mt-3">
                                        {{ $models->links() }}
                                    </div>
                                @else
                                    <div class="text-center py-5">
                                        <div wire:loading class="spinner-border text-primary mb-3" role="status">
                                            <span class="visually-hidden">Processando...</span>
                                        </div>
                                        <p class="text-muted"><strong>Nenhum comunicado foi encontrado.</strong></p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bulk Delete Modal -->
    @if($showBulkDeleteModal)
    <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-light">
                    <h5 class="modal-title text-dark">
                        <i class="fas fa-trash-alt me-2 text-danger"></i>
                        @if($bulkDeleteType === 'all') Eliminação em Massa - Todos os Comunicados
                        @elseif($bulkDeleteType === 'byTurma') Eliminação em Massa - Por Turma
                        @elseif($bulkDeleteType === 'byClasse') Eliminação em Massa - Por Classe
                        @elseif($bulkDeleteType === 'byDateRange') Eliminação em Massa - Por Período
                        @endif
                    </h5>
                    <button type="button" class="btn-close" wire:click="closeBulkDeleteModal"></button>
                </div>
                <div class="modal-body">
                    @if($bulkDeleteType === 'all')
                        <div class="alert alert-danger">
                            <i class="fas fa-exclamation-circle me-2"></i>
                            <strong>ATENÇÃO!</strong> Esta ação irá eliminar TODOS os comunicados do sistema permanentemente.
                        </div>
                        <p>Tem certeza de que deseja continuar?</p>
                    @elseif($bulkDeleteType === 'byTurma')
                        <div class="mb-3">
                            <label class="form-label">Selecione a Classe</label>
                            <select class="form-select" wire:model="bulkDeleteSelectedClass">
                                <option value="">Selecione uma classe</option>
                                @foreach($classes as $class)
                                    <option value="{{ $class->class }}">{{ $class->class }}ª Classe</option>
                                @endforeach
                            </select>
                        </div>
                        @if($bulkDeleteSelectedClass)
                            <div class="mb-3">
                                <label class="form-label">Selecione a Turma</label>
                                <select class="form-select" wire:model="bulkDeleteSelectedTurma">
                                    <option value="">Selecione uma turma</option>
                                    @foreach(\App\Models\Classroom::where('class', $bulkDeleteSelectedClass)->get() as $turma)
                                        <option value="{{ $turma->id }}">{{ $turma->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        @endif
                        <div class="alert alert-warning">
                            <i class="fas fa-info-circle me-2"></i>
                            Todos os comunicados da turma selecionada serão eliminados.
                        </div>
                    @elseif($bulkDeleteType === 'byClasse')
                        <div class="mb-3">
                            <label class="form-label">Selecione a Classe</label>
                            <select class="form-select" wire:model="bulkDeleteSelectedClass">
                                <option value="">Selecione uma classe</option>
                                @foreach($classes as $class)
                                    <option value="{{ $class->class }}">{{ $class->class }}ª Classe</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="alert alert-warning">
                            <i class="fas fa-info-circle me-2"></i>
                            Todos os comunicados de todas as turmas da classe selecionada serão eliminados.
                        </div>
                    @elseif($bulkDeleteType === 'byDateRange')
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Data Inicial</label>
                                <input type="date" class="form-control" wire:model="bulkDeleteFromDate">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Data Final</label>
                                <input type="date" class="form-control" wire:model="bulkDeleteToDate">
                            </div>
                        </div>
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i>
                            Todos os comunicados criados entre as datas selecionadas serão eliminados.
                        </div>
                    @endif
                </div>
                <div class="modal-footer border-0">
                    <button type="button" class="btn btn-secondary" wire:click="closeBulkDeleteModal">
                        <i class="fas fa-times me-1"></i>Cancelar
                    </button>
                    <button type="button" class="btn btn-danger" wire:click="confirmBulkDelete">
                        <i class="fas fa-trash me-1"></i>Confirmar Eliminação
                    </button>
                </div>
            </div>
        </div>
    </div>
    @endif

    <style>
        .table-hover tbody tr:hover {
            background-color: #f8f9fa;
            transform: translateY(-2px);
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        .form-select:focus, .form-control:focus {
            border-color: #4e73df;
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
        }

        .badge {
            font-weight: 500;
            padding: 0.35em 0.65em;
        }
    </style>
</div>
