<div class="page-content">
    <div class="main-wrapper">
        <!-- Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="mb-1"><i class="fas fa-users-cog text-primary me-2"></i>Gestao de Permissoes por Role</h4>
                        <p class="text-muted mb-0">Configure permissoes para cada role do sistema de forma centralizada</p>
                    </div>
                    <div class="d-flex gap-2">
                        <button wire:click="seedDefaults" class="btn btn-outline-warning">
                            <i class="fas fa-sync me-1"></i> Restaurar Padroes
                        </button>
                        <a href="{{ route('admin.permissions') }}" class="btn btn-outline-secondary">
                            <i class="fas fa-user-shield me-1"></i> Permissoes Individuais
                        </a>
                        <a href="{{ route('admin.home') }}" class="btn btn-outline-secondary">
                            <i class="fas fa-arrow-left me-1"></i> Voltar
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tabs -->
        <ul class="nav nav-tabs mb-4" role="tablist">
            <li class="nav-item">
                <button class="nav-link {{ $activeTab === 'roles' ? 'active' : '' }}" wire:click="$set('activeTab', 'roles')">
                    <i class="fas fa-user-tag me-1"></i> Permissoes por Role
                </button>
            </li>
            <li class="nav-item">
                <button class="nav-link {{ $activeTab === 'permissions' ? 'active' : '' }}" wire:click="$set('activeTab', 'permissions')">
                    <i class="fas fa-key me-1"></i> Definicoes de Permissoes
                </button>
            </li>
        </ul>

        @if($activeTab === 'roles')
        <!-- ROLES TAB -->
        <div class="row">
            <!-- Left Sidebar - Role List -->
            <div class="col-md-3 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="fas fa-user-tag me-2"></i>Selecionar Role</h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="list-group list-group-flush">
                            @foreach($roles as $roleId => $roleName)
                                <button
                                    type="button"
                                    wire:click="selectRole({{ $roleId }})"
                                    class="list-group-item list-group-item-action {{ $selectedRole === $roleId ? 'active' : '' }}"
                                >
                                    <div class="d-flex w-100 justify-content-between align-items-center">
                                        <div>
                                            <h6 class="mb-0">{{ $roleName }}</h6>
                                            <small class="{{ $selectedRole === $roleId ? 'text-white-50' : 'text-muted' }}">
                                                Role {{ $roleId }}
                                            </small>
                                        </div>
                                        @if($selectedRole === $roleId)
                                            <i class="fas fa-chevron-right"></i>
                                        @endif
                                    </div>
                                </button>
                            @endforeach
                        </div>
                    </div>
                </div>

                <!-- Info Card -->
                <div class="card shadow-sm mt-3">
                    <div class="card-body">
                        <h6 class="text-muted mb-2"><i class="fas fa-info-circle me-1"></i> Nota</h6>
                        <small class="text-muted">
                            Super Admin (Role 0) tem automaticamente todas as permissoes e nao pode ser configurado.
                            As permissoes aqui definidas sao aplicadas a todos os usuarios com o role selecionado.
                        </small>
                    </div>
                </div>
            </div>

            <!-- Right Panel - Permissions -->
            <div class="col-md-9">
                @if($selectedRole !== null)
                    <div class="card shadow-sm">
                        <div class="card-header bg-light d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-0">
                                    <i class="fas fa-key text-primary me-2"></i>
                                    Permissoes do Role: <strong>{{ $roles[$selectedRole] ?? 'N/A' }}</strong>
                                </h5>
                            </div>
                            <div class="d-flex gap-2">
                                <button wire:click="grantAll" class="btn btn-sm btn-outline-success">
                                    <i class="fas fa-check-double me-1"></i> Marcar Todas
                                </button>
                                <button wire:click="revokeAll" class="btn btn-sm btn-outline-danger">
                                    <i class="fas fa-times me-1"></i> Desmarcar Todas
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                @foreach($availablePermissions as $groupKey => $group)
                                    <div class="col-md-6 mb-4">
                                        <div class="card h-100">
                                            <div class="card-header bg-light py-2">
                                                <h6 class="mb-0">
                                                    <i class="fas fa-folder me-1 text-warning"></i>
                                                    {{ $group['label'] }}
                                                </h6>
                                            </div>
                                            <div class="card-body py-2">
                                                @foreach($group['permissions'] as $permKey => $permLabel)
                                                    <div class="form-check mb-2">
                                                        <input
                                                            type="checkbox"
                                                            class="form-check-input"
                                                            id="perm_{{ $permKey }}"
                                                            wire:click="togglePermission('{{ $permKey }}')"
                                                            {{ $this->hasPermission($permKey) ? 'checked' : '' }}
                                                        >
                                                        <label class="form-check-label" for="perm_{{ $permKey }}">
                                                            {{ $permLabel }}
                                                        </label>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>

                            <!-- Save Button -->
                            <div class="border-top pt-3 mt-3">
                                <button wire:click="save" class="btn btn-primary btn-lg">
                                    <i class="fas fa-save me-2"></i> Salvar Permissoes do Role
                                </button>
                                <span class="text-muted ms-3">
                                    <i class="fas fa-info-circle me-1"></i>
                                    {{ count($rolePermissions) }} permissoes selecionadas
                                </span>
                            </div>
                        </div>
                    </div>
                @else
                    <div class="card shadow-sm">
                        <div class="card-body text-center py-5">
                            <i class="fas fa-hand-pointer fa-4x text-muted mb-3"></i>
                            <h5 class="text-muted">Selecione um Role</h5>
                            <p class="text-muted">Escolha um role na lista ao lado para configurar suas permissoes.</p>
                        </div>
                    </div>
                @endif
            </div>
        </div>

        @else
        <!-- PERMISSIONS TAB -->
        <div class="row">
            <!-- Left - Groups -->
            <div class="col-md-4 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
                        <h5 class="mb-0"><i class="fas fa-folder me-2"></i>Grupos de Permissoes</h5>
                    </div>
                    <div class="card-body">
                        <!-- Add New Group Form -->
                        <div class="mb-3 p-3 bg-light rounded">
                            <h6 class="mb-2"><i class="fas fa-plus me-1"></i> Novo Grupo</h6>
                            <div class="row g-2">
                                <div class="col-5">
                                    <input type="text" wire:model.defer="newGroup.key" class="form-control form-control-sm" placeholder="Chave (ex: reports)">
                                </div>
                                <div class="col-5">
                                    <input type="text" wire:model.defer="newGroup.label" class="form-control form-control-sm" placeholder="Nome (ex: Relatorios)">
                                </div>
                                <div class="col-2">
                                    <button wire:click="createGroup" class="btn btn-success btn-sm w-100">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                </div>
                            </div>
                            @error('newGroup.key') <small class="text-danger">{{ $message }}</small> @enderror
                            @error('newGroup.label') <small class="text-danger">{{ $message }}</small> @enderror
                        </div>

                        <!-- Groups List -->
                        <div class="list-group list-group-flush" style="max-height: 400px; overflow-y: auto;">
                            @forelse($permissionGroups as $group)
                                <div class="list-group-item {{ !$group->is_active ? 'bg-light text-muted' : '' }}">
                                    @if($editingGroup && $editingGroup->id === $group->id)
                                        <div class="row g-2">
                                            <div class="col-5">
                                                <input type="text" wire:model="editingGroup.key" class="form-control form-control-sm">
                                            </div>
                                            <div class="col-5">
                                                <input type="text" wire:model="editingGroup.label" class="form-control form-control-sm">
                                            </div>
                                            <div class="col-2">
                                                <button wire:click="updateGroup" class="btn btn-success btn-sm">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                            </div>
                                        </div>
                                    @else
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div>
                                                <strong>{{ $group->label }}</strong>
                                                <br><small class="text-muted">{{ $group->key }} ({{ $group->permissions->count() }} permissoes)</small>
                                            </div>
                                            <div class="btn-group btn-group-sm">
                                                <button wire:click="toggleGroupActive({{ $group->id }})" class="btn btn-outline-{{ $group->is_active ? 'warning' : 'success' }}" title="{{ $group->is_active ? 'Desativar' : 'Ativar' }}">
                                                    <i class="fas fa-{{ $group->is_active ? 'eye-slash' : 'eye' }}"></i>
                                                </button>
                                                <button wire:click="editGroup({{ $group->id }})" class="btn btn-outline-primary" title="Editar">
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                                <button wire:click="deleteGroup({{ $group->id }})" class="btn btn-outline-danger" title="Excluir">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            @empty
                                <div class="text-center py-3 text-muted">
                                    <i class="fas fa-folder-open fa-2x mb-2"></i>
                                    <p>Nenhum grupo criado</p>
                                </div>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right - Permission Definitions -->
            <div class="col-md-8">
                <div class="card shadow-sm">
                    <div class="card-header bg-info text-white d-flex justify-content-between align-items-center">
                        <h5 class="mb-0"><i class="fas fa-key me-2"></i>Definicoes de Permissoes</h5>
                    </div>
                    <div class="card-body">
                        <!-- Add New Permission Form -->
                        <div class="mb-4 p-3 bg-light rounded">
                            <h6 class="mb-2"><i class="fas fa-plus me-1"></i> Nova Permissao</h6>
                            <div class="row g-2">
                                <div class="col-md-3">
                                    <input type="text" wire:model.defer="newPermission.key" class="form-control form-control-sm" placeholder="Chave (ex: reports.view)">
                                </div>
                                <div class="col-md-3">
                                    <input type="text" wire:model.defer="newPermission.label" class="form-control form-control-sm" placeholder="Nome (ex: Ver Relatorios)">
                                </div>
                                <div class="col-md-3">
                                    <select wire:model.defer="newPermission.group_id" class="form-select form-select-sm">
                                        <option value="">Selecione o Grupo</option>
                                        @foreach($permissionGroups as $group)
                                            <option value="{{ $group->id }}">{{ $group->label }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <input type="text" wire:model.defer="newPermission.description" class="form-control form-control-sm" placeholder="Descricao (opcional)">
                                </div>
                                <div class="col-md-1">
                                    <button wire:click="createPermission" class="btn btn-info btn-sm w-100">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                </div>
                            </div>
                            @error('newPermission.key') <small class="text-danger">{{ $message }}</small> @enderror
                            @error('newPermission.label') <small class="text-danger">{{ $message }}</small> @enderror
                            @error('newPermission.group_id') <small class="text-danger">{{ $message }}</small> @enderror
                        </div>

                        <!-- Permissions List by Group -->
                        @foreach($permissionGroups as $group)
                            @if($group->permissions->count() > 0)
                                <div class="mb-4">
                                    <h6 class="border-bottom pb-2 mb-3">
                                        <i class="fas fa-folder text-warning me-1"></i> {{ $group->label }}
                                    </h6>
                                    <div class="table-responsive">
                                        <table class="table table-sm table-hover">
                                            <thead class="table-light">
                                                <tr>
                                                    <th>Chave</th>
                                                    <th>Nome</th>
                                                    <th>Descricao</th>
                                                    <th>Status</th>
                                                    <th width="120">Acoes</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($group->permissions as $permission)
                                                    <tr class="{{ !$permission->is_active ? 'table-secondary' : '' }}">
                                                        @if($editingPermission && $editingPermission->id === $permission->id)
                                                            <td><input type="text" wire:model="editingPermission.key" class="form-control form-control-sm"></td>
                                                            <td><input type="text" wire:model="editingPermission.label" class="form-control form-control-sm"></td>
                                                            <td><input type="text" wire:model="editingPermission.description" class="form-control form-control-sm"></td>
                                                            <td>-</td>
                                                            <td>
                                                                <button wire:click="updatePermission" class="btn btn-success btn-sm">
                                                                    <i class="fas fa-check"></i>
                                                                </button>
                                                            </td>
                                                        @else
                                                            <td><code>{{ $permission->key }}</code></td>
                                                            <td>{{ $permission->label }}</td>
                                                            <td><small class="text-muted">{{ $permission->description ?? '-' }}</small></td>
                                                            <td>
                                                                <span class="badge bg-{{ $permission->is_active ? 'success' : 'secondary' }}">
                                                                    {{ $permission->is_active ? 'Ativo' : 'Inativo' }}
                                                                </span>
                                                            </td>
                                                            <td>
                                                                <div class="btn-group btn-group-sm">
                                                                    <button wire:click="togglePermissionActive({{ $permission->id }})" class="btn btn-outline-{{ $permission->is_active ? 'warning' : 'success' }}" title="{{ $permission->is_active ? 'Desativar' : 'Ativar' }}">
                                                                        <i class="fas fa-{{ $permission->is_active ? 'eye-slash' : 'eye' }}"></i>
                                                                    </button>
                                                                    <button wire:click="editPermission({{ $permission->id }})" class="btn btn-outline-primary" title="Editar">
                                                                        <i class="fas fa-edit"></i>
                                                                    </button>
                                                                    <button wire:click="deletePermission({{ $permission->id }})" class="btn btn-outline-danger" title="Excluir">
                                                                        <i class="fas fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </td>
                                                        @endif
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            @endif
                        @endforeach

                        @if($permissionGroups->sum(fn($g) => $g->permissions->count()) === 0)
                            <div class="text-center py-5 text-muted">
                                <i class="fas fa-key fa-4x mb-3"></i>
                                <h5>Nenhuma permissao definida</h5>
                                <p>Clique em "Restaurar Padroes" para carregar as permissoes do sistema.</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>
