<div class="page-content">
    <div class="main-wrapper">
        <!-- Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="mb-1"><i class="fas fa-chart-line text-primary me-2"></i>Dashboard POS</h4>
                        <p class="text-muted mb-0">Visão geral das vendas e inventário</p>
                    </div>
                    <div class="d-flex gap-2">
                        <a href="{{ route('admin.pos.interface') }}" class="btn btn-primary">
                            <i class="fas fa-cash-register me-1"></i> Ir para POS
                        </a>
                        <a href="{{ route('admin.pos.settings') }}" class="btn btn-outline-warning">
                            <i class="fas fa-cog me-1"></i> Configurações
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <p class="text-muted mb-1">Vendas Hoje</p>
                                <h3 class="mb-0">{{ number_format($sales_stats['today_revenue'], 2) }} MT</h3>
                            </div>
                            <div>
                                <i class="fas fa-dollar-sign fa-2x text-success"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <p class="text-muted mb-1">Total de Vendas</p>
                                <h3 class="mb-0">{{ $sales_stats['total_sales'] }}</h3>
                            </div>
                            <div>
                                <i class="fas fa-shopping-cart fa-2x text-primary"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <p class="text-muted mb-1">Produtos Ativos</p>
                                <h3 class="mb-0">{{ $product_stats['total_products'] }}</h3>
                            </div>
                            <div>
                                <i class="fas fa-boxes fa-2x text-info"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <p class="text-muted mb-1">Stock Baixo</p>
                                <h3 class="mb-0 text-warning">{{ $product_stats['low_stock_products'] }}</h3>
                            </div>
                            <div>
                                <i class="fas fa-exclamation-triangle fa-2x text-warning"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Top Products -->
        <div class="row">
            <div class="col-md-8 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="fas fa-star me-2"></i>Produtos Mais Vendidos</h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Produto</th>
                                        <th>SKU</th>
                                        <th class="text-center">Qtd Vendida</th>
                                        <th class="text-end">Receita</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($top_products as $product)
                                        <tr>
                                            <td><strong>{{ $product->name }}</strong></td>
                                            <td><code>{{ $product->sku }}</code></td>
                                            <td class="text-center">
                                                <span class="badge bg-primary">{{ $product->total_quantity }}</span>
                                            </td>
                                            <td class="text-end">
                                                <strong>{{ number_format($product->total_revenue, 2) }} MT</strong>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="4" class="text-center text-muted py-4">
                                                Nenhuma venda registrada no período
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>Resumo</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <div class="d-flex justify-content-between mb-2">
                                <span>Receita Total:</span>
                                <strong>{{ number_format($sales_stats['total_revenue'], 2) }} MT</strong>
                            </div>
                            <div class="d-flex justify-content-between mb-2">
                                <span>Ticket Médio:</span>
                                <strong>{{ number_format($sales_stats['average_sale'], 2) }} MT</strong>
                            </div>
                            <div class="d-flex justify-content-between mb-2">
                                <span>Categorias:</span>
                                <strong>{{ $product_stats['total_categories'] }}</strong>
                            </div>
                            <div class="d-flex justify-content-between">
                                <span>Produtos Sem Stock:</span>
                                <strong class="text-danger">{{ $product_stats['out_of_stock_products'] }}</strong>
                            </div>
                        </div>

                        <hr>

                        <div class="d-grid gap-2">
                            <a href="{{ route('admin.pos.sales-report') }}" class="btn btn-success btn-sm">
                                <i class="fas fa-chart-line me-1"></i> Relatório de Vendas
                            </a>
                            <a href="{{ route('admin.pos.products') }}" class="btn btn-outline-primary btn-sm">
                                <i class="fas fa-boxes me-1"></i> Gestão de Produtos
                            </a>
                            <a href="{{ route('admin.pos.categories') }}" class="btn btn-outline-info btn-sm">
                                <i class="fas fa-tags me-1"></i> Gestão de Categorias
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
