<div class="page-content">
    <div class="main-wrapper">
        <!-- Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="mb-1"><i class="fas fa-cash-register text-primary me-2"></i>Ponto de Venda (POS)</h4>
                        <p class="text-muted mb-0">Sistema de vendas integrado</p>
                    </div>
                    <div class="d-flex gap-2">
                        <button wire:click="resetSale" class="btn btn-outline-secondary">
                            <i class="fas fa-redo me-1"></i> Limpar
                        </button>
                        <a href="{{ route('admin.pos.dashboard') }}" class="btn btn-outline-primary">
                            <i class="fas fa-chart-line me-1"></i> Dashboard
                        </a>
                        <a href="{{ route('admin.pos.products') }}" class="btn btn-outline-info">
                            <i class="fas fa-boxes me-1"></i> Produtos
                        </a>
                        <a href="{{ route('admin.pos.settings') }}" class="btn btn-outline-warning">
                            <i class="fas fa-cog me-1"></i> Configurações
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- LEFT: Products Section -->
            <div class="col-lg-8 mb-4">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <!-- Search -->
                        <div class="mb-3">
                            <div class="input-group">
                                <span class="input-group-text bg-white">
                                    <i class="fas fa-search text-muted"></i>
                                </span>
                                <input
                                    type="text"
                                    wire:model.debounce.300ms="search"
                                    class="form-control border-start-0"
                                    placeholder="Pesquisar produtos por nome ou SKU..."
                                />
                                @if($search)
                                    <button wire:click="$set('search', '')" class="btn btn-outline-secondary" type="button">
                                        <i class="fas fa-times"></i>
                                    </button>
                                @endif
                            </div>
                        </div>

                        <!-- Categories -->
                        <div class="mb-3">
                            <div class="d-flex gap-2 flex-wrap">
                                <button
                                    wire:click="selectCategory(null)"
                                    class="btn btn-sm {{ is_null($selectedCategory) ? 'btn-primary' : 'btn-outline-primary' }}"
                                >
                                    <i class="fas fa-th me-1"></i> Todos
                                </button>
                                @foreach($categories as $category)
                                    <button
                                        wire:click="selectCategory('{{ $category->id }}')"
                                        class="btn btn-sm {{ $selectedCategory == $category->id ? 'btn-primary' : 'btn-outline-primary' }}"
                                    >
                                        @if($category->icon)
                                            <i class="fas fa-{{ $category->icon }} me-1"></i>
                                        @endif
                                        {{ $category->name }}
                                        <span class="badge bg-light text-dark ms-1">{{ $category->products_count }}</span>
                                    </button>
                                @endforeach
                            </div>
                        </div>

                        <!-- Products Grid -->
                        <div class="row g-3" style="max-height: 600px; overflow-y: auto;">
                            @forelse($products as $product)
                                <div class="col-sm-6 col-md-4 col-lg-3">
                                    <div
                                        wire:click="addToCart('{{ $product->id }}')"
                                        class="card h-100 product-card {{ $product->is_low_stock ? 'border-warning' : '' }}"
                                        style="cursor: pointer; transition: all 0.2s;"
                                    >
                                        @if($product->image)
                                            <img src="{{ asset('storage/' . $product->image) }}" class="card-img-top" alt="{{ $product->name }}" style="height: 150px; object-fit: cover;">
                                        @else
                                            <div class="card-img-top bg-light d-flex align-items-center justify-content-center" style="height: 150px;">
                                                <i class="fas fa-box fa-3x text-muted"></i>
                                            </div>
                                        @endif

                                        @if($product->discount_price)
                                            <span class="position-absolute top-0 end-0 badge bg-danger m-2">
                                                <i class="fas fa-tag"></i> Promoção
                                            </span>
                                        @endif

                                        <div class="card-body p-2">
                                            <h6 class="card-title mb-1" style="font-size: 0.9rem;">{{ $product->name }}</h6>
                                            <p class="card-text text-muted mb-2" style="font-size: 0.75rem;">{{ $product->sku }}</p>

                                            @if($product->discount_price)
                                                <p class="mb-1">
                                                    <small class="text-muted text-decoration-line-through">{{ number_format($product->selling_price, 2) }} MT</small>
                                                    <br>
                                                    <strong class="text-success">{{ number_format($product->discount_price, 2) }} MT</strong>
                                                </p>
                                            @else
                                                <p class="mb-1">
                                                    <strong class="text-primary">{{ number_format($product->selling_price, 2) }} MT</strong>
                                                </p>
                                            @endif

                                            <small class="badge bg-{{ $product->stock_status == 'in_stock' ? 'success' : ($product->stock_status == 'low_stock' ? 'warning' : 'danger') }}">
                                                <i class="fas fa-box me-1"></i>{{ $product->quantity }} unidades
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <div class="col-12 text-center py-5">
                                    <i class="fas fa-box-open fa-4x text-muted mb-3"></i>
                                    <p class="text-muted">Nenhum produto encontrado</p>
                                </div>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>

            <!-- RIGHT: Cart & Checkout -->
            <div class="col-lg-4">
                <div class="card shadow-sm sticky-top" style="top: 20px;">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">
                            <i class="fas fa-shopping-cart me-2"></i>Carrinho
                            <span class="badge bg-white text-primary float-end">{{ count($cart) }}</span>
                        </h5>
                    </div>

                    <div class="card-body p-0">
                        <!-- Customer Section -->
                        <div class="p-3 bg-light border-bottom">
                            <label class="form-label mb-2">
                                <i class="fas fa-user-graduate text-primary me-1"></i>
                                <strong>Estudante (Opcional)</strong>
                            </label>
                            <input
                                type="text"
                                wire:model.lazy="student_id"
                                class="form-control"
                                placeholder="ID do Estudante"
                            />
                            @if($student)
                                <div class="alert alert-success mt-2 mb-0 py-2">
                                    <i class="fas fa-check-circle me-1"></i>
                                    <strong>{{ $student->name }}</strong>
                                    <button wire:click="$set('student_id', null)" class="btn-close btn-close-sm float-end"></button>
                                </div>
                            @endif
                        </div>

                        <!-- Cart Items -->
                        <div class="p-3" style="max-height: 400px; overflow-y: auto;">
                            @forelse($cart as $key => $item)
                                <div class="card mb-2 border">
                                    <div class="card-body p-2">
                                        <div class="row align-items-center g-2">
                                            <div class="col-3">
                                                @if($item['image'])
                                                    <img src="{{ asset('storage/' . $item['image']) }}" class="img-fluid rounded" alt="{{ $item['name'] }}">
                                                @else
                                                    <div class="bg-light rounded d-flex align-items-center justify-content-center" style="height: 60px;">
                                                        <i class="fas fa-box text-muted"></i>
                                                    </div>
                                                @endif
                                            </div>

                                            <div class="col-9">
                                                <h6 class="mb-0" style="font-size: 0.85rem;">{{ $item['name'] }}</h6>
                                                <small class="text-muted">{{ $item['sku'] }}</small>
                                                @if($item['variant'])
                                                    <br><span class="badge bg-info">{{ $item['variant'] }}</span>
                                                @endif
                                                <p class="mb-0 mt-1">
                                                    <strong class="text-primary">{{ number_format($item['unit_price'], 2) }} MT</strong>
                                                </p>
                                            </div>

                                            <div class="col-12 mt-2">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div class="btn-group" role="group">
                                                        <button
                                                            wire:click="updateQuantity('{{ $key }}', {{ $item['quantity'] - 1 }})"
                                                            class="btn btn-sm btn-outline-secondary"
                                                            {{ $item['quantity'] <= 1 ? 'disabled' : '' }}
                                                        >
                                                            <i class="fas fa-minus"></i>
                                                        </button>
                                                        <button class="btn btn-sm btn-outline-secondary" disabled>
                                                            <strong>{{ $item['quantity'] }}</strong>
                                                        </button>
                                                        <button
                                                            wire:click="updateQuantity('{{ $key }}', {{ $item['quantity'] + 1 }})"
                                                            class="btn btn-sm btn-outline-secondary"
                                                            {{ $item['quantity'] >= $item['max_quantity'] ? 'disabled' : '' }}
                                                        >
                                                            <i class="fas fa-plus"></i>
                                                        </button>
                                                    </div>

                                                    <button
                                                        wire:click="removeFromCart('{{ $key }}')"
                                                        class="btn btn-sm btn-outline-danger"
                                                    >
                                                        <i class="fas fa-trash"></i>
                                                    </button>

                                                    <strong class="text-dark">{{ number_format($item['quantity'] * $item['unit_price'], 2) }} MT</strong>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <div class="text-center py-5">
                                    <i class="fas fa-shopping-cart fa-3x text-muted mb-3"></i>
                                    <p class="text-muted mb-0">Carrinho vazio</p>
                                    <small class="text-muted">Adicione produtos para começar</small>
                                </div>
                            @endforelse
                        </div>

                        <!-- Checkout -->
                        @if(!empty($cart))
                            <div class="p-3 bg-light border-top">
                                <!-- Summary -->
                                <table class="table table-sm mb-3">
                                    <tbody>
                                        <tr>
                                            <td>Subtotal:</td>
                                            <td class="text-end"><strong>{{ number_format($subtotal, 2) }} MT</strong></td>
                                        </tr>
                                        <tr>
                                            <td>Desconto:</td>
                                            <td class="text-end">
                                                <div class="input-group input-group-sm">
                                                    <input
                                                        type="number"
                                                        wire:model="discount"
                                                        class="form-control form-control-sm text-end"
                                                        step="0.01"
                                                        min="0"
                                                        placeholder="0.00"
                                                    />
                                                    <span class="input-group-text">MT</span>
                                                </div>
                                            </td>
                                        </tr>
                                        @if($tax_enabled)
                                            <tr class="text-primary">
                                                <td>IVA ({{ $tax_rate }}%):</td>
                                                <td class="text-end"><strong>{{ number_format($tax, 2) }} MT</strong></td>
                                            </tr>
                                        @endif
                                        <tr class="table-active">
                                            <td><strong>TOTAL:</strong></td>
                                            <td class="text-end">
                                                <h5 class="mb-0 text-primary">{{ number_format($total, 2) }} MT</h5>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>

                                <!-- Payment Method -->
                                <div class="mb-3">
                                    <label class="form-label"><strong>Método de Pagamento:</strong></label>
                                    <div class="row g-2">
                                        <div class="col-6">
                                            <button
                                                wire:click="$set('payment_method', 'cash')"
                                                class="btn btn-sm w-100 {{ $payment_method == 'cash' ? 'btn-primary' : 'btn-outline-primary' }}"
                                            >
                                                <i class="fas fa-money-bill-wave d-block mb-1"></i>
                                                <small>Dinheiro</small>
                                            </button>
                                        </div>
                                        <div class="col-6">
                                            <button
                                                wire:click="$set('payment_method', 'mpesa')"
                                                class="btn btn-sm w-100 {{ $payment_method == 'mpesa' ? 'btn-primary' : 'btn-outline-primary' }}"
                                            >
                                                <i class="fas fa-mobile-alt d-block mb-1"></i>
                                                <small>M-Pesa</small>
                                            </button>
                                        </div>
                                        <div class="col-6">
                                            <button
                                                wire:click="$set('payment_method', 'emola')"
                                                class="btn btn-sm w-100 {{ $payment_method == 'emola' ? 'btn-primary' : 'btn-outline-primary' }}"
                                            >
                                                <i class="fas fa-wallet d-block mb-1"></i>
                                                <small>e-Mola</small>
                                            </button>
                                        </div>
                                        <div class="col-6">
                                            <button
                                                wire:click="$set('payment_method', 'bank_transfer')"
                                                class="btn btn-sm w-100 {{ $payment_method == 'bank_transfer' ? 'btn-primary' : 'btn-outline-primary' }}"
                                            >
                                                <i class="fas fa-university d-block mb-1"></i>
                                                <small>Transferência</small>
                                            </button>
                                        </div>
                                    </div>
                                </div>

                                <!-- Notes -->
                                <div class="mb-3">
                                    <textarea
                                        wire:model="notes"
                                        class="form-control form-control-sm"
                                        rows="2"
                                        placeholder="Notas adicionais (opcional)..."
                                    ></textarea>
                                </div>

                                <!-- Checkout Button -->
                                <button
                                    wire:click="processSale"
                                    class="btn btn-success btn-lg w-100"
                                >
                                    <i class="fas fa-check-circle me-2"></i>Finalizar Venda
                                </button>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .product-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.15);
        }
    </style>
</div>
