<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col-12">
                    <!-- Header -->
                    <div class="card border-0 shadow-sm mb-4">
                        <div class="card-header text-white py-3" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;">
                            <h2 class="h5 mb-0 text-white">
                                <i class="fa fa-shield-alt me-2"></i>Configurações de Permissões
                            </h2>
                        </div>
                    </div>

                    <!-- Permissions Card -->
                    <div class="card border-0 shadow-sm">
                        <div class="card-header bg-white border-bottom py-3">
                            <h5 class="mb-0">
                                <i class="fa fa-user-lock me-2 text-primary"></i>Permissões do Sistema
                            </h5>
                            <p class="text-muted small mb-0 mt-2">
                                Configure as permissões de acesso para diferentes tipos de usuários no sistema
                            </p>
                        </div>
                        <div class="card-body p-4">
                            <form class="row g-4" wire:submit.prevent="savePermission">

                                <!-- Permission 1: Lançamento de Notas -->
                                <div class="col-md-6">
                                    <div class="card border h-100">
                                        <div class="card-body">
                                            <div class="d-flex align-items-start mb-3">
                                                <div class="flex-shrink-0">
                                                    <div class="avatar-sm rounded-circle bg-primary bg-opacity-10 d-flex align-items-center justify-content-center">
                                                        <i class="fa fa-chalkboard-teacher text-primary fs-5"></i>
                                                    </div>
                                                </div>
                                                <div class="flex-grow-1 ms-3">
                                                    <h6 class="mb-1">Lançamento de Notas</h6>
                                                    <p class="text-muted small mb-0">Permite que professores lancem notas dos alunos</p>
                                                </div>
                                            </div>

                                            <label for="canAddMarks" class="form-label fw-semibold">
                                                Deseja permitir lançamento de notas para professores?
                                                <span class="text-danger">*</span>
                                            </label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light">
                                                    <i class="fa fa-edit"></i>
                                                </span>
                                                <select
                                                    class="form-select @error('canAddMarks') is-invalid @enderror"
                                                    id="canAddMarks"
                                                    wire:model="canAddMarks">
                                                    <option value="no">❌ Não Permitir</option>
                                                    <option value="yes">✅ Permitir</option>
                                                </select>
                                                @error('canAddMarks')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>

                                            @if($canAddMarks === 'yes')
                                                <div class="alert alert-success mt-3 mb-0" role="alert">
                                                    <i class="fa fa-check-circle me-2"></i>
                                                    <strong>Ativo:</strong> Professores podem lançar notas
                                                </div>
                                            @else
                                                <div class="alert alert-warning mt-3 mb-0" role="alert">
                                                    <i class="fa fa-exclamation-triangle me-2"></i>
                                                    <strong>Inativo:</strong> Professores não podem lançar notas
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <!-- Permission 2: Edição de Notas -->
                                <div class="col-md-6">
                                    <div class="card border h-100">
                                        <div class="card-body">
                                            <div class="d-flex align-items-start mb-3">
                                                <div class="flex-shrink-0">
                                                    <div class="avatar-sm rounded-circle bg-info bg-opacity-10 d-flex align-items-center justify-content-center">
                                                        <i class="fa fa-user-edit text-info fs-5"></i>
                                                    </div>
                                                </div>
                                                <div class="flex-grow-1 ms-3">
                                                    <h6 class="mb-1">Edição de Notas</h6>
                                                    <p class="text-muted small mb-0">Permite que registro acadêmico edite notas</p>
                                                </div>
                                            </div>

                                            <label for="canEditMarks" class="form-label fw-semibold">
                                                Deseja permitir edição de notas para reg. acadêmico?
                                                <span class="text-danger">*</span>
                                            </label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light">
                                                    <i class="fa fa-pen"></i>
                                                </span>
                                                <select
                                                    class="form-select @error('canEditMarks') is-invalid @enderror"
                                                    id="canEditMarks"
                                                    wire:model="canEditMarks">
                                                    <option value="no">❌ Não Permitir</option>
                                                    <option value="yes">✅ Permitir</option>
                                                </select>
                                                @error('canEditMarks')
                                                    <div class="invalid-feedback">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>

                                            @if($canEditMarks === 'yes')
                                                <div class="alert alert-success mt-3 mb-0" role="alert">
                                                    <i class="fa fa-check-circle me-2"></i>
                                                    <strong>Ativo:</strong> Registro acadêmico pode editar notas
                                                </div>
                                            @else
                                                <div class="alert alert-warning mt-3 mb-0" role="alert">
                                                    <i class="fa fa-exclamation-triangle me-2"></i>
                                                    <strong>Inativo:</strong> Registro acadêmico não pode editar notas
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <!-- Submit Button -->
                                <div class="col-12">
                                    <div class="d-flex justify-content-between align-items-center pt-3 border-top">
                                        <div>
                                            <p class="text-muted small mb-0">
                                                <i class="fa fa-info-circle me-1"></i>
                                                As alterações serão aplicadas imediatamente após guardar
                                            </p>
                                        </div>
                                        <button
                                            type="submit"
                                            class="btn btn-primary btn-lg px-5"
                                            wire:loading.attr="disabled"
                                            wire:offline.attr="disabled">
                                            <span wire:loading.remove wire:target="savePermission">
                                                <i class="fa fa-save me-2"></i>Guardar Configurações
                                            </span>
                                            <span wire:loading wire:target="savePermission">
                                                <span class="spinner-border spinner-border-sm me-2"></span>
                                                Guardando...
                                            </span>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .avatar-sm {
            width: 48px;
            height: 48px;
        }

        .card {
            transition: all 0.3s ease;
        }

        .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
        }
    </style>
</div>
