<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Relatório final de cada disciplina</h5>
                            <form class="row g-3" wire:submit.prevent="generateReport">
                                <!-- Year selection should come first -->
                                <div class="col-md-6">
                                    <label for="year" class="form-label">Ano</label>
                                    <select class="form-control @error('year') is-invalid @enderror"
                                            id="year" wire:model="year"
                                            class="form-control input-lg dynamic">
                                        <option value="">Selecione o ano lectivo</option>

                                        @php
                                            $currentYear = (int)date('Y');
                                            $startYear = $currentYear - 2; // 2 years back
                                            $endYear = $currentYear + 5;   // 5 years into future
                                        @endphp

                                        @for($year = $startYear; $year <= $endYear; $year++)
                                            <option value="{{ $year }}" {{ $year == $currentYear ? 'selected' : '' }}>{{ $year }}</option>
                                        @endfor
                                    </select>
                                    @error('year')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label for="class" class="form-label">Classe</label>
                                    <select class="form-control @error('class') is-invalid @enderror"
                                            id="class" wire:model="class"
                                            class="form-control input-lg dynamic">
                                       <option value="">Selecione a classe</option>

                                       @if($user->role == 2 && !empty($availableClassLevels))
                                            @foreach([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12] as $classLevel)
                                                @if(in_array($classLevel, $availableClassLevels))
                                                    <option value="{{ $classLevel }}">{{ $classLevel }}ª Classe</option>
                                                @endif
                                            @endforeach
                                        @else
                                            <!-- Admin sees all classes -->
                                            <option value="1">1ª Classe</option>
                                            <option value="2">2ª Classe</option>
                                            <option value="3">3ª Classe</option>
                                            <option value="4">4ª Classe</option>
                                            <option value="5">5ª Classe</option>
                                            <option value="6">6ª Classe</option>
                                            <option value="7">7ª Classe</option>
                                            <option value="8">8ª Classe</option>
                                            <option value="9">9ª Classe</option>
                                            <option value="10">10ª Classe</option>
                                            <option value="11">11ª Classe</option>
                                            <option value="12">12ª Classe</option>
                                        @endif
                                    </select>
                                    @error('class')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label for="class_id" class="form-label">Turma</label>
                                    <div class="form-floating">
                                        <select name="number"
                                            class="form-control @error('class_id') is-invalid @enderror" id="class_id"
                                            required placeholder="Select Date" wire:model="class_id">
                                            <option value="" selected="selected">Selecione a turma</option>
                                            @foreach ($classes as $class)
                                                <option value="{{ $class->id }}">{{ $class->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('class_id')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <label for="subject_id" class="form-label">Disciplina </label>
                                    <div class="form-floating">
                                        <select name="number"
                                            class="form-control @error('subject_id') is-invalid @enderror"
                                            id="subject_id" required placeholder="" wire:model="subject_id">
                                            <option value="" selected="selected">Selecione disciplina</option>
                                            @foreach ($subjects as $subject)
                                                <option value="{{ $subject->id }}">{{ $subject->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('subject_id')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary btn-lg float-end"
                                        wire:loading.class="disabled" wire:offline.attr="disabled"><span
                                            wire:target="generateReport"
                                            wire:loading.class="spinner-border spinner-border-lg"></span>
                                        Gerar relatório
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
