<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row" wire:init="loadData">
                <div class="col">
                    {{-- Header Banner --}}
                    <div class="card mb-3" style="border: none; border-radius: 12px; overflow: hidden; box-shadow: 0 4px 15px rgba(0,0,0,0.08);">
                        <div style="background: linear-gradient(135deg, #1a5276 0%, #2e86de 100%); padding: 20px 25px; color: white;">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 class="mb-1" style="font-weight: 700; color: white;">
                                        <i class="fas fa-clipboard-list me-2"></i>Pré-inscrições
                                    </h5>
                                    <small style="opacity: 0.85;">Gestão de pré-inscrições e matrículas</small>
                                </div>
                                <a href="{{ route('pre-enrollment.public') }}" target="_blank" class="btn btn-sm" style="background: rgba(255,255,255,0.15); color: white; border: 1px solid rgba(255,255,255,0.3); border-radius: 8px; font-weight: 600;">
                                    <i class="fas fa-external-link-alt me-1"></i> Formulário Público
                                </a>
                            </div>
                        </div>
                    </div>

                    @if(!$readyToLoad)
                        <div class="text-center py-5">
                            <div class="spinner-border text-primary" role="status"></div>
                            <p class="mt-2 text-muted">A carregar...</p>
                        </div>
                    @else
                        {{-- Stats Cards --}}
                        <div class="row mb-3 g-2">
                            <div class="col-6 col-md">
                                <div class="card h-100 border-0 shadow-sm" style="cursor: pointer; border-radius: 10px; overflow: hidden; transition: all 0.2s; {{ $selectedStatus === '' ? 'box-shadow: 0 0 0 2px #4e73df, 0 4px 12px rgba(78,115,223,0.3) !important;' : '' }}" wire:click="$set('selectedStatus', '')" onmouseover="this.style.transform='translateY(-3px)';this.style.boxShadow='0 6px 20px rgba(0,0,0,0.12)'" onmouseout="this.style.transform='translateY(0)';this.style.boxShadow=''">
                                    <div style="height: 4px; background: linear-gradient(135deg, #4e73df, #224abe);"></div>
                                    <div class="card-body text-center py-3 px-2">
                                        <div style="width: 40px; height: 40px; border-radius: 10px; background: linear-gradient(135deg, rgba(78,115,223,0.1), rgba(78,115,223,0.05)); display: flex; align-items: center; justify-content: center; margin: 0 auto 10px;">
                                            <i class="fas fa-clipboard-list" style="color: #4e73df; font-size: 1rem;"></i>
                                        </div>
                                        <h3 class="mb-1" style="font-weight: 700; color: #4e73df; font-size: 1.6rem;">{{ $stats['total'] ?? 0 }}</h3>
                                        <small style="font-weight: 600; color: #64748b; font-size: 0.68rem; text-transform: uppercase; letter-spacing: 0.8px;">Total</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6 col-md">
                                <div class="card h-100 border-0 shadow-sm" style="cursor: pointer; border-radius: 10px; overflow: hidden; transition: all 0.2s; {{ $selectedStatus === 'pendente' ? 'box-shadow: 0 0 0 2px #f6c23e, 0 4px 12px rgba(246,194,62,0.3) !important;' : '' }}" wire:click="$set('selectedStatus', 'pendente')" onmouseover="this.style.transform='translateY(-3px)';this.style.boxShadow='0 6px 20px rgba(0,0,0,0.12)'" onmouseout="this.style.transform='translateY(0)';this.style.boxShadow=''">
                                    <div style="height: 4px; background: linear-gradient(135deg, #f6c23e, #dda20a);"></div>
                                    <div class="card-body text-center py-3 px-2">
                                        <div style="width: 40px; height: 40px; border-radius: 10px; background: linear-gradient(135deg, rgba(246,194,62,0.1), rgba(246,194,62,0.05)); display: flex; align-items: center; justify-content: center; margin: 0 auto 10px;">
                                            <i class="fas fa-clock" style="color: #f6c23e; font-size: 1rem;"></i>
                                        </div>
                                        <h3 class="mb-1" style="font-weight: 700; color: #e0a800; font-size: 1.6rem;">{{ $stats['pendentes'] ?? 0 }}</h3>
                                        <small style="font-weight: 600; color: #64748b; font-size: 0.68rem; text-transform: uppercase; letter-spacing: 0.8px;">Pendentes</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6 col-md">
                                <div class="card h-100 border-0 shadow-sm" style="cursor: pointer; border-radius: 10px; overflow: hidden; transition: all 0.2s; {{ $selectedStatus === 'confirmada' ? 'box-shadow: 0 0 0 2px #36b9cc, 0 4px 12px rgba(54,185,204,0.3) !important;' : '' }}" wire:click="$set('selectedStatus', 'confirmada')" onmouseover="this.style.transform='translateY(-3px)';this.style.boxShadow='0 6px 20px rgba(0,0,0,0.12)'" onmouseout="this.style.transform='translateY(0)';this.style.boxShadow=''">
                                    <div style="height: 4px; background: linear-gradient(135deg, #36b9cc, #258391);"></div>
                                    <div class="card-body text-center py-3 px-2">
                                        <div style="width: 40px; height: 40px; border-radius: 10px; background: linear-gradient(135deg, rgba(54,185,204,0.1), rgba(54,185,204,0.05)); display: flex; align-items: center; justify-content: center; margin: 0 auto 10px;">
                                            <i class="fas fa-check-circle" style="color: #36b9cc; font-size: 1rem;"></i>
                                        </div>
                                        <h3 class="mb-1" style="font-weight: 700; color: #36b9cc; font-size: 1.6rem;">{{ $stats['confirmadas'] ?? 0 }}</h3>
                                        <small style="font-weight: 600; color: #64748b; font-size: 0.68rem; text-transform: uppercase; letter-spacing: 0.8px;">Confirmadas</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6 col-md">
                                <div class="card h-100 border-0 shadow-sm" style="cursor: pointer; border-radius: 10px; overflow: hidden; transition: all 0.2s; {{ $selectedStatus === 'matriculada' ? 'box-shadow: 0 0 0 2px #1cc88a, 0 4px 12px rgba(28,200,138,0.3) !important;' : '' }}" wire:click="$set('selectedStatus', 'matriculada')" onmouseover="this.style.transform='translateY(-3px)';this.style.boxShadow='0 6px 20px rgba(0,0,0,0.12)'" onmouseout="this.style.transform='translateY(0)';this.style.boxShadow=''">
                                    <div style="height: 4px; background: linear-gradient(135deg, #1cc88a, #169b6b);"></div>
                                    <div class="card-body text-center py-3 px-2">
                                        <div style="width: 40px; height: 40px; border-radius: 10px; background: linear-gradient(135deg, rgba(28,200,138,0.1), rgba(28,200,138,0.05)); display: flex; align-items: center; justify-content: center; margin: 0 auto 10px;">
                                            <i class="fas fa-user-graduate" style="color: #1cc88a; font-size: 1rem;"></i>
                                        </div>
                                        <h3 class="mb-1" style="font-weight: 700; color: #1cc88a; font-size: 1.6rem;">{{ $stats['matriculadas'] ?? 0 }}</h3>
                                        <small style="font-weight: 600; color: #64748b; font-size: 0.68rem; text-transform: uppercase; letter-spacing: 0.8px;">Matriculadas</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6 col-md">
                                <div class="card h-100 border-0 shadow-sm" style="cursor: pointer; border-radius: 10px; overflow: hidden; transition: all 0.2s; {{ $selectedStatus === 'anulada' ? 'box-shadow: 0 0 0 2px #e74a3b, 0 4px 12px rgba(231,74,59,0.3) !important;' : '' }}" wire:click="$set('selectedStatus', 'anulada')" onmouseover="this.style.transform='translateY(-3px)';this.style.boxShadow='0 6px 20px rgba(0,0,0,0.12)'" onmouseout="this.style.transform='translateY(0)';this.style.boxShadow=''">
                                    <div style="height: 4px; background: linear-gradient(135deg, #e74a3b, #be2617);"></div>
                                    <div class="card-body text-center py-3 px-2">
                                        <div style="width: 40px; height: 40px; border-radius: 10px; background: linear-gradient(135deg, rgba(231,74,59,0.1), rgba(231,74,59,0.05)); display: flex; align-items: center; justify-content: center; margin: 0 auto 10px;">
                                            <i class="fas fa-times-circle" style="color: #e74a3b; font-size: 1rem;"></i>
                                        </div>
                                        <h3 class="mb-1" style="font-weight: 700; color: #e74a3b; font-size: 1.6rem;">{{ $stats['anuladas'] ?? 0 }}</h3>
                                        <small style="font-weight: 600; color: #64748b; font-size: 0.68rem; text-transform: uppercase; letter-spacing: 0.8px;">Anuladas</small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- Filters --}}
                        <div class="card mb-3" style="border: none; border-radius: 10px; box-shadow: 0 2px 8px rgba(0,0,0,0.06);">
                            <div class="card-body p-3">
                                <div class="row g-2 align-items-center">
                                    <div class="col-md-4">
                                        <div class="position-relative">
                                            <i class="fas fa-search position-absolute" style="left: 10px; top: 50%; transform: translateY(-50%); color: #94a3b8; font-size: 0.8rem;"></i>
                                            <input type="text" class="form-control form-control-sm" style="padding-left: 32px; border-radius: 8px; border: 1px solid #e2e8f0;" placeholder="Buscar nome, código, telefone..." wire:model.debounce.300ms="search">
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <select class="form-select form-select-sm" style="border-radius: 8px; border: 1px solid #e2e8f0;" wire:model="selectedStatus">
                                            <option value="">Todos Status</option>
                                            <option value="pendente">Pendente</option>
                                            <option value="confirmada">Confirmada</option>
                                            <option value="matriculada">Matriculada</option>
                                            <option value="anulada">Anulada</option>
                                        </select>
                                    </div>
                                    <div class="col-md-2">
                                        <select class="form-select form-select-sm" style="border-radius: 8px; border: 1px solid #e2e8f0;" wire:model="selectedYear">
                                            <option value="">Todos Anos</option>
                                            @for($y = date('Y') + 1; $y >= date('Y') - 2; $y--)
                                                <option value="{{ $y }}">{{ $y }}</option>
                                            @endfor
                                        </select>
                                    </div>
                                    <div class="col-md-2">
                                        <select class="form-select form-select-sm" style="border-radius: 8px; border: 1px solid #e2e8f0;" wire:model="selectedClass">
                                            <option value="">Todas Classes</option>
                                            @foreach($availableClasses as $cls)
                                                <option value="{{ $cls }}">{{ $cls }}a Classe</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-2 text-end">
                                        <span style="font-size: 0.75rem; color: #94a3b8;">
                                            <i class="fas fa-filter me-1"></i>
                                            @if(is_object($records) && method_exists($records, 'total'))
                                                {{ $records->total() }} resultado(s)
                                            @endif
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- Table --}}
                        <div class="card" style="border: none; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.06); overflow: hidden;">
                            <div class="card-body p-0">
                                @if(is_object($records) && $records->count() > 0)
                                    <div class="table-responsive">
                                        <table class="table table-sm table-hover mb-0" style="font-size: 0.85rem;">
                                            <thead>
                                                <tr style="background: linear-gradient(135deg, #f8fafc, #f1f5f9);">
                                                    <th style="padding: 0.7rem 1rem; color: #475569; font-weight: 700; font-size: 0.7rem; text-transform: uppercase; letter-spacing: 0.5px; border-bottom: 2px solid #e2e8f0;">Código</th>
                                                    <th style="padding: 0.7rem 1rem; color: #475569; font-weight: 700; font-size: 0.7rem; text-transform: uppercase; letter-spacing: 0.5px; border-bottom: 2px solid #e2e8f0;">Candidato</th>
                                                    <th style="padding: 0.7rem 1rem; color: #475569; font-weight: 700; font-size: 0.7rem; text-transform: uppercase; letter-spacing: 0.5px; border-bottom: 2px solid #e2e8f0;">Contacto</th>
                                                    <th style="padding: 0.7rem 1rem; color: #475569; font-weight: 700; font-size: 0.7rem; text-transform: uppercase; letter-spacing: 0.5px; border-bottom: 2px solid #e2e8f0;">Classe</th>
                                                    <th style="padding: 0.7rem 1rem; color: #475569; font-weight: 700; font-size: 0.7rem; text-transform: uppercase; letter-spacing: 0.5px; border-bottom: 2px solid #e2e8f0;">Ano</th>
                                                    <th style="padding: 0.7rem 1rem; color: #475569; font-weight: 700; font-size: 0.7rem; text-transform: uppercase; letter-spacing: 0.5px; border-bottom: 2px solid #e2e8f0;">Status</th>
                                                    <th style="padding: 0.7rem 1rem; color: #475569; font-weight: 700; font-size: 0.7rem; text-transform: uppercase; letter-spacing: 0.5px; border-bottom: 2px solid #e2e8f0;">Data</th>
                                                    <th style="padding: 0.7rem 1rem; color: #475569; font-weight: 700; font-size: 0.7rem; text-transform: uppercase; letter-spacing: 0.5px; border-bottom: 2px solid #e2e8f0; text-align: center;">Acções</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($records as $record)
                                                    <tr style="transition: background 0.15s; border-bottom: 1px solid #f1f5f9;">
                                                        <td style="padding: 0.7rem 1rem; vertical-align: middle;">
                                                            <span style="font-weight: 700; color: #1a5276; font-size: 0.8rem; background: #f0f7ff; padding: 3px 8px; border-radius: 4px;">{{ $record->code }}</span>
                                                        </td>
                                                        <td style="padding: 0.7rem 1rem; vertical-align: middle;">
                                                            <div style="font-weight: 600; color: #1e293b;">{{ $record->candidate_name }}</div>
                                                        </td>
                                                        <td style="padding: 0.7rem 1rem; vertical-align: middle;">
                                                            <span style="color: #64748b;"><i class="fas fa-phone-alt me-1" style="font-size: 0.7rem;"></i>{{ $record->candidate_phone }}</span>
                                                        </td>
                                                        <td style="padding: 0.7rem 1rem; vertical-align: middle;">
                                                            <span style="font-weight: 600; color: #475569;">{{ $record->desired_class }}a</span>
                                                        </td>
                                                        <td style="padding: 0.7rem 1rem; vertical-align: middle;">
                                                            <span style="color: #64748b;">{{ $record->academic_year }}</span>
                                                        </td>
                                                        <td style="padding: 0.7rem 1rem; vertical-align: middle;">
                                                            <span class="badge bg-{{ $record->getStatusBadgeClass() }}" style="font-size: 0.72rem; padding: 4px 10px; border-radius: 6px; font-weight: 600;">{{ $record->getStatusLabel() }}</span>
                                                        </td>
                                                        <td style="padding: 0.7rem 1rem; vertical-align: middle;">
                                                            <span style="color: #94a3b8; font-size: 0.8rem;">{{ $record->submitted_at ? $record->submitted_at->format('d/m/Y') : '-' }}</span>
                                                        </td>
                                                        <td style="padding: 0.7rem 1rem; vertical-align: middle; text-align: center;">
                                                            <div class="d-flex justify-content-center gap-1">
                                                                <a href="{{ route('admin.secretary.show', $record->id) }}" class="btn btn-sm" style="background: rgba(78,115,223,0.1); color: #4e73df; border: none; border-radius: 6px; width: 30px; height: 30px; display: flex; align-items: center; justify-content: center;" title="Ver detalhes">
                                                                    <i class="fas fa-eye" style="font-size: 0.75rem;"></i>
                                                                </a>
                                                                @if($record->isConfirmada())
                                                                    <a href="{{ route('admin.secretary.enroll', $record->id) }}" class="btn btn-sm" style="background: rgba(28,200,138,0.1); color: #1cc88a; border: none; border-radius: 6px; width: 30px; height: 30px; display: flex; align-items: center; justify-content: center;" title="Matricular">
                                                                        <i class="fas fa-user-check" style="font-size: 0.75rem;"></i>
                                                                    </a>
                                                                @endif
                                                                @if($record->isPendente())
                                                                    <button class="btn btn-sm" style="background: rgba(231,74,59,0.1); color: #e74a3b; border: none; border-radius: 6px; width: 30px; height: 30px; display: flex; align-items: center; justify-content: center;" wire:click="anularPreEnrollment('{{ $record->id }}')" title="Anular">
                                                                        <i class="fas fa-times" style="font-size: 0.75rem;"></i>
                                                                    </button>
                                                                @endif
                                                            </div>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="p-3" style="border-top: 1px solid #f1f5f9;">
                                        {{ $records->links() }}
                                    </div>
                                @else
                                    <div class="text-center py-5">
                                        <div style="width: 70px; height: 70px; border-radius: 50%; background: #f1f5f9; display: flex; align-items: center; justify-content: center; margin: 0 auto 15px;">
                                            <i class="fas fa-inbox" style="font-size: 1.8rem; color: #cbd5e1;"></i>
                                        </div>
                                        <p style="color: #94a3b8; font-weight: 500;">Nenhuma pré-inscrição encontrada.</p>
                                        <small style="color: #cbd5e1;">Tente ajustar os filtros ou aguarde novas submissões.</small>
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
