<div>
    <div class="page-heading">
        <div class="page-title">
            <div class="row">
                <div class="col-12 col-md-6 order-md-1 order-last">
                    <h3><i class="fa fa-bell me-2"></i>Configurações de Lembretes de Pagamento</h3>
                    <p class="text-subtitle text-muted">Configure lembretes automáticos via SMS para estudantes</p>
                </div>
                <div class="col-12 col-md-6 order-md-2 order-first">
                    <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                        <button wire:click="openCreateModal" class="btn btn-primary">
                            <i class="fa fa-plus me-1"></i>Novo Lembrete
                        </button>
                    </nav>
                </div>
            </div>
        </div>
    </div>

    <div class="page-content">
        <section class="section">
            <!-- Alerts -->
            @if (session()->has('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="fa fa-check-circle me-2"></i>
                    <strong>Sucesso!</strong> {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if (session()->has('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="fa fa-exclamation-circle me-2"></i>
                    <strong>Erro!</strong> {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <!-- Global Settings Card -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header bg-primary">
                            <h6 class="card-title text-white mb-0">
                                <i class="fa fa-cog me-2"></i>Configurações Globais
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <div class="alert alert-info mb-0">
                                        <h6 class="alert-heading"><i class="fa fa-info-circle me-2"></i>Como funciona</h6>
                                        <p class="mb-2"><strong>O sistema envia SMS automáticos APENAS para:</strong></p>
                                        <ul class="mb-2">
                                            <li>Estudantes com <strong>pagamentos pendentes</strong></li>
                                            <li>Quando faltam <strong>X dias</strong> para o vencimento (configurável abaixo)</li>
                                            <li>No <strong>dia do vencimento</strong> (último aviso)</li>
                                        </ul>
                                        <p class="mb-2"><small><i class="fa fa-check-circle me-1"></i>Estudantes em dia NÃO recebem SMS. Cada lembrete é enviado apenas UMA vez por referência.</small></p>
                                        <p class="mb-0"><small><i class="fa fa-calendar-check me-1"></i>Configure se deseja enviar <strong>1x ou 2x por dia</strong> e escolha os horários.
                                        <button wire:click="showVariables" class="btn btn-link btn-sm p-0">Ver variáveis disponíveis</button></small></p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="p-3 bg-light rounded">
                                        <label class="form-label fw-semibold mb-3">
                                            <i class="fa fa-calendar-check me-1"></i> Frequência de Envio
                                        </label>

                                        <!-- Frequência: 1x ou 2x por dia -->
                                        <div class="mb-3">
                                            <div class="btn-group w-100" role="group">
                                                <input type="radio" class="btn-check" wire:model="sendFrequency" value="1" id="freq1" autocomplete="off">
                                                <label class="btn btn-outline-primary" for="freq1">
                                                    <i class="fa fa-calendar me-1"></i> 1x por dia
                                                </label>

                                                <input type="radio" class="btn-check" wire:model="sendFrequency" value="2" id="freq2" autocomplete="off">
                                                <label class="btn btn-outline-primary" for="freq2">
                                                    <i class="fa fa-calendar-plus me-1"></i> 2x por dia
                                                </label>
                                            </div>
                                        </div>

                                        <!-- Primeiro Horário -->
                                        <div class="mb-2">
                                            <label class="form-label text-sm mb-1">
                                                <i class="fa fa-clock me-1"></i>
                                                @if($sendFrequency == 2) Primeiro @endif Horário
                                            </label>
                                            <div class="input-group input-group-sm">
                                                <span class="input-group-text"><i class="fa fa-clock"></i></span>
                                                <input type="time" wire:model.defer="sendTime" class="form-control">
                                            </div>
                                        </div>

                                        <!-- Segundo Horário (apenas se 2x) -->
                                        @if($sendFrequency == 2)
                                            <div class="mb-3">
                                                <label class="form-label text-sm mb-1">
                                                    <i class="fa fa-clock me-1"></i> Segundo Horário
                                                </label>
                                                <div class="input-group input-group-sm">
                                                    <span class="input-group-text"><i class="fa fa-clock"></i></span>
                                                    <input type="time" wire:model.defer="sendTime2" class="form-control">
                                                </div>
                                            </div>
                                        @endif

                                        <!-- Botão Salvar -->
                                        <button wire:click="saveSendTime" class="btn btn-primary w-100">
                                            <i class="fa fa-save me-1"></i> Salvar Configuração
                                        </button>

                                        <!-- Status Atual -->
                                        <div class="mt-2 p-2 bg-white rounded border">
                                            <small class="text-muted d-block">
                                                <i class="fa fa-info-circle me-1"></i><strong>Configuração Atual:</strong>
                                            </small>
                                            <small class="text-dark">
                                                @if($sendFrequency == 1)
                                                    1x por dia às <strong>{{ $sendTime }}</strong>
                                                @else
                                                    2x por dia às <strong>{{ $sendTime }}</strong> e <strong>{{ $sendTime2 }}</strong>
                                                @endif
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Statistics Cards -->
            <div class="row mb-4">
                <div class="col-xl-4 col-md-6 mb-3">
                    <div class="card card-stats">
                        <div class="card-body">
                            <div class="row">
                                <div class="col">
                                    <div class="numbers">
                                        <p class="text-sm mb-0 text-uppercase font-weight-bold">Total de Lembretes</p>
                                        <h5 class="font-weight-bolder mb-0">
                                            {{ $settings->count() }}
                                            <span class="text-success text-sm font-weight-bolder ms-2">
                                                <i class="fa fa-bell"></i>
                                            </span>
                                        </h5>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <div class="icon icon-shape bg-gradient-primary shadow text-center border-radius-md">
                                        <i class="fa fa-list text-lg opacity-10"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6 mb-3">
                    <div class="card card-stats">
                        <div class="card-body">
                            <div class="row">
                                <div class="col">
                                    <div class="numbers">
                                        <p class="text-sm mb-0 text-uppercase font-weight-bold">Lembretes Ativos</p>
                                        <h5 class="font-weight-bolder mb-0">
                                            {{ $settings->where('enabled', true)->count() }}
                                            <span class="text-success text-sm font-weight-bolder ms-2">
                                                <i class="fa fa-arrow-up"></i>
                                            </span>
                                        </h5>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <div class="icon icon-shape bg-gradient-success shadow text-center border-radius-md">
                                        <i class="fa fa-check-circle text-lg opacity-10"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6 mb-3">
                    <div class="card card-stats">
                        <div class="card-body">
                            <div class="row">
                                <div class="col">
                                    <div class="numbers">
                                        <p class="text-sm mb-0 text-uppercase font-weight-bold">Lembretes Inativos</p>
                                        <h5 class="font-weight-bolder mb-0">
                                            {{ $settings->where('enabled', false)->count() }}
                                            <span class="text-warning text-sm font-weight-bolder ms-2">
                                                <i class="fa fa-pause"></i>
                                            </span>
                                        </h5>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <div class="icon icon-shape bg-gradient-warning shadow text-center border-radius-md">
                                        <i class="fa fa-pause-circle text-lg opacity-10"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Main Content Card -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header bg-primary">
                            <h5 class="card-title text-white mb-0">
                                <i class="fa fa-table me-2"></i>Lembretes Configurados
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Prioridade</th>
                                            <th>Nome</th>
                                            <th>Dias antes</th>
                                            <th>Preview da Mensagem</th>
                                            <th>Status</th>
                                            <th>Ações</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($settings as $setting)
                                            <tr>
                                                <td>
                                                    <span class="badge bg-dark">{{ $setting->priority }}</span>
                                                </td>
                                                <td>
                                                    <i class="fa fa-bell text-primary me-1"></i>
                                                    <strong>{{ $setting->name }}</strong>
                                                </td>
                                                <td>
                                                    @if($setting->days_before == 0)
                                                        <span class="badge bg-danger">
                                                            <i class="fa fa-exclamation-triangle me-1"></i>
                                                            Dia do vencimento
                                                        </span>
                                                    @else
                                                        <span class="badge bg-warning text-dark">
                                                            <i class="fa fa-clock me-1"></i>
                                                            {{ $setting->days_before }} dias antes
                                                        </span>
                                                    @endif
                                                </td>
                                                <td style="max-width: 300px;">
                                                    <small class="text-muted" style="font-family: monospace;">{{ Str::limit($setting->message_template, 100) }}</small>
                                                </td>
                                                <td>
                                                    <div class="form-check form-switch">
                                                        <input
                                                            class="form-check-input"
                                                            type="checkbox"
                                                            wire:click="toggleEnabled({{ $setting->id }})"
                                                            {{ $setting->enabled ? 'checked' : '' }}>
                                                        <label class="form-check-label">
                                                            <span class="badge {{ $setting->enabled ? 'bg-success' : 'bg-secondary' }}">
                                                                {{ $setting->enabled ? 'Ativo' : 'Inativo' }}
                                                            </span>
                                                        </label>
                                                    </div>
                                                </td>
                                                <td>
                                                    <button wire:click="openEditModal({{ $setting->id }})"
                                                            class="btn btn-sm btn-primary"
                                                            title="Editar">
                                                        <i class="fa fa-edit"></i>
                                                    </button>
                                                    <button wire:click="delete({{ $setting->id }})"
                                                            onclick="return confirm('Tem certeza que deseja excluir este lembrete?')"
                                                            class="btn btn-sm btn-danger"
                                                            title="Excluir">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="6" class="text-center py-4">
                                                    <i class="fa fa-inbox fa-3x text-muted mb-3"></i>
                                                    <p class="text-muted mb-3">Nenhum lembrete configurado</p>
                                                    <button wire:click="openCreateModal" class="btn btn-primary btn-sm">
                                                        <i class="fa fa-plus me-1"></i> Criar Primeiro Lembrete
                                                    </button>
                                                </td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <!-- Modal para Criar/Editar Lembrete -->
    @if($showModal)
        <div class="modal fade show" style="display: block; background-color: rgba(0,0,0,0.5);" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title">
                            <i class="fa {{ $editingId ? 'fa-edit' : 'fa-plus-circle' }} me-2"></i>
                            {{ $editingId ? 'Editar Lembrete' : 'Novo Lembrete' }}
                        </h5>
                        <button type="button" class="btn-close btn-close-white" wire:click="$set('showModal', false)"></button>
                    </div>
                    <div class="modal-body">
                        <form wire:submit.prevent="save">
                            <div class="row">
                                <div class="col-md-8 mb-3">
                                    <label class="form-label fw-semibold">
                                        Nome do Lembrete <span class="text-danger">*</span>
                                    </label>
                                    <input type="text"
                                           wire:model="name"
                                           class="form-control"
                                           placeholder="Ex: Lembrete 3 dias antes">
                                    @error('name') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label class="form-label fw-semibold">
                                        Dias antes <span class="text-danger">*</span>
                                    </label>
                                    <input type="number"
                                           wire:model="days_before"
                                           class="form-control"
                                           min="0"
                                           placeholder="0">
                                    <small class="text-muted">0 = Dia do vencimento</small>
                                    @error('days_before') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>

                                <div class="col-12 mb-3">
                                    <label class="form-label fw-semibold">
                                        Mensagem SMS (Template) <span class="text-danger">*</span>
                                    </label>
                                    <textarea wire:model="message_template"
                                              class="form-control"
                                              rows="8"
                                              style="font-family: monospace;"
                                              placeholder="Use variáveis como {student_name}, {amount}, etc."></textarea>
                                    <div class="d-flex justify-content-between mt-2">
                                        <small class="text-muted">
                                            <button type="button" wire:click="showVariables" class="btn btn-link btn-sm p-0">
                                                Ver variáveis disponíveis
                                            </button>
                                        </small>
                                        <small class="text-muted">Máx: 160 caracteres recomendado</small>
                                    </div>
                                    @error('message_template') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label class="form-label fw-semibold">
                                        Prioridade <span class="text-danger">*</span>
                                    </label>
                                    <input type="number"
                                           wire:model="priority"
                                           class="form-control"
                                           min="1"
                                           placeholder="1">
                                    <small class="text-muted">Define a ordem de execução</small>
                                    @error('priority') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label class="form-label fw-semibold">Status</label>
                                    <div class="form-check form-switch mt-2">
                                        <input class="form-check-input"
                                               type="checkbox"
                                               wire:model="enabled"
                                               id="enabledCheck">
                                        <label class="form-check-label" for="enabledCheck">
                                            <span class="badge {{ $enabled ? 'bg-success' : 'bg-secondary' }}">
                                                {{ $enabled ? 'Ativo' : 'Inativo' }}
                                            </span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="$set('showModal', false)">
                            <i class="fa fa-times me-1"></i> Cancelar
                        </button>
                        <button type="button" wire:click="save" class="btn btn-primary">
                            <i class="fa fa-save me-1"></i> Salvar
                        </button>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Modal de Variáveis Disponíveis -->
    @if($showVariablesModal)
        <div class="modal fade show" style="display: block; background-color: rgba(0,0,0,0.5);" tabindex="-1">
            <div class="modal-dialog modal-xl">
                <div class="modal-content">
                    <div class="modal-header bg-gradient-info text-white">
                        <h5 class="modal-title">
                            <i class="fa fa-code me-2"></i>
                            Guia de Variáveis para Templates SMS
                        </h5>
                        <button type="button" class="btn-close btn-close-white" wire:click="closeVariablesModal"></button>
                    </div>
                    <div class="modal-body p-4">
                        <div class="alert alert-light border-start border-4 border-info">
                            <div class="d-flex align-items-center">
                                <i class="fa fa-lightbulb fa-2x text-info me-3"></i>
                                <div>
                                    <h6 class="mb-1">Como usar variáveis</h6>
                                    <p class="mb-0 text-sm">Digite as variáveis entre chaves <code>{variavel}</code> no template da mensagem. Elas serão automaticamente substituídas pelos valores reais quando o SMS for enviado.</p>
                                </div>
                            </div>
                        </div>

                        <h6 class="mt-4 mb-3"><i class="fa fa-list me-2"></i>Variáveis Disponíveis</h6>

                        <div class="row">
                            @foreach($availableVariables as $var => $description)
                                <div class="col-md-6 mb-3">
                                    <div class="card h-100 border-0 shadow-sm">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between align-items-start mb-2">
                                                <code class="bg-light px-2 py-1 rounded text-primary" style="font-size: 14px;">{!! '{' . $var . '}' !!}</code>
                                                <span class="badge bg-info">
                                                    @if($var === 'student_name')
                                                        Texto
                                                    @elseif(in_array($var, ['amount']))
                                                        Número
                                                    @elseif(in_array($var, ['due_date']))
                                                        Data
                                                    @else
                                                        Texto
                                                    @endif
                                                </span>
                                            </div>
                                            <p class="text-sm mb-2"><strong>{{ $description }}</strong></p>
                                            <div class="bg-light p-2 rounded">
                                                <small class="text-muted">Exemplo:</small>
                                                <small class="d-block text-dark">
                                                    @if($var === 'student_name')
                                                        João Silva
                                                    @elseif($var === 'amount')
                                                        1,500.00
                                                    @elseif($var === 'fee_month')
                                                        Janeiro
                                                    @elseif($var === 'fee_year')
                                                        2026
                                                    @elseif($var === 'entity_code')
                                                        12345
                                                    @elseif($var === 'reference_number')
                                                        123456789
                                                    @elseif($var === 'due_date')
                                                        15/02/2026
                                                    @elseif($var === 'days_left')
                                                        2
                                                    @endif
                                                </small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <h6 class="mt-4 mb-3"><i class="fa fa-file-text me-2"></i>Exemplos de Templates</h6>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <div class="card border-0 shadow-sm">
                                    <div class="card-header bg-success text-white">
                                        <strong>Template: Lembrete Simples</strong>
                                    </div>
                                    <div class="card-body">
                                        <pre class="mb-0 bg-dark text-white p-3 rounded" style="font-size: 12px;">Olá {student_name}!

Lembrete: Sua referência vence em {days_left} dias.

Referência: {reference_number}
Valor: {amount} MT
Vencimento: {due_date}

Pague via BCI!</pre>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6 mb-3">
                                <div class="card border-0 shadow-sm">
                                    <div class="card-header bg-danger text-white">
                                        <strong>Template: Urgente</strong>
                                    </div>
                                    <div class="card-body">
                                        <pre class="mb-0 bg-dark text-white p-3 rounded" style="font-size: 12px;">⚠️ URGENTE {student_name}!

Sua referência VENCE HOJE!

Entidade: {entity_code}
Referência: {reference_number}
Valor: {amount} MT

Pague AGORA para evitar multa!</pre>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer bg-light">
                        <button type="button" class="btn btn-primary" wire:click="closeVariablesModal">
                            <i class="fa fa-check me-1"></i> Entendi
                        </button>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>

<style>
.card-stats {
    overflow: hidden;
    transition: transform 0.3s ease;
}

.card-stats:hover {
    transform: translateY(-5px);
}

.icon-shape {
    width: 48px;
    height: 48px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    text-align: center;
    border-radius: 0.75rem;
}

.bg-gradient-primary {
    background: linear-gradient(87deg, #5e72e4 0, #825ee4 100%);
}

.bg-gradient-success {
    background: linear-gradient(87deg, #2dce89 0, #2dcecc 100%);
}

.bg-gradient-warning {
    background: linear-gradient(87deg, #fb6340 0, #fbb140 100%);
}

.border-radius-md {
    border-radius: 0.5rem;
}

.opacity-10 {
    opacity: 1 !important;
}

.icon-shape i {
    color: white;
}

.numbers h5 {
    font-size: 1.5rem;
}

.card-stats .card-body {
    padding: 1.5rem;
}
</style>
