<div>
    <div class="page-heading">
        <div class="page-title">
            <div class="row">
                <div class="col-12 col-md-6 order-md-1 order-last">
                    <h3><i class="fa fa-id-card me-2"></i>Scanner de Bilhetes de Identidade (OCR)</h3>
                    <p class="text-subtitle text-muted">Upload e extração automática de dados dos BIs</p>
                </div>
            </div>
        </div>
    </div>

    <div class="page-content">
        <!-- Estatísticas -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card bg-primary text-white">
                    <div class="card-body">
                        <h6 class="text-white mb-0">Total</h6>
                        <h3 class="text-white">{{ $stats['total'] }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-warning text-white">
                    <div class="card-body">
                        <h6 class="text-white mb-0">Processados</h6>
                        <h3 class="text-white">{{ $stats['processed'] }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-success text-white">
                    <div class="card-body">
                        <h6 class="text-white mb-0">Confirmados</h6>
                        <h3 class="text-white">{{ $stats['confirmed'] }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-danger text-white">
                    <div class="card-body">
                        <h6 class="text-white mb-0">Requer Revisão</h6>
                        <h3 class="text-white">{{ $stats['requires_review'] }}</h3>
                    </div>
                </div>
            </div>
        </div>

        <!-- Upload de Documentos -->
        <div class="card mb-4">
            <div class="card-header bg-primary">
                <h5 class="card-title text-white mb-0">
                    <i class="fa fa-upload me-2"></i>Upload de Bilhetes de Identidade
                </h5>
            </div>
            <div class="card-body">
                <div class="alert alert-success">
                    <i class="fa fa-magic me-2"></i>
                    <strong>Fluxo Automático Rápido:</strong>
                    <ul class="mb-0 mt-2">
                        <li><strong>1.</strong> Selecione foto(s) do BI ou PDF(s) escaneado(s)</li>
                        <li><strong>2.</strong> Sistema processa e detecta estudante automaticamente</li>
                        <li><strong>3.</strong> Aparece preview com dados extraídos</li>
                        <li><strong>4.</strong> Clica OK para confirmar ou Pular para revisar depois</li>
                        <li><strong>5.</strong> Próximo BI é processado automaticamente!</li>
                    </ul>
                    <div class="mt-2 text-muted small">
                        <i class="fa fa-lightbulb me-1"></i>
                        <strong>Dica:</strong> Pode selecionar vários BIs de uma vez. O sistema processará um por vez mostrando preview de cada um.
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-bold">Selecionar BIs (Imagens ou PDFs)</label>
                    <input type="file" id="document-input" class="form-control form-control-lg" multiple accept="image/*,.pdf">
                    <input type="file" wire:model="documents" id="livewire-document-input" multiple accept="image/*,.pdf" style="display: none;">
                    <small class="text-muted">Formatos: JPG, PNG, GIF, PDF (máx 10MB cada)</small>
                    <div id="conversion-status" class="mt-2" style="display: none;">
                        <div class="alert alert-info mb-0">
                            <span class="spinner-border spinner-border-sm me-2"></span>
                            <span id="conversion-message">Convertendo PDF para imagem...</span>
                        </div>
                    </div>
                    @error('documents.*') <span class="text-danger d-block mt-1">{{ $message }}</span> @enderror
                </div>

                <div class="row g-2">
                    <div class="col-md-6">
                        <button
                            wire:click="uploadDocuments"
                            wire:loading.attr="disabled"
                            class="btn btn-primary btn-lg w-100"
                            @if(!count($documents)) disabled @endif>
                            <span wire:loading.remove wire:target="uploadDocuments">
                                <i class="fa fa-rocket me-2"></i>Processar Selecionados
                            </span>
                            <span wire:loading wire:target="uploadDocuments">
                                <span class="spinner-border spinner-border-sm me-2"></span>
                                Processando...
                            </span>
                        </button>
                    </div>
                    <div class="col-md-6">
                        <button
                            wire:click="$set('showCameraModal', true)"
                            class="btn btn-success btn-lg w-100">
                            <i class="fa fa-camera me-2"></i>Usar Câmera
                        </button>
                    </div>
                </div>

                @if(count($documents) > 0)
                    <div class="alert alert-info mt-3 mb-0">
                        <i class="fa fa-file-image me-2"></i>
                        <strong>{{ count($documents) }} documento(s) selecionado(s)</strong> - Pronto para processar
                    </div>
                @endif
            </div>
        </div>

        <!-- Filtros -->
        <div class="card mb-4">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <label class="form-label">Status</label>
                        <select wire:model="filterStatus" class="form-select">
                            <option value="all">Todos</option>
                            <option value="pending">Pendente</option>
                            <option value="processing">Processando</option>
                            <option value="processed">Processado</option>
                            <option value="confirmed">Confirmado</option>
                            <option value="failed">Falhou</option>
                        </select>
                    </div>
                    <div class="col-md-8">
                        <label class="form-label">Pesquisar</label>
                        <input
                            type="text"
                            wire:model.debounce.500ms="searchTerm"
                            class="form-control"
                            placeholder="Nome, Nº BI, Código do aluno...">
                    </div>
                </div>
            </div>
        </div>

        <!-- Lista de Documentos -->
        <div class="card">
            <div class="card-header bg-light">
                <h5 class="mb-0"><i class="fa fa-list me-2"></i>Documentos Processados</h5>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Imagem</th>
                                <th>Dados Extraídos</th>
                                <th>Código Aluno</th>
                                <th>Confiança</th>
                                <th>Status</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($scannedDocuments as $doc)
                                <tr class="@if($doc->requires_review) table-warning @endif">
                                    <td>
                                        <img
                                            src="{{ Storage::url($doc->image_path) }}"
                                            alt="BI"
                                            style="max-width: 80px; max-height: 80px; cursor: pointer;"
                                            onclick="window.open('{{ Storage::url($doc->image_path) }}', '_blank')">
                                    </td>
                                    <td>
                                        <strong>{{ $doc->full_name ?? 'N/A' }}</strong><br>
                                        <small class="text-muted">
                                            BI: {{ $doc->document_id ?? 'N/A' }}<br>
                                            Nasc: {{ $doc->dob?->format('d/m/Y') ?? 'N/A' }}<br>
                                            Pai: {{ $doc->father_name ?? 'N/A' }}<br>
                                            Mãe: {{ $doc->mother_name ?? 'N/A' }}
                                        </small>
                                    </td>
                                    <td>
                                        {{ $doc->student_code ?? '-' }}
                                        @if($doc->student)
                                            <br><small class="text-success">Vinculado</small>
                                        @endif
                                    </td>
                                    <td>
                                        @if($doc->confidence_score)
                                            <div class="progress" style="height: 20px;">
                                                <div class="progress-bar
                                                    @if($doc->confidence_score >= 90) bg-success
                                                    @elseif($doc->confidence_score >= 70) bg-warning
                                                    @else bg-danger
                                                    @endif"
                                                    style="width: {{ $doc->confidence_score }}%">
                                                    {{ round($doc->confidence_score) }}%
                                                </div>
                                            </div>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($doc->status == 'pending')
                                            <span class="badge bg-secondary">Pendente</span>
                                        @elseif($doc->status == 'processing')
                                            <span class="badge bg-info">Processando</span>
                                        @elseif($doc->status == 'processed')
                                            <span class="badge bg-warning">Processado</span>
                                        @elseif($doc->status == 'confirmed')
                                            <span class="badge bg-success">Confirmado</span>
                                        @else
                                            <span class="badge bg-danger">Falhou</span>
                                        @endif

                                        @if($doc->requires_review)
                                            <br><small class="text-danger">Requer revisão</small>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            @if($doc->status == 'processed')
                                                <button
                                                    wire:click="editDocument('{{ $doc->id }}')"
                                                    class="btn btn-sm btn-primary"
                                                    title="Editar">
                                                    <i class="fa fa-edit"></i>
                                                </button>
                                                <button
                                                    wire:click="confirmDocument('{{ $doc->id }}')"
                                                    class="btn btn-sm btn-success"
                                                    title="Confirmar e Aplicar">
                                                    <i class="fa fa-check"></i>
                                                </button>
                                            @endif

                                            @if($doc->status == 'failed')
                                                <button
                                                    wire:click="reprocessDocument('{{ $doc->id }}')"
                                                    class="btn btn-sm btn-warning"
                                                    title="Reprocessar">
                                                    <i class="fa fa-refresh"></i>
                                                </button>
                                            @endif

                                            <button
                                                wire:click="deleteDocument('{{ $doc->id }}')"
                                                class="btn btn-sm btn-danger"
                                                onclick="return confirm('Tem certeza?')"
                                                title="Deletar">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="text-center py-4 text-muted">
                                        Nenhum documento encontrado
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            @if($scannedDocuments->hasPages())
                <div class="card-footer">
                    {{ $scannedDocuments->links() }}
                </div>
            @endif
        </div>
    </div>

    <!-- Modal de Edição -->
    @if($showEditModal && $editingDocument)
        <div class="modal fade show d-block" tabindex="-1" style="background: rgba(0,0,0,0.5);">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title">Editar Dados Extraídos</h5>
                        <button type="button" class="btn-close" wire:click="$set('showEditModal', false)"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Código do Aluno</label>
                                <input type="text" wire:model="editData.student_code" class="form-control" placeholder="Ex: CPME-1004">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Tipo de Documento</label>
                                <select wire:model="editData.document_type" class="form-select">
                                    <option value="BI">Bilhete de Identidade</option>
                                    <option value="DIRE">DIRE</option>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Número do BI</label>
                                <input type="text" wire:model="editData.document_id" class="form-control">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Nome Completo *</label>
                                <input type="text" wire:model="editData.full_name" class="form-control">
                                @error('editData.full_name') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Data de Nascimento</label>
                                <input type="date" wire:model="editData.dob" class="form-control">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Sexo</label>
                                <select wire:model="editData.sex" class="form-select">
                                    <option value="">Selecionar...</option>
                                    <option value="M">Masculino</option>
                                    <option value="F">Feminino</option>
                                </select>
                            </div>
                            <div class="col-md-12 mb-3">
                                <label class="form-label">Nome do Pai</label>
                                <input type="text" wire:model="editData.father_name" class="form-control">
                            </div>
                            <div class="col-md-12 mb-3">
                                <label class="form-label">Nome da Mãe</label>
                                <input type="text" wire:model="editData.mother_name" class="form-control">
                            </div>
                            <div class="col-md-12 mb-3">
                                <label class="form-label">Local de Nascimento</label>
                                <input type="text" wire:model="editData.birth_place" class="form-control">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Distrito</label>
                                <input type="text" wire:model="editData.birth_district" class="form-control">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Província</label>
                                <input type="text" wire:model="editData.birth_province" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="$set('showEditModal', false)">Cancelar</button>
                        <button type="button" class="btn btn-primary" wire:click="saveEdit">Salvar Alterações</button>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Modal de Confirmação -->
    @if($showConfirmModal && $confirmingDocument)
        <div class="modal fade show d-block" tabindex="-1" style="background: rgba(0,0,0,0.5);">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header bg-success text-white">
                        <h5 class="modal-title">Confirmar e Aplicar Dados</h5>
                        <button type="button" class="btn-close" wire:click="$set('showConfirmModal', false)"></button>
                    </div>
                    <div class="modal-body">
                        <p>Confirmar aplicação dos seguintes dados ao estudante <strong>{{ $confirmingDocument->student_code }}</strong>?</p>

                        <table class="table table-sm">
                            <tr>
                                <th>Nome:</th>
                                <td>{{ $confirmingDocument->full_name }}</td>
                            </tr>
                            <tr>
                                <th>BI:</th>
                                <td>{{ $confirmingDocument->document_id }}</td>
                            </tr>
                            <tr>
                                <th>Data Nasc:</th>
                                <td>{{ $confirmingDocument->dob?->format('d/m/Y') }}</td>
                            </tr>
                            <tr>
                                <th>Pai:</th>
                                <td>{{ $confirmingDocument->father_name }}</td>
                            </tr>
                            <tr>
                                <th>Mãe:</th>
                                <td>{{ $confirmingDocument->mother_name }}</td>
                            </tr>
                        </table>

                        <div class="alert alert-warning">
                            <i class="fa fa-exclamation-triangle me-2"></i>
                            <strong>Atenção:</strong> Esta ação irá atualizar os dados do estudante no sistema.
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="$set('showConfirmModal', false)">Cancelar</button>
                        <button type="button" class="btn btn-success" wire:click="applyToStudent">
                            <i class="fa fa-check me-2"></i>Confirmar e Aplicar
                        </button>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Modal de Preview Automático -->
    @if($showPreviewModal && $this->previewDocument)
        <div class="modal fade show d-block" tabindex="-1" style="background: rgba(0,0,0,0.5);">
            <div class="modal-dialog modal-lg modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-success text-white">
                        <h5 class="modal-title">
                            <i class="fa fa-check-circle me-2"></i>
                            BI Processado com Sucesso!
                        </h5>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <!-- Imagem do BI -->
                            <div class="col-md-5">
                                <div class="mb-2">
                                    <span class="badge bg-primary">FRENTE</span>
                                </div>
                                <img
                                    src="{{ Storage::url($this->previewDocument->image_path) }}"
                                    class="img-fluid rounded border"
                                    alt="BI - Frente">

                                @if($this->previewDocument->back_image_path)
                                    <div class="mt-3 mb-2">
                                        <span class="badge bg-warning">VERSO</span>
                                    </div>
                                    <img
                                        src="{{ Storage::url($this->previewDocument->back_image_path) }}"
                                        class="img-fluid rounded border"
                                        alt="BI - Verso">
                                @endif

                                <div class="mt-2">
                                    <span class="badge bg-info">
                                        Confiança: {{ $this->previewDocument->confidence_score }}%
                                    </span>
                                    @if($this->previewDocument->back_image_path)
                                        <span class="badge bg-success ms-1">
                                            <i class="fa fa-check"></i> Frente e Verso
                                        </span>
                                    @else
                                        <span class="badge bg-warning ms-1">
                                            <i class="fa fa-exclamation"></i> Apenas Frente
                                        </span>
                                    @endif
                                </div>
                            </div>

                            <!-- Dados Extraídos -->
                            <div class="col-md-7">
                                @if($this->detectedStudent)
                                    <div class="alert alert-success mb-3">
                                        <i class="fa fa-user-check me-2"></i>
                                        <strong>Estudante Detectado:</strong><br>
                                        <span class="fs-5">{{ $this->detectedStudent->name }}</span><br>
                                        <small class="text-muted">Código: {{ $this->detectedStudent->student_id }}</small>
                                    </div>
                                @else
                                    <div class="alert alert-warning mb-3">
                                        <i class="fa fa-exclamation-triangle me-2"></i>
                                        <strong>Estudante não detectado automaticamente</strong><br>
                                        <small>Os dados serão salvos, mas precisam ser vinculados manualmente depois</small>
                                    </div>
                                @endif

                                <h6 class="border-bottom pb-2 mb-3">Dados Extraídos do BI:</h6>

                                <div class="row mb-2">
                                    <div class="col-5"><strong>Nº BI:</strong></div>
                                    <div class="col-7">{{ $this->previewDocument->document_id ?? 'N/A' }}</div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-5"><strong>Nome Completo:</strong></div>
                                    <div class="col-7">{{ $this->previewDocument->full_name ?? 'N/A' }}</div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-5"><strong>Data Nasc:</strong></div>
                                    <div class="col-7">{{ $this->previewDocument->dob?->format('d/m/Y') ?? 'N/A' }}</div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-5"><strong>Sexo:</strong></div>
                                    <div class="col-7">{{ $this->previewDocument->sex ?? 'N/A' }}</div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-5"><strong>Pai:</strong></div>
                                    <div class="col-7">{{ $this->previewDocument->father_name ?? 'N/A' }}</div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-5"><strong>Mãe:</strong></div>
                                    <div class="col-7">{{ $this->previewDocument->mother_name ?? 'N/A' }}</div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-5"><strong>Naturalidade:</strong></div>
                                    <div class="col-7">{{ $this->previewDocument->birth_place ?? 'N/A' }}</div>
                                </div>

                                @if($this->previewDocument->birth_district || $this->previewDocument->birth_province)
                                    <div class="row mb-2">
                                        <div class="col-5"><strong>Distrito/Província:</strong></div>
                                        <div class="col-7">
                                            {{ $this->previewDocument->birth_district ?? '' }}
                                            @if($this->previewDocument->birth_province), {{ $this->previewDocument->birth_province }}@endif
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>

                        @if($this->detectedStudent)
                            <div class="alert alert-info mt-3 mb-0">
                                <i class="fa fa-info-circle me-2"></i>
                                Ao clicar em <strong>OK</strong>, os dados acima serão aplicados ao estudante <strong>{{ $this->detectedStudent->name }}</strong>.
                            </div>
                        @endif
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" wire:click="skipPreview">
                            <i class="fa fa-forward me-2"></i>Pular
                        </button>

                        @if($this->previewDocument->back_image_path)
                            <button type="button" class="btn btn-info" disabled>
                                <i class="fa fa-check-circle me-2"></i>Verso Capturado
                            </button>
                        @else
                            <button type="button" class="btn btn-warning" wire:click="startCapturingBackSide('{{ $this->previewDocument->id }}')">
                                <i class="fa fa-camera me-2"></i>Capturar Verso
                            </button>
                        @endif

                        <button type="button" class="btn btn-success btn-lg" wire:click="confirmPreview">
                            <i class="fa fa-check me-2"></i>OK - Confirmar e Próximo
                        </button>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Modal de Câmera -->
    @if($showCameraModal)
        <div class="modal fade show d-block" tabindex="-1" style="background: rgba(0,0,0,0.8);">
            <div class="modal-dialog modal-lg modal-dialog-centered">
                <div class="modal-content"
                     data-capturing-back-side="{{ $capturingBackSide ? '1' : '0' }}"
                     data-back-side-document-id="{{ $backSideDocumentId ?? '' }}">
                    <div class="modal-header {{ $capturingBackSide ? 'bg-warning' : 'bg-success' }} text-white">
                        <h5 class="modal-title">
                            <i class="fa fa-camera me-2"></i>
                            Capturar {{ $capturingBackSide ? 'VERSO' : 'FRENTE' }} do BI
                        </h5>
                        <button type="button" class="btn-close btn-close-white" wire:click="closeCameraModal"></button>
                    </div>
                    <div class="modal-body text-center">
                        <div id="camera-container">
                            <!-- Preview da câmera -->
                            <video id="camera-video" autoplay playsinline class="w-100 rounded border"></video>

                            <!-- Canvas oculto para captura -->
                            <canvas id="camera-canvas" style="display: none;"></canvas>

                            <!-- Preview da foto capturada -->
                            <img id="captured-image" class="w-100 rounded border" style="display: none;">
                        </div>

                        <div class="alert alert-info mt-3 mb-0">
                            <i class="fa fa-info-circle me-2"></i>
                            <strong>Dica:</strong> Posicione o BI de forma que fique legível e bem iluminado
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="$set('showCameraModal', false)" id="cancel-camera">
                            <i class="fa fa-times me-2"></i>Cancelar
                        </button>
                        <button type="button" class="btn btn-primary" id="capture-button">
                            <i class="fa fa-camera me-2"></i>Capturar Foto
                        </button>
                        <button type="button" class="btn btn-success" id="process-button" style="display: none;">
                            <i class="fa fa-check me-2"></i><span id="process-text">Processar BI</span>
                        </button>
                        <button type="button" class="btn btn-warning" id="retake-button" style="display: none;">
                            <i class="fa fa-redo me-2"></i>Tirar Novamente
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <script>
            (function() {
                // Parar stream anterior se existir
                if (window.currentCameraStream) {
                    window.currentCameraStream.getTracks().forEach(track => track.stop());
                    window.currentCameraStream = null;
                }

                const video = document.getElementById('camera-video');
                const canvas = document.getElementById('camera-canvas');
                const capturedImage = document.getElementById('captured-image');
                const captureButton = document.getElementById('capture-button');
                const processButton = document.getElementById('process-button');
                const retakeButton = document.getElementById('retake-button');
                const cancelButton = document.getElementById('cancel-camera');

                // Iniciar câmera
                async function startCamera() {
                    try {
                        window.currentCameraStream = await navigator.mediaDevices.getUserMedia({
                            video: {
                                facingMode: 'environment',
                                width: { ideal: 1920 },
                                height: { ideal: 1080 }
                            }
                        });
                        video.srcObject = window.currentCameraStream;
                        video.style.display = 'block';
                        capturedImage.style.display = 'none';
                    } catch (error) {
                        alert('Erro ao acessar câmera: ' + error.message);
                        console.error('Erro:', error);
                    }
                }

                // Parar câmera
                function stopCamera() {
                    if (window.currentCameraStream) {
                        window.currentCameraStream.getTracks().forEach(track => track.stop());
                        window.currentCameraStream = null;
                    }
                }

                // Capturar foto
                captureButton.addEventListener('click', function() {
                    console.log('📸 Capturando foto...');

                    const context = canvas.getContext('2d');
                    canvas.width = video.videoWidth;
                    canvas.height = video.videoHeight;
                    context.drawImage(video, 0, 0);

                    // Converter para Blob (mais eficiente que base64)
                    canvas.toBlob(function(blob) {
                        console.log('✅ Foto capturada, tamanho:', Math.round(blob.size / 1024), 'KB');

                        // Mostrar preview
                        const imageUrl = URL.createObjectURL(blob);
                        capturedImage.src = imageUrl;
                        capturedImage.style.display = 'block';
                        video.style.display = 'none';
                        captureButton.style.display = 'none';
                        retakeButton.style.display = 'inline-block';
                        processButton.style.display = 'inline-block';
                        stopCamera();

                        // Armazenar blob para processar depois
                        window.capturedPhotoBlob = blob;
                        console.log('✅ Foto pronta para processar!');
                    }, 'image/jpeg', 0.85);
                });

                // Processar foto capturada
                processButton.addEventListener('click', async function() {
                    if (!window.capturedPhotoBlob) {
                        alert('Nenhuma foto capturada');
                        return;
                    }

                    const processText = document.getElementById('process-text');
                    const originalText = processText.textContent;

                    try {
                        // Desabilitar botão e mostrar loading
                        processButton.disabled = true;
                        processText.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Processando...';

                        // Criar FormData com a foto
                        const formData = new FormData();
                        formData.append('photo', window.capturedPhotoBlob, 'camera_capture.jpg');
                        formData.append('_token', '{{ csrf_token() }}');

                        // Verificar se está capturando verso lendo os atributos de dados do modal
                        const modalContent = document.querySelector('.modal-content');
                        const isBackSide = modalContent.getAttribute('data-capturing-back-side') === '1';
                        const backSideDocId = modalContent.getAttribute('data-back-side-document-id');

                        console.log('🔍 isBackSide:', isBackSide, 'backSideDocId:', backSideDocId);

                        if (isBackSide && backSideDocId) {
                            formData.append('is_back_side', '1');
                            formData.append('document_id', backSideDocId);
                            console.log('📋 Enviando como VERSO do documento:', backSideDocId);
                        }

                        console.log('📤 Enviando foto para servidor...');

                        // Enviar para servidor via fetch
                        const response = await fetch('{{ route("admin.students.document-scanner.camera-upload") }}', {
                            method: 'POST',
                            body: formData,
                            headers: {
                                'X-Requested-With': 'XMLHttpRequest'
                            }
                        });

                        const result = await response.json();

                        if (result.success) {
                            console.log('✅ Foto processada com sucesso!');

                            // Notificar Livewire para atualizar e mostrar preview
                            @this.call('showProcessedDocument', result.document_id);
                        } else {
                            throw new Error(result.error || 'Erro ao processar foto');
                        }

                    } catch (error) {
                        console.error('❌ Erro:', error);
                        alert('Erro ao processar foto: ' + error.message);

                        // Restaurar botão
                        processButton.disabled = false;
                        processText.textContent = originalText;
                    }
                });

                // Tirar novamente
                retakeButton.addEventListener('click', function() {
                    capturedImage.style.display = 'none';
                    video.style.display = 'block';
                    captureButton.style.display = 'inline-block';
                    processButton.style.display = 'none';
                    retakeButton.style.display = 'none';
                    processButton.disabled = false;
                    window.capturedPhotoBlob = null;
                    startCamera();
                });

                // Cancelar
                cancelButton.addEventListener('click', function() {
                    stopCamera();
                });

                // Iniciar câmera quando script executa
                startCamera();
            })();
        </script>
    @endif

    <!-- PDF.js Library -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.min.js"></script>
    <script>
        // Configurar PDF.js worker
        pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.worker.min.js';

        document.addEventListener('DOMContentLoaded', function() {
            const documentInput = document.getElementById('document-input');
            const livewireInput = document.getElementById('livewire-document-input');
            const conversionStatus = document.getElementById('conversion-status');
            const conversionMessage = document.getElementById('conversion-message');

            if (!documentInput || !livewireInput) return;

            documentInput.addEventListener('change', async function(e) {
                const files = Array.from(e.target.files);
                if (files.length === 0) return;

                const convertedFiles = [];
                let hasPdf = false;

                for (let i = 0; i < files.length; i++) {
                    const file = files[i];

                    // Verificar se é PDF
                    if (file.type === 'application/pdf') {
                        hasPdf = true;
                        conversionStatus.style.display = 'block';
                        conversionMessage.textContent = `Convertendo PDF ${i + 1}/${files.length}...`;

                        try {
                            // Converter PDF para imagem
                            const imageFile = await convertPdfToImage(file);
                            convertedFiles.push(imageFile);
                        } catch (error) {
                            console.error('Erro ao converter PDF:', error);
                            alert('Erro ao converter PDF: ' + file.name);
                            conversionStatus.style.display = 'none';
                            return;
                        }
                    } else {
                        // Se for imagem, adicionar diretamente
                        convertedFiles.push(file);
                    }
                }

                // Atualizar input do Livewire com arquivos convertidos
                const dataTransfer = new DataTransfer();
                convertedFiles.forEach(file => dataTransfer.items.add(file));
                livewireInput.files = dataTransfer.files;

                // Disparar evento de mudança no Livewire
                livewireInput.dispatchEvent(new Event('change', { bubbles: true }));

                // Ocultar status de conversão
                if (hasPdf) {
                    conversionMessage.textContent = 'PDFs convertidos com sucesso!';
                    setTimeout(() => {
                        conversionStatus.style.display = 'none';
                    }, 2000);
                }
            });

            async function convertPdfToImage(pdfFile) {
                return new Promise(async (resolve, reject) => {
                    try {
                        // Ler PDF como ArrayBuffer
                        const arrayBuffer = await pdfFile.arrayBuffer();

                        // Carregar PDF
                        const pdf = await pdfjsLib.getDocument({ data: arrayBuffer }).promise;

                        // Pegar primeira página
                        const page = await pdf.getPage(1);

                        // Definir escala para alta resolução (300 DPI equivalente)
                        const scale = 3.0;
                        const viewport = page.getViewport({ scale: scale });

                        // Criar canvas
                        const canvas = document.createElement('canvas');
                        const context = canvas.getContext('2d');
                        canvas.width = viewport.width;
                        canvas.height = viewport.height;

                        // Renderizar PDF no canvas
                        await page.render({
                            canvasContext: context,
                            viewport: viewport
                        }).promise;

                        // Converter canvas para Blob
                        const blob = await new Promise(resolve => {
                            canvas.toBlob(resolve, 'image/jpeg', 0.95);
                        });

                        // Criar File a partir do Blob
                        const fileName = pdfFile.name.replace('.pdf', '.jpg');
                        const imageFile = new File([blob], fileName, { type: 'image/jpeg' });

                        resolve(imageFile);
                    } catch (error) {
                        reject(error);
                    }
                });
            }
        });
    </script>
</div>
