<div class="page-content">
    <div class="main-wrapper">
        <div>
            <!-- Page Header -->
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px;">
                <div>
                    <h2 style="margin: 0; font-size: 26px; color: #333; font-weight: 700;">
                        <i class="fas fa-receipt"></i> Histórico de Pagamentos
                    </h2>
                </div>
                <div>
                    <label for="yearFilterUser" style="display: block; font-size: 12px; margin-bottom: 5px; color: #666; font-weight: 500;">
                        Ano Letivo
                    </label>
                    <select id="yearFilterUser" class="form-select" wire:model="selectedYear" style="min-width: 140px; padding: 8px 12px; border-radius: 8px; border: 1px solid #ddd;">
                        @for ($i = now()->year; $i >= now()->year - 5; $i--)
                            <option value="{{ $i }}">{{ $i }}</option>
                        @endfor
                    </select>
                </div>
            </div>

            <!-- Summary Cards -->
            @php
                // Calcular totais reais das referências de pagamento
                $calculatedTotal = 0;
                $calculatedPaid = 0;
                $calculatedPending = 0;
                $calculatedOverdue = 0;

                if(isset($payment_references)) {
                    foreach($payment_references as $ref) {
                        $amount = $ref->amount ?? 0;
                        $calculatedTotal += $amount;

                        if($ref->status === 'paid') {
                            $calculatedPaid += $amount;
                        } elseif(isset($ref->expires_at) && $ref->expires_at < now() && $ref->status !== 'paid') {
                            $calculatedOverdue += $amount;
                        } elseif($ref->status === 'pending' || $ref->approval_status === 'approved') {
                            $calculatedPending += $amount;
                        }
                    }
                }

                // Usar valores calculados das referências
                $totalExpected = $calculatedTotal > 0 ? $calculatedTotal : ($totalExpected ?? 0);
                $totalPaid = $calculatedPaid > 0 ? $calculatedPaid : ($totalPaid ?? 0);
                $totalPending = $calculatedPending > 0 ? $calculatedPending : ($totalPending ?? 0);
                $totalOverdue = $calculatedOverdue > 0 ? $calculatedOverdue : ($totalOverdue ?? 0);
                $paidPercentage = $totalExpected > 0 ? round(($totalPaid / $totalExpected) * 100, 1) : 0;
            @endphp

            <div class="summary-cards-grid">
                <div class="summary-card summary-card-total">
                    <div class="summary-card-icon">
                        <i class="fas fa-file-invoice-dollar"></i>
                    </div>
                    <div class="summary-card-content">
                        <div class="summary-card-label">Total</div>
                        <div class="summary-card-value">{{ number_format($totalExpected, 2, ',', '.') }}</div>
                        <div class="summary-card-currency">MT</div>
                    </div>
                </div>

                <div class="summary-card summary-card-paid">
                    <div class="summary-card-icon">
                        <i class="fas fa-check-circle"></i>
                    </div>
                    <div class="summary-card-content">
                        <div class="summary-card-label">Total Pago</div>
                        <div class="summary-card-value">{{ number_format($totalPaid, 2, ',', '.') }}</div>
                        <div class="summary-card-currency">MT</div>
                        @if($paidPercentage > 0)
                        <div class="summary-card-badge">{{ $paidPercentage }}%</div>
                        @endif
                    </div>
                </div>

                <div class="summary-card summary-card-pending">
                    <div class="summary-card-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                    <div class="summary-card-content">
                        <div class="summary-card-label">Pendente</div>
                        <div class="summary-card-value">{{ number_format($totalPending, 2, ',', '.') }}</div>
                        <div class="summary-card-currency">MT</div>
                    </div>
                </div>

                <div class="summary-card summary-card-overdue">
                    <div class="summary-card-icon">
                        <i class="fas fa-exclamation-triangle"></i>
                    </div>
                    <div class="summary-card-content">
                        <div class="summary-card-label">Em Atraso</div>
                        <div class="summary-card-value">{{ number_format($totalOverdue, 2, ',', '.') }}</div>
                        <div class="summary-card-currency">MT</div>
                    </div>
                </div>
            </div>

            <!-- Histórico Completo Agrupado -->
            <div class="fee-section" style="margin-bottom: 2rem;">
                <div class="section-header" style="margin-bottom: 1.5rem;">
                    <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 1rem;">
                        <div>
                            <h2 style="margin: 0; font-size: 22px; color: #2c3e50; font-weight: 600;">
                                <i class="fas fa-file-alt"></i>
                                Detalhes de Pagamento
                            </h2>
                            <p style="margin: 5px 0 0 0; color: #6c757d; font-size: 14px;">
                                Todas as suas referências e pagamentos - Total: {{ isset($payment_references) ? $payment_references->count() : 0 }} registro(s)
                            </p>
                        </div>
                        <!-- Botão Baixar Relatório -->
                        <button class="btn" wire:click="exportPdf" title="Baixar Histórico Completo em PDF"
                                style="background: #34495e; color: white; padding: 0.75rem 1.5rem; font-weight: 600; font-size: 1rem; border-radius: 8px; border: none; display: flex; align-items: center; gap: 0.6rem; box-shadow: 0 2px 8px rgba(52, 73, 94, 0.3);">
                            <i class="fas fa-file-pdf" style="font-size: 1.1rem;"></i>
                            <span>Baixar Relatório</span>
                        </button>
                    </div>

                    <!-- Filtros de Status - Linha Separada -->
                    <div style="margin-top: 1rem;">
                        <div class="fee-filters" style="display: flex; gap: 0.5rem; flex-wrap: wrap;">
                            <button class="filter-btn active" data-filter-ref="all">Todos</button>
                            <button class="filter-btn" data-filter-ref="paid">Pagos</button>
                            <button class="filter-btn" data-filter-ref="approved">Aprovados</button>
                            <button class="filter-btn" data-filter-ref="pending">Pendentes</button>
                            <button class="filter-btn" data-filter-ref="expired">Expirados</button>
                        </div>
                    </div>
                </div>

                @if(isset($payment_references) && $payment_references->count() > 0)
                <x-payment-references-grouped
                    :references="$payment_references"
                    :showActions="true"
                    :showCheckboxes="false"
                    mode="detailed"
                />
                @else
                <div class="alert alert-info" style="text-align: center; padding: 2rem;">
                    <i class="fas fa-info-circle" style="font-size: 48px; color: #17a2b8; margin-bottom: 1rem;"></i>
                    <h4>Nenhum registro encontrado</h4>
                    <p>Não há pagamentos ou referências para o ano de {{ $currentYear }}.</p>
                </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Modal: Ver Detalhes da Referência -->
    @if($showReferenceModal && $selectedReference)
    <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5); overflow-y: auto;">
        <div class="modal-dialog modal-lg" style="margin: 1.75rem auto;">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">
                        <i class="fas fa-file-invoice me-2"></i>Detalhes da Referência de Pagamento
                    </h5>
                    <button type="button" class="btn-close btn-close-white" wire:click="closeReferenceModal"></button>
                </div>
                <div class="modal-body">
                    <!-- Informações do Estudante -->
                    <div class="card mb-3">
                        <div class="card-header bg-light">
                            <h6 class="mb-0"><i class="fas fa-user me-2"></i>Dados do Estudante</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <p class="mb-2"><strong>Nome:</strong> {{ $selectedReference['student_name'] }}</p>
                                    <p class="mb-0"><strong>ID:</strong> {{ $selectedReference['student_id'] }}</p>
                                </div>
                                <div class="col-md-6">
                                    <p class="mb-0"><strong>Classe:</strong> {{ $selectedReference['classroom'] }}</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Detalhes da Referência -->
                    <div class="card mb-3">
                        <div class="card-header bg-light">
                            <h6 class="mb-0"><i class="fas fa-receipt me-2"></i>Detalhes da Referência</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label text-muted small mb-1">Número da Referência</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control form-control-lg fw-bold"
                                                   value="{{ $selectedReference['reference_number'] }}" readonly>
                                            <button class="btn btn-outline-secondary" type="button"
                                                    onclick="navigator.clipboard.writeText('{{ $selectedReference['reference_number'] }}')">
                                                <i class="fas fa-copy"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label text-muted small mb-1">Entidade</label>
                                        <input type="text" class="form-control" value="{{ $selectedReference['entity_code'] }}" readonly>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label text-muted small mb-1">Descrição</label>
                                        <input type="text" class="form-control" value="{{ $selectedReference['description'] }}" readonly>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label text-muted small mb-1">Valor</label>
                                        <input type="text" class="form-control text-success fw-bold"
                                               value="MT {{ number_format($selectedReference['amount'], 2, ',', '.') }}" readonly>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label text-muted small mb-1">Mês/Ano</label>
                                        <input type="text" class="form-control"
                                               value="{{ $selectedReference['fee_month'] }}/{{ $selectedReference['fee_year'] }}" readonly>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label text-muted small mb-1">Status</label>
                                        <div>
                                            @php
                                                $statusBadge = match($selectedReference['status']) {
                                                    'paid' => '<span class="badge bg-success">Pago</span>',
                                                    'pending' => '<span class="badge bg-warning text-dark">Pendente</span>',
                                                    'expired' => '<span class="badge bg-danger">Expirado</span>',
                                                    'cancelled' => '<span class="badge bg-secondary">Cancelado</span>',
                                                    default => '<span class="badge bg-light text-dark">Desconhecido</span>'
                                                };
                                            @endphp
                                            {!! $statusBadge !!}
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label text-muted small mb-1">Data de Expiração</label>
                                        <input type="text" class="form-control"
                                               value="{{ $selectedReference['expires_at'] ?? 'N/A' }}" readonly>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label text-muted small mb-1">Data de Geração</label>
                                        <input type="text" class="form-control"
                                               value="{{ $selectedReference['created_at'] }}" readonly>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Alerta de Referência Expirada -->
                    @php
                        $isExpired = false;
                        if ($selectedReference['expires_at'] !== 'N/A' && $selectedReference['status'] === 'pending') {
                            try {
                                $expiryDate = \Carbon\Carbon::createFromFormat('d/m/Y H:i', $selectedReference['expires_at']);
                                $isExpired = $expiryDate->isPast();
                            } catch (\Exception $e) {
                                $isExpired = false;
                            }
                        }
                    @endphp

                    @if($isExpired)
                    <div class="alert alert-danger">
                        <h6 class="alert-heading"><i class="fas fa-exclamation-triangle me-2"></i>Referência Expirada</h6>
                        <p class="mb-3">Esta referência expirou em {{ $selectedReference['expires_at'] }}. Gere uma nova referência com o valor atualizado (incluindo multa).</p>
                        <button
                            type="button"
                            class="btn btn-warning"
                            wire:click="closeReferenceModal"
                            onclick="openPaymentModal('{{ $selectedReference['fee_month'] }}', {{ $selectedReference['fee_year'] }}, 0, 0, 0)">
                            <i class="fas fa-redo me-1"></i>Gerar Nova Referência
                        </button>
                    </div>
                    @endif

                    <!-- Instruções de Pagamento -->
                    @if($selectedReference['status'] !== 'paid' && $selectedReference['reference_number'] !== 'N/A' && !$isExpired)
                    <div class="alert alert-info mb-0">
                        <h6 class="alert-heading"><i class="fas fa-info-circle me-2"></i>Como Pagar</h6>
                        <p class="mb-2 small">Para pagar esta referência, utilize os seguintes dados em qualquer caixa ATM:</p>
                        <ul class="mb-0 small">
                            <li><strong>Entidade:</strong> {{ $selectedReference['entity_code'] }}</li>
                            <li><strong>Referência:</strong> {{ $selectedReference['reference_number'] }}</li>
                            <li><strong>Valor:</strong> MT {{ number_format($selectedReference['amount'], 2, ',', '.') }}</li>
                        </ul>
                    </div>
                    @endif
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeReferenceModal">
                        <i class="fas fa-times me-2"></i>Fechar
                    </button>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Payment Modal -->
    <div class="modal fade" id="collectFeeModal" tabindex="-1" role="dialog" aria-labelledby="collectFeeModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <form id="paymentForm" onsubmit="submitPayment(event)">
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title" id="collectFeeModalLabel">
                            <i class="fas fa-credit-card me-2"></i>Efetuar Pagamento
                        </h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Fechar"></button>
                    </div>

                    <div class="modal-body">
                        <!-- Fee Details Display -->
                        <div class="fee-details-card mb-4">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h6 class="card-title text-primary">
                                        <i class="fas fa-info-circle me-2"></i>Detalhes da Taxa
                                    </h6>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p><strong>Período:</strong> <span id="modalPeriod">-</span></p>
                                            <p><strong>Taxa:</strong> <span id="modalFeeName">-</span></p>
                                        </div>
                                        <div class="col-md-6">
                                            <p><strong>Valor Base:</strong> <span id="modalBaseAmount">0,00 MT</span></p>
                                            <p><strong>Multa Calculada:</strong> <span id="modalCalculatedFine" class="text-danger">0,00 MT</span></p>
                                        </div>
                                    </div>
                                    <hr>
                                    <p class="mb-0"><strong>Total a Pagar:</strong> <span id="modalTotalAmount" class="text-success fs-5">0,00 MT</span></p>
                                </div>
                            </div>
                        </div>

                        <!-- Payment Form -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="amount" class="form-label">
                                        <i class="fas fa-money-bill-wave me-1"></i>Montante a Pagar *
                                    </label>
                                    <div class="input-group">
                                        <input type="number"
                                               class="form-control"
                                               id="amount"
                                               name="amount"
                                               step="0.01"
                                               min="0"
                                               readonly
                                               required>
                                        <span class="input-group-text">MT</span>
                                    </div>
                                    <small class="text-muted">Valor fixo (base + multa aplicável)</small>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="fine" class="form-label">
                                        <i class="fas fa-exclamation-triangle me-1"></i>Multa por Atraso
                                    </label>
                                    <div class="input-group">
                                        <input type="number"
                                               class="form-control"
                                               id="fine"
                                               name="fine"
                                               step="0.01"
                                               min="0"
                                               readonly>
                                        <span class="input-group-text">MT</span>
                                    </div>
                                    <small class="text-muted">Multa calculada automaticamente</small>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="paymentMode" class="form-label">
                                        <i class="fas fa-credit-card me-1"></i>Modo de Pagamento *
                                    </label>
                                    <select class="form-control" id="paymentMode" name="paymentMode" required>
                                        <option value="Reference">Entidade e Referencia</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="note" class="form-label">
                                        <i class="fas fa-sticky-note me-1"></i>Observações
                                    </label>
                                    <textarea class="form-control"
                                              id="note"
                                              name="note"
                                              rows="3"
                                              placeholder="Observações (opcional)"></textarea>
                                </div>
                            </div>
                        </div>

                        <!-- Hidden fields -->
                        <input type="hidden" id="hiddenMonth" name="month">
                        <input type="hidden" id="hiddenYear" name="year">
                        <input type="hidden" id="hiddenDiscount" name="discount" value="0">
                        <input type="hidden" id="hiddenBaseAmount" name="baseAmount" value="0">

                        <!-- Payment Summary -->
                        <div class="payment-summary mt-3">
                            <div class="card border-success">
                                <div class="card-body bg-light">
                                    <h6 class="text-success mb-3">
                                        <i class="fas fa-calculator me-2"></i>Resumo do Pagamento
                                    </h6>
                                    <div class="row text-center">
                                        <div class="col-4">
                                            <div class="border-end">
                                                <div class="text-muted small">Valor Base</div>
                                                <div class="fw-bold" id="summaryBase">0,00 MT</div>
                                            </div>
                                        </div>
                                        <div class="col-4">
                                            <div class="border-end">
                                                <div class="text-muted small">Multa</div>
                                                <div class="fw-bold text-warning" id="summaryFine">0,00 MT</div>
                                            </div>
                                        </div>
                                        <div class="col-4">
                                            <div class="text-muted small">Total a Pagar</div>
                                            <div class="fw-bold text-success fs-5" id="summaryTotal">0,00 MT</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="fas fa-times me-1"></i>Cancelar
                        </button>
                        <button type="submit" class="btn btn-success" id="submitPaymentBtn">
                            <i class="fas fa-check me-1"></i><span id="submitBtnText">Confirmar Pagamento</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
.page-content {
    padding: 1.5rem;
    background-color: #f8f9fa;
    min-height: 100vh;
}

.main-wrapper {
    max-width: 1400px;
    margin: 0 auto;
    background: white;
    border-radius: 12px;
    padding: 2rem;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

/* Summary Cards */
.summary-cards-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.5rem;
    margin-bottom: 3rem;
    padding-bottom: 2rem;
    border-bottom: 2px solid #f0f0f0;
}

.summary-card {
    background: white;
    border-radius: 12px;
    padding: 1.5rem;
    display: flex;
    align-items: center;
    gap: 1rem;
    box-shadow: 0 2px 12px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.summary-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 4px;
    height: 100%;
    transition: width 0.3s ease;
}

.summary-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 4px 20px rgba(0,0,0,0.12);
}

.summary-card:hover::before {
    width: 8px;
}

.summary-card-icon {
    width: 60px;
    height: 60px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
    flex-shrink: 0;
}

.summary-card-content {
    flex: 1;
    position: relative;
}

.summary-card-label {
    font-size: 13px;
    font-weight: 500;
    color: #6c757d;
    margin-bottom: 4px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.summary-card-value {
    font-size: 28px;
    font-weight: 700;
    line-height: 1;
    margin-bottom: 2px;
}

.summary-card-currency {
    font-size: 12px;
    font-weight: 600;
    color: #6c757d;
    letter-spacing: 1px;
}

.summary-card-badge {
    position: absolute;
    top: 0;
    right: 0;
    font-size: 11px;
    font-weight: 700;
    padding: 4px 10px;
    border-radius: 12px;
    letter-spacing: 0.5px;
}

/* Card Types */
.summary-card-total::before {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.summary-card-total .summary-card-icon {
    background: linear-gradient(135deg, #667eea15 0%, #764ba215 100%);
    color: #667eea;
}

.summary-card-total .summary-card-value {
    color: #667eea;
}

.summary-card-paid::before {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
}

.summary-card-paid .summary-card-icon {
    background: linear-gradient(135deg, #10b98115 0%, #05966915 100%);
    color: #10b981;
}

.summary-card-paid .summary-card-value {
    color: #10b981;
}

.summary-card-paid .summary-card-badge {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: white;
}

.summary-card-pending::before {
    background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
}

.summary-card-pending .summary-card-icon {
    background: linear-gradient(135deg, #f59e0b15 0%, #d9770615 100%);
    color: #f59e0b;
}

.summary-card-pending .summary-card-value {
    color: #f59e0b;
}

.summary-card-overdue::before {
    background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
}

.summary-card-overdue .summary-card-icon {
    background: linear-gradient(135deg, #ef444415 0%, #dc262615 100%);
    color: #ef4444;
}

.summary-card-overdue .summary-card-value {
    color: #ef4444;
}

@media (max-width: 768px) {
    .summary-cards-grid {
        grid-template-columns: 1fr;
    }

    .summary-card-value {
        font-size: 24px;
    }

    .section-header > div {
        flex-direction: column !important;
        align-items: flex-start !important;
    }

    .section-header .btn {
        width: 100%;
        justify-content: center;
        margin-top: 0.75rem;
    }

    .fee-filters {
        width: 100%;
        justify-content: flex-start;
    }
}

.fee-filters {
    display: flex;
    gap: 0.5rem;
    flex-wrap: wrap;
}

.filter-btn {
    padding: 6px 16px;
    border: 1px solid #dee2e6;
    background: white;
    border-radius: 6px;
    cursor: pointer;
    font-size: 13px;
    font-weight: 500;
    color: #495057;
    transition: all 0.2s;
}

.filter-btn:hover {
    background: #f8f9fa;
    border-color: #667eea;
    color: #667eea;
}

.filter-btn.active {
    background: #667eea;
    color: white;
    border-color: #667eea;
}

/* Modal Scrolling */
.modal.show.d-block {
    display: flex !important;
    align-items: center;
    padding: 1rem;
}

.modal-body {
    max-height: calc(100vh - 200px);
    overflow-y: auto;
}

@media print {
    .fee-filters, .btn-group, .page-header select {
        display: none !important;
    }

    .main-wrapper {
        box-shadow: none;
        padding: 0;
    }

    .page-content {
        padding: 0;
    }
}
</style>

<script>
// Filtro de status
document.addEventListener('DOMContentLoaded', function() {
    const filterButtons = document.querySelectorAll('.filter-btn[data-filter-ref]');

    filterButtons.forEach(btn => {
        btn.addEventListener('click', function() {
            const filter = this.dataset.filterRef;

            // Update active button
            filterButtons.forEach(b => b.classList.remove('active'));
            this.classList.add('active');

            // Filter rows
            const rows = document.querySelectorAll('[data-status]');
            rows.forEach(row => {
                if (filter === 'all') {
                    row.style.display = '';
                } else {
                    row.style.display = row.dataset.status === filter ? '' : 'none';
                }
            });
        });
    });
});

// Escutar eventos Livewire de download
document.addEventListener('livewire:load', function () {
    Livewire.on('download-receipt', (data) => {
        const url = data.url;
        const message = data.message;

        // Criar link temporário para download
        const link = document.createElement('a');
        link.href = url;
        link.download = '';
        link.target = '_blank';
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);

        // Mostrar mensagem de sucesso
        if (message) {
            console.log(message);
        }
    });

    // Escutar eventos Livewire de erro
    Livewire.on('error', (data) => {
        const message = data.message;
        if (message) {
            alert('Erro: ' + message);
        }
    });

    // Escutar evento para fechar o modal após gerar referência
    Livewire.on('referenceGenerated', (data) => {
        // Fechar modal
        const modal = bootstrap.Modal.getInstance(document.getElementById('collectFeeModal'));
        if (modal) {
            modal.hide();
        }

        // Reabilitar botão
        const submitBtn = document.getElementById('submitPaymentBtn');
        const submitBtnText = document.getElementById('submitBtnText');
        if (submitBtn) {
            submitBtn.disabled = false;
        }
        if (submitBtnText) {
            submitBtnText.textContent = 'Confirmar Pagamento';
        }

        // Mostrar mensagem de sucesso
        if (data.message) {
            alert(data.message);
        }
    });

    // Escutar erro ao gerar referência
    Livewire.on('referenceError', (message) => {
        alert('Erro: ' + message);

        // Reabilitar botão
        const submitBtn = document.getElementById('submitPaymentBtn');
        const submitBtnText = document.getElementById('submitBtnText');
        if (submitBtn) {
            submitBtn.disabled = false;
        }
        if (submitBtnText) {
            submitBtnText.textContent = 'Confirmar Pagamento';
        }
    });
});

// Função para abrir modal de pagamento
window.openPaymentModal = function(month, year, baseAmount, fineAmount, discountAmount, feeStructureId = null) {
    // Preencher os campos do modal
    document.getElementById('modalPeriod').textContent = `${month}/${year}`;
    document.getElementById('modalFeeName').textContent = 'Mensalidade';
    document.getElementById('modalBaseAmount').textContent = formatCurrency(baseAmount);
    document.getElementById('modalCalculatedFine').textContent = formatCurrency(fineAmount);
    document.getElementById('modalTotalAmount').textContent = formatCurrency(baseAmount + fineAmount - discountAmount);

    // Update summary at bottom
    document.getElementById('summaryBase').textContent = formatCurrency(baseAmount);
    document.getElementById('summaryFine').textContent = formatCurrency(fineAmount);
    document.getElementById('summaryTotal').textContent = formatCurrency(baseAmount + fineAmount - discountAmount);

    document.getElementById('amount').value = (baseAmount + fineAmount - discountAmount).toFixed(2);
    document.getElementById('fine').value = fineAmount.toFixed(2);
    document.getElementById('hiddenMonth').value = month;
    document.getElementById('hiddenYear').value = year;
    document.getElementById('hiddenDiscount').value = discountAmount;
    document.getElementById('hiddenBaseAmount').value = baseAmount;

    // Guardar fee_structure_id se disponível
    let hiddenFeeStructureId = document.getElementById('hiddenFeeStructureId');
    if (!hiddenFeeStructureId) {
        hiddenFeeStructureId = document.createElement('input');
        hiddenFeeStructureId.type = 'hidden';
        hiddenFeeStructureId.id = 'hiddenFeeStructureId';
        document.getElementById('paymentForm').appendChild(hiddenFeeStructureId);
    }
    hiddenFeeStructureId.value = feeStructureId || '';

    // Abrir modal
    const modal = new bootstrap.Modal(document.getElementById('collectFeeModal'));
    modal.show();
};

// Função para formatar moeda
function formatCurrency(value) {
    return parseFloat(value || 0).toLocaleString('pt-MZ', {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
    }) + ' MT';
}

// Função para submeter pagamento/gerar referência
function submitPayment(event) {
    event.preventDefault();

    const feeStructureIdEl = document.getElementById('hiddenFeeStructureId');
    const feeStructureId = feeStructureIdEl && feeStructureIdEl.value ? parseInt(feeStructureIdEl.value) : null;

    const formData = {
        month: document.getElementById('hiddenMonth').value,
        year: parseInt(document.getElementById('hiddenYear').value),
        amount: parseFloat(document.getElementById('amount').value),
        fine: parseFloat(document.getElementById('fine').value),
        paymentMode: document.getElementById('paymentMode').value,
        note: document.getElementById('note').value,
        discount: parseFloat(document.getElementById('hiddenDiscount').value || 0),
        baseAmount: parseFloat(document.getElementById('hiddenBaseAmount').value),
        fee_structure_id: feeStructureId
    };

    if (!formData.paymentMode) {
        alert('Por favor, selecione um modo de pagamento');
        return;
    }

    // Desabilitar botão
    const submitBtn = document.getElementById('submitPaymentBtn');
    const submitBtnText = document.getElementById('submitBtnText');
    submitBtn.disabled = true;
    submitBtnText.textContent = 'Processando...';

    // Chamar Livewire para gerar referência
    Livewire.emit('generateReference', formData);

    // Fechar modal após 2 segundos
    setTimeout(() => {
        const modal = bootstrap.Modal.getInstance(document.getElementById('collectFeeModal'));
        if (modal) modal.hide();
        submitBtn.disabled = false;
        submitBtnText.textContent = 'Processar Pagamento';
        document.getElementById('paymentForm').reset();
    }, 2000);
}
</script>
