<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Ficha de Inscrição - {{ $pre->code }}</title>
    <style>
        @page {
            size: A4 portrait;
            margin: 4mm 25mm 10mm 25mm;
        }

        * {
            box-sizing: border-box;
        }

        body {
            font-family: 'Times New Roman', Times, serif;
            color: #000;
            font-size: 11pt;
            line-height: 1.3;
            margin: 0;
            padding: 0;
        }

        /* Rodapé fixo em todas as páginas */
        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 7pt;
            color: #999;
            font-style: italic;
            border-top: 1px solid #ddd;
            padding-top: 4px;
        }

        /* Header */
        .header {
            text-align: center;
            margin-bottom: 2px;
            padding-bottom: 8px;
            border-bottom: 2px solid #1a5276;
        }

        .header img {
            max-height: 90px;
            margin-bottom: 4px;
        }

        .school-name {
            font-size: 14pt;
            font-weight: bold;
            color: #1a5276;
            text-transform: uppercase;
            margin-bottom: 2px;
        }

        .school-subtitle {
            font-size: 9pt;
            color: #555;
            font-style: italic;
        }

        /* Title */
        .ficha-title {
            text-align: center;
            font-size: 12pt;
            font-weight: bold;
            color: #1a5276;
            margin: 10px 0 8px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .ficha-info {
            text-align: center;
            font-size: 10pt;
            margin-bottom: 10px;
        }

        .ficha-info span {
            margin: 0 8px;
        }

        /* Section */
        .section-title {
            background: #1a5276;
            color: white;
            padding: 3px 8px;
            font-size: 9pt;
            font-weight: bold;
            text-transform: uppercase;
            margin: 8px 0 4px;
        }

        /* Data table */
        .data-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 4px;
        }

        .data-table td {
            border: 1px solid #999;
            padding: 3px 6px;
            font-size: 9pt;
            vertical-align: top;
        }

        .data-table .label {
            background: #f0f4f8;
            font-weight: bold;
            color: #333;
            width: 22%;
            font-size: 8pt;
            text-transform: uppercase;
        }

        .data-table .value {
            color: #000;
        }

        /* Checkbox */
        .checkbox {
            display: inline-block;
            width: 11px;
            height: 11px;
            border: 1.5px solid #333;
            text-align: center;
            line-height: 11px;
            font-size: 8pt;
            margin-right: 3px;
        }

        .checkbox.checked {
            background: #1a5276;
            color: white;
        }

        /* Signature */
        .signature-section {
            margin-top: 25px;
            text-align: right;
        }

        .signature-line {
            border-top: 1px solid #000;
            width: 250px;
            display: inline-block;
            text-align: center;
            padding-top: 4px;
            font-size: 8pt;
        }

        /* Page break */
        .page-break {
            page-break-before: always;
        }

        .reserved-box {
            border: 2px solid #1a5276;
            padding: 6px;
            margin-top: 8px;
        }

        .reserved-title {
            font-size: 8pt;
            font-weight: bold;
            color: #1a5276;
            text-transform: uppercase;
            margin-bottom: 4px;
        }
    </style>
</head>
<body>
    @php
        $logoPath = public_path('assets/images/logo.png');
        if (!file_exists($logoPath)) {
            $logoPath = public_path('images/certificates/copmoz_logo.png');
        }
        $logoData = file_exists($logoPath) ? base64_encode(file_get_contents($logoPath)) : '';
    @endphp

    {{-- Rodapé fixo em todas as páginas --}}
    <div class="footer">Documento gerado por computador. SIGA - COPMOZ</div>

    {{-- ============================================ --}}
    {{-- PÁGINA 1: FICHA DE INSCRIÇÃO --}}
    {{-- ============================================ --}}
    <div style="width: 100%;">
        <div class="header">
            @if($logoData)
            <img src="data:image/png;base64,{{ $logoData }}" alt="COPMOZ">
            <br>
            @endif
            <div class="school-name">Colégio Politécnico de Moçambique</div>
            <div class="school-subtitle">Educação de Qualidade para um Futuro Melhor</div>
        </div>

        <div class="ficha-title">Ficha de Inscrição</div>
        <div class="ficha-info">
            <span><strong>Nº:</strong> {{ $pre->code }}</span>
            <span><strong>Data:</strong> {{ $pre->submitted_at ? $pre->submitted_at->format('d/m/Y') : now()->format('d/m/Y') }}</span>
            @if($pre->resultingStudent)
            <span><strong>Cód. Estudante:</strong> {{ $pre->resultingStudent->student_id }}</span>
            @endif
        </div>

        {{-- 1. DADOS PESSOAIS --}}
        <div class="section-title">1. Dados Pessoais</div>
        <table class="data-table">
            <tr>
                <td class="label">Nome Completo</td>
                <td class="value" colspan="5">{{ $pre->candidate_name }}</td>
            </tr>
            <tr>
                <td class="label">Género</td>
                <td class="value">{{ $pre->candidate_sex }}</td>
                <td class="label">Estado Civil</td>
                <td class="value">{{ $pre->marital_status ?? '-' }}</td>
                <td class="label">Data Nasc.</td>
                <td class="value">{{ $pre->candidate_dob ? $pre->candidate_dob->format('d/m/Y') : '-' }}</td>
            </tr>
            <tr>
                <td class="label">Naturalidade</td>
                <td class="value">{{ $pre->birth_place ?? '-' }}</td>
                <td class="label">Distrito</td>
                <td class="value">{{ $pre->birth_district ?? '-' }}</td>
                <td class="label">Província</td>
                <td class="value">{{ $pre->birth_province ?? '-' }}</td>
            </tr>
        </table>

        {{-- 2. DOCUMENTOS --}}
        <div class="section-title">2. Documentos de Identificação</div>
        <table class="data-table">
            <tr>
                <td class="label">Tipo Doc.</td>
                <td class="value">{{ $pre->document_type ?? '-' }}</td>
                <td class="label">Nº Documento</td>
                <td class="value">{{ $pre->document_id ?? '-' }}</td>
            </tr>
            <tr>
                <td class="label">Local Emissão</td>
                <td class="value">{{ $pre->document_issue_place ?? '-' }}</td>
                <td class="label">Validade</td>
                <td class="value">{{ $pre->document_expiry_date ? $pre->document_expiry_date->format('d/m/Y') : '-' }}</td>
            </tr>
            <tr>
                <td class="label">Nacionalidade</td>
                <td class="value">{{ $pre->nationality ?? 'Moçambicana' }}</td>
                <td class="label">NUIT</td>
                <td class="value">{{ $pre->nuit ?? '-' }}</td>
            </tr>
        </table>
        <table class="data-table">
            <tr>
                <td class="label" style="width: 22%;">Doença Crónica</td>
                <td class="value" style="width: 78%;">
                    <span class="checkbox {{ $pre->chronic_disease ? 'checked' : '' }}">{{ $pre->chronic_disease ? 'X' : '' }}</span> Sim
                    &nbsp;&nbsp;
                    <span class="checkbox {{ !$pre->chronic_disease ? 'checked' : '' }}">{{ !$pre->chronic_disease ? 'X' : '' }}</span> Não
                    @if($pre->chronic_disease && $pre->chronic_disease_details)
                        &nbsp;&nbsp; <strong>Qual:</strong> {{ $pre->chronic_disease_details }}
                    @endif
                </td>
            </tr>
        </table>

        {{-- 3. MORADA --}}
        <div class="section-title">3. Morada (Residência)</div>
        <table class="data-table">
            <tr>
                <td class="label">Província</td>
                <td class="value">{{ $pre->address_province ?? '-' }}</td>
                <td class="label">Distrito</td>
                <td class="value">{{ $pre->address_district ?? '-' }}</td>
            </tr>
            <tr>
                <td class="label">Bairro</td>
                <td class="value">{{ $pre->address_bairro ?? '-' }}</td>
                <td class="label">Rua / Nº Casa</td>
                <td class="value">{{ $pre->address_street ?? '-' }}{{ $pre->address_house_number ? ', Nº ' . $pre->address_house_number : '' }}</td>
            </tr>
            <tr>
                <td class="label">Celular</td>
                <td class="value">{{ $pre->candidate_phone }}</td>
                <td class="label">WhatsApp</td>
                <td class="value">{{ $pre->candidate_whatsapp ?? '-' }}</td>
            </tr>
            <tr>
                <td class="label">Email</td>
                <td class="value" colspan="3">{{ $pre->candidate_email ?? '-' }}</td>
            </tr>
        </table>

        {{-- 4. FILIAÇÃO --}}
        <div class="section-title">4. Filiação</div>
        <table class="data-table">
            <tr>
                <td class="label">Nome do Pai</td>
                <td class="value">{{ $pre->father_name ?? '-' }}</td>
                <td class="label">Celular</td>
                <td class="value">{{ $pre->father_phone ?? '-' }}</td>
            </tr>
            <tr>
                <td class="label">Nome da Mãe</td>
                <td class="value">{{ $pre->mother_name ?? '-' }}</td>
                <td class="label">Celular</td>
                <td class="value">{{ $pre->mother_phone ?? '-' }}</td>
            </tr>
        </table>

        {{-- 5. ENCARREGADO --}}
        <div class="section-title">5. Encarregado de Educação</div>
        <table class="data-table">
            <tr>
                <td class="label">Nome</td>
                <td class="value">{{ $pre->guardian_name ?? '-' }}</td>
                <td class="label">Parentesco</td>
                <td class="value">{{ $pre->guardian_relationship ?? '-' }}</td>
            </tr>
            <tr>
                <td class="label">Celular</td>
                <td class="value">{{ $pre->guardian_phone ?? '-' }}</td>
                <td class="label">Email</td>
                <td class="value">{{ $pre->guardian_email ?? '-' }}</td>
            </tr>
        </table>

        {{-- 6. CONTACTO EMERGÊNCIA --}}
        <div class="section-title">6. Contacto de Emergência</div>
        <table class="data-table">
            <tr>
                <td class="label">Nome</td>
                <td class="value">{{ $pre->emergency_contact_name ?? '-' }}</td>
                <td class="label">Celular</td>
                <td class="value">{{ $pre->emergency_contact_phone ?? '-' }}</td>
            </tr>
        </table>

        {{-- 7. VIA DE INGRESSO --}}
        <div class="section-title">7. Via de Ingresso</div>
        <table class="data-table">
            <tr>
                <td class="label" style="width: 22%;">Tipo</td>
                <td class="value" style="width: 78%;">
                    <span class="checkbox {{ $pre->entry_type === 'Normal' ? 'checked' : '' }}">{{ $pre->entry_type === 'Normal' ? 'X' : '' }}</span> Normal
                    &nbsp;&nbsp;
                    <span class="checkbox {{ $pre->entry_type === 'Transferencia' ? 'checked' : '' }}">{{ $pre->entry_type === 'Transferencia' ? 'X' : '' }}</span> Transferência
                    &nbsp;&nbsp;
                    <span class="checkbox {{ $pre->entry_type === 'Reingresso' ? 'checked' : '' }}">{{ $pre->entry_type === 'Reingresso' ? 'X' : '' }}</span> Reingresso
                </td>
            </tr>
            @if($pre->entry_type !== 'Normal')
            <tr>
                <td class="label">Instituição Origem</td>
                <td class="value">{{ $pre->previous_institution ?? '-' }}</td>
            </tr>
            <tr>
                <td class="label">Curso Anterior</td>
                <td class="value">{{ $pre->previous_course ?? '-' }}</td>
            </tr>
            @endif
        </table>

        {{-- RESERVADO COPMOZ --}}
        <div class="reserved-box">
            <div class="reserved-title">Reservado ao COPMOZ</div>
            <table class="data-table" style="margin: 0;">
                <tr>
                    <td class="label">Classe</td>
                    <td class="value">{{ $pre->desired_class ? $pre->desired_class . 'ª Classe' : '-' }}</td>
                    <td class="label">Turma</td>
                    <td class="value">{{ $pre->desiredClassroom->name ?? '-' }}</td>
                    <td class="label">Turno</td>
                    <td class="value">{{ $pre->desired_shift ?? '-' }}</td>
                </tr>
                <tr>
                    <td class="label">Ano Lectivo</td>
                    <td class="value">{{ $pre->academic_year }}</td>
                    <td class="label">Cód. Estudante</td>
                    <td class="value" colspan="3">{{ $pre->resultingStudent->student_id ?? '-' }}</td>
                </tr>
            </table>
        </div>

        {{-- OBSERVAÇÃO --}}
        @if($pre->observation)
        <table class="data-table" style="margin-top: 6px;">
            <tr>
                <td class="label" style="width: 15%;">Observação</td>
                <td class="value">{{ $pre->observation }}</td>
            </tr>
        </table>
        @endif

        {{-- ASSINATURA --}}
        <div class="signature-section">
            <div style="display: inline-block; text-align: center;">
                <div style="margin-bottom: 4px; font-size: 9pt;">Nampula, ____/____/________</div>
                <br><br>
                <div class="signature-line">O(A) Director(a) Administrativo-Pedagógico</div>
            </div>
        </div>
    </div>

    {{-- ============================================ --}}
    {{-- PÁGINA 2: TERMO DE COMPROMISSO (APAS) --}}
    {{-- ============================================ --}}
    <div class="page-break"></div>

    <div style="width: 100%; font-family: 'Times New Roman', Times, serif; font-size: 12pt; color: #000; line-height: 2.0;">

        {{-- Cabeçalho com logo --}}
        <div style="text-align: center; margin-bottom: 35px;">
            @if($logoData)
            <img src="data:image/png;base64,{{ $logoData }}" alt="COPMOZ" style="max-height: 60px; margin-bottom: 5px;">
            <br>
            @endif
            <div style="font-size: 14pt; font-weight: bold; text-transform: uppercase;">Colégio Politécnico de Moçambique</div>
            <div style="font-size: 10pt; font-style: italic; color: #333;">Educação de Qualidade para um Futuro Melhor</div>
        </div>

        {{-- Título --}}
        <div style="text-align: center; margin-bottom: 35px;">
            <span style="font-size: 14pt; font-weight: bold; text-decoration: underline;">Termo De Compromisso</span>
        </div>

        {{-- Corpo do texto --}}
        <p style="text-align: justify; text-indent: 1.27cm; margin: 0 0 20px 0;">
            Eu <strong>{{ $pre->guardian_name ?? '___________________________________' }}</strong>
            portador de B.I. nº: <strong>{{ $pre->guardian_document_id ?? '________________' }}</strong>,
            Emitido pelo arquivo de identificação Civil de <strong>{{ $pre->guardian_document_issue_place ?? '_____________' }}</strong>,
            aos <strong>{{ $pre->guardian_document_issue_date ? $pre->guardian_document_issue_date->format('d') : '____' }}</strong>
            de <strong>{{ $pre->guardian_document_issue_date ? $pre->guardian_document_issue_date->format('m/Y') : '____________' }}</strong>,
            residente no bairro de <strong>{{ $pre->guardian_bairro ?? '______________________________' }}</strong>
            Q. nº: <strong>{{ $pre->guardian_quarteirao ?? '_____' }}</strong>,
            trabalhador de <strong>{{ $pre->guardian_workplace ?? '_______________________________________________' }}</strong>,
            Tel/Cel. nº: +258 <strong>{{ $pre->guardian_phone ?? '______________' }}</strong>,
            encarregado de educação do aluno(a)
            <strong>{{ $pre->candidate_name ?? '_______________________________________________' }}</strong>,
            matriculado(a) na classe <strong>{{ $pre->desired_class ? $pre->desired_class . 'ª Classe' : '________________________________________' }}</strong>,
            comprometo-me a despender as minhas energias, com vista ao integral acompanhamento do processo educativo
            do(a) educando(a) e aceitar que seja sujeito a sanções a serem impostas caso ele(a) não
            cumpra com o exposto no regulamento interno e todas as alterações do plano curricular de
            ensino e aprendizagem.
        </p>

        {{-- Assinatura --}}
        <div style="text-align: center; margin-top: 100px;">
            <p style="font-size: 12pt; margin-bottom: 80px;">
                Nampula, aos _______ de _______________________ de 20____
            </p>
            <div style="font-size: 12pt; margin-bottom: 60px;">O declarante</div>
            <div style="border-top: 1px solid #000; width: 250px; display: inline-block;"></div>
        </div>
    </div>
</body>
</html>
